/*
 * Decompiled with CFR 0.152.
 */
package org.kde.kjas.server;

import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AudioClip;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import org.kde.javascript.JSObject;
import org.kde.kjas.server.KJASAppletClassLoader;
import org.kde.kjas.server.KJASAppletStub;
import org.kde.kjas.server.KJASAudioClip;
import org.kde.kjas.server.KJASAuthenticator;
import org.kde.kjas.server.Main;

public class KJASAppletContext
implements AppletContext {
    private static final KJASAuthenticator authenticator = new KJASAuthenticator();
    private Hashtable stubs = new Hashtable();
    private Hashtable images = new Hashtable();
    private Vector pendingImages = new Vector();
    private Hashtable streams = new Hashtable();
    private Stack jsobjects = new Stack();
    private String myID;
    private KJASAppletClassLoader loader;
    private boolean active;

    public String getID() {
        return this.myID;
    }

    public String getAppletID(Applet applet) {
        Enumeration enumeration = this.stubs.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            KJASAppletStub kJASAppletStub = (KJASAppletStub)this.stubs.get(string);
            if (kJASAppletStub.getApplet() != applet) continue;
            return string;
        }
        return null;
    }

    public Applet getAppletById(String string) {
        return ((KJASAppletStub)this.stubs.get(string)).getApplet();
    }

    public String getAppletName(String string) {
        KJASAppletStub kJASAppletStub = (KJASAppletStub)this.stubs.get(string);
        if (kJASAppletStub == null) {
            return null;
        }
        return kJASAppletStub.getAppletName();
    }

    public void createApplet(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, Hashtable hashtable) {
        Object object;
        String string13 = new String("ARCHIVE");
        if (hashtable.containsKey(string13)) {
            object = (String)hashtable.get(string13);
            if (string9 == null) {
                string9 = object;
            } else if (!((String)object).toLowerCase().endsWith(".cab")) {
                string9 = (String)object + ',' + string9;
            }
        } else if (string9 != null) {
            hashtable.put(string13, string9);
        }
        if (string8 == null && hashtable.containsKey(string13 = new String("CODEBASE"))) {
            string8 = (String)hashtable.get(string13);
        }
        if (string5 != null && !string5.equals("")) {
            try {
                object = new URL(string4);
                int n = ((URL)object).getPort();
                if (n < 0) {
                    n = ((URL)object).getDefaultPort();
                }
                authenticator.addURL(new URL(((URL)object).getProtocol(), ((URL)object).getHost(), n, ""), string5, string6, string7);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        try {
            Iterator iterator;
            object = "";
            TreeSet<String> treeSet = new TreeSet<String>();
            if (string9 != null) {
                iterator = new StringTokenizer(string9, ",", false);
                while (((StringTokenizer)((Object)iterator)).hasMoreTokens()) {
                    treeSet.add(((StringTokenizer)((Object)iterator)).nextToken().trim());
                }
            }
            iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                object = (String)object + (String)iterator.next();
            }
            KJASAppletClassLoader kJASAppletClassLoader = KJASAppletClassLoader.getLoader(string4, string8, (String)object);
            iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                kJASAppletClassLoader.addArchiveName((String)iterator.next());
            }
            kJASAppletClassLoader.paramsDone();
            KJASAppletStub kJASAppletStub = new KJASAppletStub(this, string, kJASAppletClassLoader.getCodeBase(), kJASAppletClassLoader.getDocBase(), string2, string3, new Dimension(Integer.parseInt(string10), Integer.parseInt(string11)), hashtable, string12, kJASAppletClassLoader);
            this.stubs.put(string, kJASAppletStub);
            kJASAppletStub.createApplet();
        }
        catch (Exception exception) {
            Main.kjas_err("Something bad happened in createApplet: " + exception, exception);
        }
    }

    public void initApplet(String string) {
        KJASAppletStub kJASAppletStub = (KJASAppletStub)this.stubs.get(string);
        if (kJASAppletStub == null) {
            Main.debug("could not init and show applet: " + string);
        } else {
            kJASAppletStub.initApplet();
        }
    }

    public void destroyApplet(String string) {
        KJASAppletStub kJASAppletStub = (KJASAppletStub)this.stubs.get(string);
        if (kJASAppletStub == null) {
            Main.debug("could not destroy applet: " + string);
        } else {
            this.stubs.remove(string);
            kJASAppletStub.destroyApplet();
        }
    }

    public void startApplet(String string) {
        KJASAppletStub kJASAppletStub = (KJASAppletStub)this.stubs.get(string);
        if (kJASAppletStub == null) {
            Main.debug("could not start applet: " + string);
        } else {
            kJASAppletStub.startApplet();
        }
    }

    public void stopApplet(String string) {
        KJASAppletStub kJASAppletStub = (KJASAppletStub)this.stubs.get(string);
        if (kJASAppletStub == null) {
            Main.debug("could not stop applet: " + string);
        } else {
            kJASAppletStub.stopApplet();
        }
    }

    public void destroy() {
        Enumeration enumeration = this.stubs.elements();
        while (enumeration.hasMoreElements()) {
            KJASAppletStub kJASAppletStub = (KJASAppletStub)enumeration.nextElement();
            kJASAppletStub.destroyApplet();
            kJASAppletStub.loader.getJSReferencedObjects().clear();
        }
        this.stubs.clear();
        this.active = false;
    }

    public Applet getApplet(String string) {
        if (this.active) {
            Enumeration enumeration = this.stubs.elements();
            while (enumeration.hasMoreElements()) {
                KJASAppletStub kJASAppletStub = (KJASAppletStub)enumeration.nextElement();
                if (!kJASAppletStub.getAppletName().equals(string)) continue;
                return kJASAppletStub.getApplet();
            }
        }
        return null;
    }

    public Enumeration getApplets() {
        if (this.active) {
            Vector<Applet> vector = new Vector<Applet>();
            Enumeration enumeration = this.stubs.elements();
            while (enumeration.hasMoreElements()) {
                KJASAppletStub kJASAppletStub = (KJASAppletStub)enumeration.nextElement();
                vector.add(kJASAppletStub.getApplet());
            }
            return vector.elements();
        }
        return null;
    }

    public AudioClip getAudioClip(URL uRL) {
        Main.debug("getAudioClip, url = " + uRL);
        KJASAudioClip kJASAudioClip = new KJASAudioClip(uRL);
        Main.debug("got AudioClip " + kJASAudioClip);
        return kJASAudioClip;
    }

    public void addImage(String string, byte[] byArray) {
        Main.debug("addImage for url = " + string);
        this.images.put(string, byArray);
        if (Main.cacheImages) {
            this.pendingImages.remove(string);
        }
    }

    public Image getImage(URL uRL) {
        if (this.active && uRL != null) {
            if (this.loader != null) {
                uRL = this.loader.findResource(uRL.toString());
            }
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Image image = toolkit.createImage(uRL);
            return image;
        }
        return null;
    }

    public void showDocument(URL uRL) {
        if (this.active && uRL != null) {
            Main.protocol.sendShowDocumentCmd(this.myID, uRL.toString());
        }
    }

    public void showDocument(URL uRL, String string) {
        if (this.active && uRL != null && string != null) {
            Main.protocol.sendShowDocumentCmd(this.myID, uRL.toString(), string);
        }
    }

    public void showStatus(String string) {
        if (this.active && string != null) {
            Main.protocol.sendShowStatusCmd(this.myID, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean evaluateJavaScript(String string, String string2, JSObject jSObject) {
        KJASAppletStub kJASAppletStub = (KJASAppletStub)this.stubs.get(string2);
        if (this.active && kJASAppletStub != null && kJASAppletStub.isLoaded()) {
            Object object;
            if (jSObject != null) {
                object = this.jsobjects;
                synchronized (object) {
                    this.jsobjects.push(jSObject);
                }
            }
            object = new int[]{5};
            String[] stringArray = new String[]{string};
            Main.protocol.sendJavaScriptEventCmd(this.myID, string2, 0, "eval", (int[])object, stringArray);
            return true;
        }
        Main.debug("evaluateJavaScript failure, context active:" + this.active + " stub:" + kJASAppletStub);
        return false;
    }

    public boolean getMember(String string, int n, int n2, String string2) {
        KJASAppletStub kJASAppletStub = (KJASAppletStub)this.stubs.get(string);
        if (kJASAppletStub == null || !kJASAppletStub.isLoaded()) {
            return false;
        }
        return kJASAppletStub.getMember(n, n2, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean putMember(String string, int n, int n2, String string2, String string3) {
        Object object;
        if (string2.equals("__lc_ret")) {
            Main.debug("putValue: applet " + string2 + '=' + string3);
            object = null;
            Stack stack = this.jsobjects;
            synchronized (stack) {
                if (!this.jsobjects.empty()) {
                    object = (JSObject)this.jsobjects.pop();
                }
                // MONITOREXIT @DISABLED, blocks:[0, 2, 8] lbl9 : MonitorExitStatement: MONITOREXIT : var7_7
                if (object == null) {
                    return false;
                }
            }
            ((JSObject)object).returnvalue = string3;
            try {
                ((JSObject)object).thread.interrupt();
            }
            catch (SecurityException securityException) {}
            Main.protocol.sendPutMember(this.myID, n, true);
        }
        if ((object = (KJASAppletStub)this.stubs.get(string)) != null && ((KJASAppletStub)object).isLoaded()) {
            return ((KJASAppletStub)object).putMember(n, n2, string2, string3);
        }
        return false;
    }

    public Object getJSReferencedObject(Applet applet, int n) {
        return ((KJASAppletClassLoader)applet.getClass().getClassLoader()).getJSReferencedObjects().get(new Integer(n));
    }

    boolean callMember(String string, int n, int n2, String string2, List list) {
        KJASAppletStub kJASAppletStub = (KJASAppletStub)this.stubs.get(string);
        if (kJASAppletStub == null || !kJASAppletStub.isLoaded()) {
            return false;
        }
        return kJASAppletStub.callMember(n, n2, string2, list);
    }

    public void derefObject(String string, int n) {
        if (n == 0) {
            return;
        }
        KJASAppletStub kJASAppletStub = (KJASAppletStub)this.stubs.get(string);
        if (kJASAppletStub == null) {
            return;
        }
        Hashtable hashtable = kJASAppletStub.loader.getJSReferencedObjects();
        if (hashtable.remove(new Integer(n)) == null) {
            Main.debug("couldn't remove referenced object");
        }
    }

    public void setStream(String string, InputStream inputStream) throws IOException {
        Main.debug("setStream, key = " + string);
        this.streams.put(string, inputStream);
    }

    public InputStream getStream(String string) {
        Main.debug("getStream, key = " + string);
        return (InputStream)this.streams.get(string);
    }

    public Iterator getStreamKeys() {
        Main.debug("getStreamKeys");
        return this.streams.keySet().iterator();
    }

    public KJASAppletContext(String string) {
        this.myID = string;
        this.active = true;
    }
}

