/*
 * This file is part of telepathy-presence-applet
 *
 * Copyright (C) 2011 Francesco Nwokeka <francesco.nwokeka@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

import Qt 4.7
import org.kde.plasma.graphicswidgets 0.1 as PlasmaWidgets

Item {
    id: avatarItem;

    property string avatarPath;
    property string presence;
    property string statusColor: "grey";

    signal avatarChanged(variant newAvatarSource);

    // avatar image is 48. The extra 10 pixels are for border to indicate status
    width: 58;
    height: 58;

    Component.onCompleted: {
        setPresenceColor(presence);
    }

    Rectangle {
        id: statusRect;
        anchors.fill: parent;
        radius: 5;
        opacity: 0.5;

        gradient:
            Gradient {
                GradientStop {
                    position: 0.0;
                    color: "transparent";
                }
                GradientStop {
                    position: 0.4;
                    color: statusColor;
                }
            }
    }

    PlasmaWidgets.IconWidget {
        id: avatarIcon;
        anchors.centerIn: parent;
        width: parent.width - 10;
        height: parent.height- 10;

        Component.onCompleted: {
            setIcon(avatarPath);
        }

        // set avatar
        onClicked: {
            var selectAvatarDialog = new OpenFileDialog;
            selectAvatarDialog.filter = "*.png *.jpg *.jpeg";
            selectAvatarDialog.accepted.connect(openFileDialogAccepted);
            selectAvatarDialog.finished.connect(openFileDialogFinished);
            selectAvatarDialog.show();
        }
    }

    // set presence color
    function setPresenceColor(presenceToGetColorFrom)
    {
        var isOffline = false;
//        presenceToGetColorFrom.toLower();

        if (presenceToGetColorFrom == "online" || presenceToGetColorFrom == "available") {
            statusColor = "green";
        } else if (presenceToGetColorFrom == "busy") {
            statusColor = "red";
        } else if (presenceToGetColorFrom == "away" || presenceToGetColorFrom == "away-extended") {
            statusColor = "yellow";
        } else if (presenceToGetColorFrom == "invisibe" || presenceToGetColorFrom == "hidden") {
            statusColor = "grey";
        } else if (presenceToGetColorFrom == "offline") {
            statusColor = "grey";
            isOffline = true;
        }

        // disable and enable avatar IconWidget related to status
        if (isOffline) {
            avatarIcon.enabled = false;
        } else {
            avatarIcon.enabled = true;
        }
    }

    // slot to receive openFIleDialog Accepted signal
    function openFileDialogAccepted(dialog)
    {
        var newAvatar = dialog.file;
        avatarItem.avatarChanged(dialog.file);
    }

    // slot to receive openFileDialog Finished signal
    function openFileDialogFinished(dialog)
    {
        dialog.accepted.disconnect(openFileDialogAccepted);
        dialog.finished.disconnect(openFileDialogFinished);
        plasmoid.gc();  // supposed to be a call to the garbage collector
    }

    // used from outside the "Avatar" component
    function setAvatar(newAvatarPath)
    {
        avatarPath = newAvatarPath;
        avatarIcon.icon = QIcon(avatarPath);
    }
}
