/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGSIMPLEPERIODEDIT_H
#define SKGSIMPLEPERIODEDIT_H
/** @file
 * A simple period selector.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */

#include <qdatetime.h>
#include <qflags.h>

#include "skgcombobox.h"
#include "skgbasegui_export.h"
/**
 * This file is a simple period selector.
 */
class SKGBASEGUI_EXPORT SKGSimplePeriodEdit : public SKGComboBox
{
    Q_OBJECT
    /**
     * First date
     */
    Q_PROPERTY(QDate firstDate READ firstDate WRITE setFirstDate NOTIFY changed USER true)

    /**
     * Previous mode
     */
    Q_PROPERTY(Modes mode READ mode WRITE setMode NOTIFY changed)

    /**
     * Period
     */
    Q_PROPERTY(QString period READ period NOTIFY changed)

    /**
     * This enumerate for additional options in menu
     */
    Q_ENUMS(Mode)

public:
    /**
     * This enumerate for mode
     */
    enum Mode {
        NONE = 0,                                              /**< None */
        PREVIOUS_MONTHS = 1,                                   /**< Only previous months */
        PREVIOUS_PERIODS = 2,                                  /**< All previous periods including quarters, semesters and years*/
        CURRENT_MONTHS = 4,                                    /**< Current month */
        CURRENT_PERIOD = 8,                                    /**< Current period including quarter, semester and year */
        ALL = 16,                                              /**< The ALL period */
        PREVIOUS_AND_CURRENT_MONTHS = 1 | 4,                   /**< Previous and current months*/
        PREVIOUS_AND_CURRENT_PERIODS = 1 | 2 | 4 | 8,          /**< Previous and current periods including quarters, semesters and years*/
        ALL_PERIODS =  1 | 2 | 4 | 8 | 16                      /**< All periods*/
    };

    Q_DECLARE_FLAGS(Modes, Mode)

    /**
     * Default Constructor
     * @param iParent the parent
     */
    explicit SKGSimplePeriodEdit(QWidget* iParent);

    /**
     * Default Destructor
     */
    virtual ~SKGSimplePeriodEdit();

    /**
     * Get the period
     * @return the period
     */
    virtual QString period() const;

    /**
     * Get the first date to take into account
     * @return the first date to take into account
     */
    virtual QDate firstDate() const;

    /**
     * Set the first date to take into account
     * @param iDate the first date to take into account
     */
    // cppcheck-suppress passedByValue
    virtual void setFirstDate(const QDate iDate);

    /**
     * To know if the mode of widget (default: PREVIOUS_MONTHS)
     * @return previous mode
     */
    virtual Modes mode() const;

    /**
     * Set the widget mode
     * @param iMode the mode
     */
    virtual void setMode(Modes iMode);

Q_SIGNALS:
    /**
     * Emmited when the changed
     */
    void changed();

private:
    QDate m_FirstDate;
    Modes m_Mode;

    void refreshList();
};

Q_DECLARE_OPERATORS_FOR_FLAGS(SKGSimplePeriodEdit::Modes)

#endif  // SKGSIMPLEPERIODEDIT_H
