/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is a test script.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestmacro.h"
#include "skgimportexportmanager.h"
#include "skgbankincludes.h"


struct test {
    QString fileName;
    QString password;
    QMap<QString, double> expectedAccountAmount;
};

/**
 * The main function of the unit test
 * @param argc the number of arguments
 * @param argv the list of arguments
 */
int main(int argc, char** argv)
{
    Q_UNUSED(argc);
    Q_UNUSED(argv);

    // Init test
    SKGINITTEST(true);

    {
        // Test import MNY
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT_MNY", err);
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath("IN") % "/skgtestimportmny1/A B/money2002.mny"));
            QMap<QString, QString> params = imp1.getImportParameters();
            params["install_sunriise"] = 'Y';
            imp1.setImportParameters(params);
            SKGTESTERROR("imp1.importFile", imp1.importFile(), true);

            SKGAccountObject account(&document1);
            SKGTESTERROR("MNY.setName", account.setName("None Investment"), true);
            SKGTESTERROR("MNY.load", account.load(), true);
            SKGTEST("MNY.getCurrentAmount", SKGServices::doubleToString(account.getCurrentAmount()), "1.49");
        }

        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT_MNY", err);
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath("IN") % "/skgtestimportmny1/A B/money2002.mny"));
            QMap<QString, QString> params = imp1.getImportParameters();
            params["install_sunriise"] = 'Y';
            imp1.setImportParameters(params);
            SKGTESTERROR("imp1.importFile", imp1.importFile(), true);

            SKGAccountObject account(&document1);
            SKGTESTERROR("MNY.setName", account.setName("None Investment"), true);
            SKGTESTERROR("MNY.load", account.load(), true);
            SKGTEST("MNY.getCurrentAmount", SKGServices::doubleToString(account.getCurrentAmount()), "1.49");
        }
    }

    {
        // Test import MNY
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT_MNY", err);
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath("IN") % "/skgtestimportmny1/notreadable.mny"));
            QMap<QString, QString> params = imp1.getImportParameters();
            params["install_sunriise"] = 'Y';
            imp1.setImportParameters(params);
            SKGTEST("imp1.importFile", imp1.importFile().getReturnCode(), ERR_READACCESS);
        }
    }

    {
        // Test import MNY
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT_MNY", err);
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath("IN") % "/skgtestimportmny3/transfert_and_mode.mny"));
            QMap<QString, QString> params = imp1.getImportParameters();
            params["install_sunriise"] = 'Y';
            imp1.setImportParameters(params);
            SKGTESTERROR("imp1.importFile", imp1.importFile(), true);
        }

        bool test2 = false;
        SKGTESTERROR("MNY.existObjects", document1.existObjects("operation", "t_comment='Mode should be ''text''' AND t_mode='text'", test2), true);
        SKGTEST("MNY.existObjects-test", static_cast<unsigned int>(test2), static_cast<unsigned int>(true));

        SKGTESTERROR("MNY.existObjects", document1.existObjects("operation", "t_comment='Number should be 123456' AND i_number=123456", test2), true);
        SKGTEST("MNY.existObjects-test", static_cast<unsigned int>(test2), static_cast<unsigned int>(true));

        SKGTESTERROR("MNY.existObjects", document1.existObjects("operation", "t_comment='True transfert' AND i_group_id<>0", test2), true);
        SKGTEST("MNY.existObjects-test", static_cast<unsigned int>(test2), static_cast<unsigned int>(true));

        SKGTESTERROR("MNY.existObjects", document1.existObjects("operation", "t_comment='Not a transfert, just same date/amount' AND i_group_id=0", test2), true);
        SKGTEST("MNY.existObjects-test", static_cast<unsigned int>(test2), static_cast<unsigned int>(true));
    }

    // End test
    SKGENDTEST();
}
