/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGALARMBOARDWIDGET_H
#define SKGALARMBOARDWIDGET_H
/** @file
* This file is Skrooge dashbord plugin for alarms.
*
* @author Stephane MANKOWSKI / Guillaume DE BURE
*/
#include "skgboardwidget.h"

class QVBoxLayout;
class QFrame;
class QAction;

/**
 * This file is Skrooge dashbord plugin for alarms
 */
class SKGAlarmBoardWidget : public SKGBoardWidget
{
    Q_OBJECT

public:
    /**
     * Default Constructor
     */
    explicit SKGAlarmBoardWidget(SKGDocument* iDocument);

    /**
     * Default Destructor
     */
    virtual ~SKGAlarmBoardWidget();

    /**
     * Get the current state
     * MUST BE OVERWRITTEN
     * @return a string containing all information needed to set the same state.
     * Could be an XML stream
     */
    virtual QString getState() Q_DECL_OVERRIDE;

    /**
     * Set the current state
     * MUST BE OVERWRITTEN
     * @param iState must be interpreted to set the state of the widget
     */
    virtual void setState(const QString& iState) Q_DECL_OVERRIDE;

private Q_SLOTS:
    void dataModified(const QString& iTableName = QString(), int iIdTransaction = 0);

private:
    Q_DISABLE_COPY(SKGAlarmBoardWidget)
    QAction* m_menuFavorite;
    QFrame* m_frame;
    QVBoxLayout* m_layout;
};

#endif  // SKGALARMBOARDWIDGET_H
