/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
* This file defines classes SKGAdviceDataEngine.
*
* @author Stephane MANKOWSKI / Guillaume DE BURE
 */

#include "skgadvicedataengine.h"
#include "skgmainpanel.h"
#include "skginterfaceplugin.h"
#include "skgdocument.h"

SKGAdviceDataEngine::SKGAdviceDataEngine(QObject* iParent, const QVariantList& args): DataEngine(iParent, args)
{}

SKGAdviceDataEngine::~SKGAdviceDataEngine()
{}

void SKGAdviceDataEngine::init()
{
    Plasma::DataEngine::init();

    // Get the document behind the current document
    SKGMainPanel* panel = SKGMainPanel::getMainPanel();
    if (panel) document = (panel->getDocument());

    // Whenever a table is modified, update sources
    connect(document, SIGNAL(tableModified(QString,int)), this, SLOT(updateAllSources()));
}


bool SKGAdviceDataEngine::updateSourceEvent(const QString& source)
{
    if (source != "skrooge") {
        return false;
    }

    // Get list of ignored advice
    QString currentMonth = QDate::currentDate().toString("yyyy-MM");
    QStringList ignoredAdvice = document->getParameters("advice", "t_value='I' OR t_value='I_" % currentMonth % '\'');

    // Build the list of all advice by requesting all plugins
    int index = 0;
    while (index >= 0) {
        SKGInterfacePlugin* plugin = SKGMainPanel::getMainPanel()->getPluginByIndex(index);
        if (plugin) {
            foreach(const SKGAdvice & advice, plugin->advice(ignoredAdvice)) {
                if (!ignoredAdvice.contains(advice.getUUID()) && !ignoredAdvice.contains(SKGServices::splitCSVLine(advice.getUUID(), '|').at(0))) {
                    QVariantHash values;
                    values["priority"] = SKGServices::intToString(advice.getPriority());
                    values["shortMessage"] = advice.getShortMessage();
                    values["longMessage"] = advice.getLongMessage();
                    values["correction"] = advice.getAutoCorrections();

                    setData("skrooge", advice.getUUID(), values);
                }
            }
        } else {
            index = -2;
        }
        ++index;
    }

    return true;
}
