/*
    This file is part of KOrganizer.
    Copyright (c) 2002 Steffen Hansen,
    Klaraelvdalens Datakonsult <steffem@klaralvdalens-datakonsult.se>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#ifndef KONOTESVIEW_H
#define KONOTESVIEW_H
// $Id: konotesview.h,v 1.1.2.9 2003/06/16 14:55:12 steffen Exp $

#include <qptrlist.h>
#include <qfontmetrics.h>
#include <qmap.h>

#include <kxmlguibuilder.h>
#include <kxmlguiclient.h>

#include <libkcal/calendar.h>
#include <libkcal/event.h>

#include "korganizer/baseview.h"

class QLineEdit;
class QFont;
class QLabel;
class QPopupMenu;
class QIconView;
class QIconViewItem;
class NotesIconView;
class KNote;

class XMLGUIFactory;
class KInstance;
class QPopupMenu;

class Note {
public:
  Note() : color(Qt::yellow) {}

  bool operator==( const Note& other ) {
    return id == other.id && geometry == other.geometry
      && color == other.color && text == other.text;
  }

  QString id;
  QString geometry;
  QColor color;
  QString text;
};

class KONotesView : public KOrg::BaseView, virtual public KXMLGUIClient
{
    Q_OBJECT
  public:
    friend class NotesIconView;

    KONotesView(Calendar *, QWidget* parent=0, const char* name=0 );
    ~KONotesView();

    QPtrList<Incidence> selectedIncidences();
    DateList selectedDates();

    /** Return number of shown dates. */
    int currentDateCount() { return 0; }

    void readSettings();
    void writeSettings(KConfig *);

    void updateNote( const Note& );
    void deleteNote( const Note& );

public slots:
    void newNote();


    void updateView();
    void updateConfig();

    void changeEventDisplay(Event *, int);

    void showDates(const QDate &start, const QDate &end);
    void showDates(const QDateTime &start, const QDateTime &end);
    void showEvents(QPtrList<Event> eventList);

    void slotNoteActivated( QIconViewItem* item );

    void slotDelete();
    void slotClose();

    void slotSync(bool);

protected slots:
    void processSelectionChange();
    void slotPopupNoteMenu( QIconViewItem*, const QPoint& );
  /*
signals:
    void newTodoSignal();
    void newSubTodoSignal(Todo *);
    void showTodoSignal(Todo *);
    void editTodoSignal(Todo *);
    void deleteTodoSignal(Todo *);
  */
signals:
  void noteNewOrUpdated( const Note& note );
  void noteDeleted( const Note& note );

private:
  bool blockUpdating;
  NotesIconView *mIconView;
  KNote* getKNote( const QString& );
  QPtrList<KNote> mOpenNotes;

  QPopupMenu* m_notemenu;
  QPopupMenu* m_menu;
};

#endif
