/*
   Copyright (c) 2020-2021 Laurent Montel <montel@kde.org>

   This library is free software; you can redistribute it and/or modify
   it under the terms of the GNU Library General Public License as published
   by the Free Software Foundation; either version 2 of the License or
   ( at your option ) version 3 or, at the discretion of KDE e.V.
   ( which shall act as a proxy as in section 14 of the GPLv3 ), any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#pragma once

#include "libruqolawidgets_export.h"
#include <QLabel>
#include <QWidget>

class LIBRUQOLAWIDGETS_EXPORT ClickableLabel : public QLabel
{
    Q_OBJECT
public:
    explicit ClickableLabel(QWidget *parent = nullptr);
    ~ClickableLabel() override;

Q_SIGNALS:
    void clicked();

protected:
    void mousePressEvent(QMouseEvent *event) override;
};

class LIBRUQOLAWIDGETS_EXPORT ClickableWidget : public QWidget
{
    Q_OBJECT
public:
    explicit ClickableWidget(const QString &userName, QWidget *parent = nullptr);
    ~ClickableWidget() override;

    Q_REQUIRED_RESULT QString name() const;
    void setName(const QString &userName);

    Q_REQUIRED_RESULT QString identifier() const;
    void setIdentifier(const QString &userId);

Q_SIGNALS:
    void removeClickableWidget(const QString &username);

private:
    void slotRemove();
    QString mName;
    QString mIdentifier;
    QLabel *const mLabel;
    ClickableLabel *const mClickableLabel;
};
