/*
   Copyright (c) 2018-2021 Laurent Montel <montel@kde.org>

   This library is free software; you can redistribute it and/or modify
   it under the terms of the GNU Library General Public License as published
   by the Free Software Foundation; either version 2 of the License or
   ( at your option ) version 3 or, at the discretion of KDE e.V.
   ( which shall act as a proxy as in section 14 of the GPLv3 ), any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#include "loginmethodmodel.h"
#include "ruqola_debug.h"
#include <QModelIndex>

LoginMethodModel::LoginMethodModel(QObject *parent)
    : QAbstractListModel(parent)
{
}

LoginMethodModel::~LoginMethodModel()
{
}

int LoginMethodModel::rowCount(const QModelIndex &parent) const
{
    Q_UNUSED(parent)
    return mAuthentications.count();
}

void LoginMethodModel::clear()
{
    if (!mAuthentications.isEmpty()) {
        beginRemoveRows(QModelIndex(), 0, mAuthentications.count() - 1);
        mAuthentications.clear();
        endRemoveRows();
    }
}

AuthenticationManager::OauthType LoginMethodModel::loginType(int index)
{
    return mAuthentications.at(index).oauthType();
}

int LoginMethodModel::currentLoginMethod() const
{
    return mCurrentLoginMethod;
}

void LoginMethodModel::setCurrentLoginMethod(int currentLoginMethod)
{
    if (mCurrentLoginMethod != currentLoginMethod) {
        mCurrentLoginMethod = currentLoginMethod;
        Q_EMIT currentLoginMethodChanged();
    }
}

QVector<AuthenticationInfo> LoginMethodModel::authentications() const
{
    return mAuthentications;
}

QVariant LoginMethodModel::data(const QModelIndex &index, int role) const
{
    if (index.row() < 0 || index.row() >= mAuthentications.count()) {
        return QVariant();
    }

    const AuthenticationInfo info = mAuthentications.at(index.row());
    switch (role) {
    case Name:
        return info.name();
    case IconName:
        return info.iconName();
    case Type:
        return info.oauthType();
    }

    return {};
}

void LoginMethodModel::setAuthenticationInfos(const QVector<AuthenticationInfo> &infos)
{
    if (rowCount() != 0) {
        beginRemoveRows(QModelIndex(), 0, mAuthentications.count() - 1);
        mAuthentications.clear();
        endRemoveRows();
    }
    if (!infos.isEmpty()) {
        beginInsertRows(QModelIndex(), 0, infos.count() - 1);
        mAuthentications = infos;
        endInsertRows();
    }
}
