.TH PYTHON "1" "$Date$"

.\" To view this file while editing, run it through groff:
.\"   groff -Tascii -man python.man | less

.SH NAME
python \- an interpreted, interactive, object-oriented programming language
.SH SYNOPSIS
.B python
[
.B \-B
]
[
.B \-b
]
[
.B \-d
]
[
.B \-E
]
[
.B \-h
]
[
.B \-i
]
[
.B \-I
]
.br
       [
.B \-m
.I module-name
]
[
.B \-q
]
[
.B \-O
]
[
.B \-OO
]
[
.B \-s
]
[
.B \-S
]
[
.B \-u
]
.br
       [
.B \-v
]
[
.B \-V
]
[
.B \-W
.I argument
]
[
.B \-x
]
[
[
.B \-X
.I option
]
.B \-?
]
.br
       [
.B \-c
.I command
|
.I script
|
\-
]
[
.I arguments
]
.SH DESCRIPTION
Python is an interpreted, interactive, object-oriented programming
language that combines remarkable power with very clear syntax.
For an introduction to programming in Python, see the Python Tutorial.
The Python Library Reference documents built-in and standard types,
constants, functions and modules.
Finally, the Python Reference Manual describes the syntax and
semantics of the core language in (perhaps too) much detail.
(These documents may be located via the
.B "INTERNET RESOURCES"
below; they may be installed on your system as well.)
.PP
Python's basic power can be extended with your own modules written in
C or C++.
On most systems such modules may be dynamically loaded.
Python is also adaptable as an extension language for existing
applications.
See the internal documentation for hints.
.PP
Documentation for installed Python modules and packages can be 
viewed by running the 
.B pydoc
program.  
.SH COMMAND LINE OPTIONS
.TP
.B \-B
Don't write
.I .py[co]
files on import. See also PYTHONDONTWRITEBYTECODE.
.TP
.B \-b
Issue warnings about str(bytes_instance), str(bytearray_instance)
and comparing bytes/bytearray with str. (-bb: issue errors)
.TP
.BI "\-c " command
Specify the command to execute (see next section).
This terminates the option list (following options are passed as
arguments to the command).
.TP
.B \-d
Turn on parser debugging output (for wizards only, depending on
compilation options).
.TP
.B \-E
Ignore environment variables like PYTHONPATH and PYTHONHOME that modify
the behavior of the interpreter.
.TP
.B \-h ", " \-? ", "\-\-help
Prints the usage for the interpreter executable and exits.
.TP
.B \-i
When a script is passed as first argument or the \fB\-c\fP option is
used, enter interactive mode after executing the script or the
command.  It does not read the $PYTHONSTARTUP file.  This can be
useful to inspect global variables or a stack trace when a script
raises an exception.
.TP
.B \-I
Run Python in isolated mode. This also implies \fB\-E\fP and \fB\-s\fP. In
isolated mode sys.path contains neither the script’s directory nor the user’s
site-packages directory. All PYTHON* environment variables are ignored, too.
Further restrictions may be imposed to prevent the user from injecting
malicious code.
.TP
.BI "\-m " module-name
Searches 
.I sys.path 
for the named module and runs the corresponding 
.I .py 
file as a script.
.TP
.B \-O
Turn on basic optimizations.  This changes the filename extension for
compiled (bytecode) files from
.I .pyc
to \fI.pyo\fP.  Given twice, causes docstrings to be discarded.
.TP
.B \-OO
Discard docstrings in addition to the \fB-O\fP optimizations.
.TP
.B \-q
Do not print the version and copyright messages. These messages are 
also suppressed in non-interactive mode.
.TP
.B \-s
Don't add user site directory to sys.path.
.TP
.B \-S
Disable the import of the module
.I site
and the site-dependent manipulations of
.I sys.path
that it entails.  Also disable these manipulations if
.I site
is explicitly imported later.
.TP
.B \-u
Force the binary I/O layers of stdout and stderr to be unbuffered.
stdin is always buffered.
The text I/O layer will still be line-buffered.
.\" Note that there is internal buffering in readlines() and
.\" file-object iterators ("for line in sys.stdin") which is not
.\" influenced by this option.  To work around this, you will want to use
.\" "sys.stdin.readline()" inside a "while 1:" loop.
.TP
.B \-v
Print a message each time a module is initialized, showing the place
(filename or built-in module) from which it is loaded.  When given
twice, print a message for each file that is checked for when 
searching for a module.  Also provides information on module cleanup
at exit.
.TP
.B \-V ", " \-\-version
Prints the Python version number of the executable and exits.
.TP
.BI "\-W " argument
Warning control.  Python sometimes prints warning message to
.IR sys.stderr .
A typical warning message has the following form:
.IB file ":" line ": " category ": " message.
By default, each warning is printed once for each source line where it
occurs.  This option controls how often warnings are printed.
Multiple
.B \-W
options may be given; when a warning matches more than one
option, the action for the last matching option is performed.
Invalid
.B \-W
options are ignored (a warning message is printed about invalid
options when the first warning is issued).  Warnings can also be
controlled from within a Python program using the
.I warnings
module.

The simplest form of
.I argument
is one of the following
.I action
strings (or a unique abbreviation):
.B ignore
to ignore all warnings;
.B default
to explicitly request the default behavior (printing each warning once
per source line);
.B all
to print a warning each time it occurs (this may generate many
messages if a warning is triggered repeatedly for the same source
line, such as inside a loop);
.B module
to print each warning only the first time it occurs in each
module;
.B once
to print each warning only the first time it occurs in the program; or
.B error
to raise an exception instead of printing a warning message.

The full form of
.I argument
is
.IB action : message : category : module : line.
Here,
.I action
is as explained above but only applies to messages that match the
remaining fields.  Empty fields match all values; trailing empty
fields may be omitted.  The
.I message
field matches the start of the warning message printed; this match is
case-insensitive.  The
.I category
field matches the warning category.  This must be a class name; the
match test whether the actual warning category of the message is a
subclass of the specified warning category.  The full class name must
be given.  The
.I module
field matches the (fully-qualified) module name; this match is
case-sensitive.  The
.I line
field matches the line number, where zero matches all line numbers and
is thus equivalent to an omitted line number.
.TP
.BI "\-X " option
Set implementation specific option.
.TP
.B \-x
Skip the first line of the source.  This is intended for a DOS
specific hack only.  Warning: the line numbers in error messages will
be off by one!
.SH INTERPRETER INTERFACE
The interpreter interface resembles that of the UNIX shell: when
called with standard input connected to a tty device, it prompts for
commands and executes them until an EOF is read; when called with a
file name argument or with a file as standard input, it reads and
executes a
.I script
from that file;
when called with
.B \-c
.IR command ,
it executes the Python statement(s) given as
.IR command .
Here
.I command
may contain multiple statements separated by newlines.
Leading whitespace is significant in Python statements!
In non-interactive mode, the entire input is parsed before it is
executed.
.PP
If available, the script name and additional arguments thereafter are
passed to the script in the Python variable
.IR sys.argv ,
which is a list of strings (you must first
.I import sys
to be able to access it).
If no script name is given,
.I sys.argv[0]
is an empty string; if
.B \-c
is used,
.I sys.argv[0]
contains the string
.I '-c'.
Note that options interpreted by the Python interpreter itself
are not placed in
.IR sys.argv .
.PP
In interactive mode, the primary prompt is `>>>'; the second prompt
(which appears when a command is not complete) is `...'.
The prompts can be changed by assignment to
.I sys.ps1
or
.IR sys.ps2 .
The interpreter quits when it reads an EOF at a prompt.
When an unhandled exception occurs, a stack trace is printed and
control returns to the primary prompt; in non-interactive mode, the
interpreter exits after printing the stack trace.
The interrupt signal raises the
.I Keyboard\%Interrupt
exception; other UNIX signals are not caught (except that SIGPIPE is
sometimes ignored, in favor of the
.I IOError
exception).  Error messages are written to stderr.
.SH FILES AND DIRECTORIES
These are subject to difference depending on local installation
conventions; ${prefix} and ${exec_prefix} are installation-dependent
and should be interpreted as for GNU software; they may be the same.
The default for both is \fI/usr/local\fP.
.IP \fI${exec_prefix}/bin/python\fP
Recommended location of the interpreter.
.PP
.I ${prefix}/lib/python<version>
.br
.I ${exec_prefix}/lib/python<version>
.RS
Recommended locations of the directories containing the standard
modules.
.RE
.PP
.I ${prefix}/include/python<version>
.br
.I ${exec_prefix}/include/python<version>
.RS
Recommended locations of the directories containing the include files
needed for developing Python extensions and embedding the
interpreter.
.RE
.SH ENVIRONMENT VARIABLES
.IP PYTHONHOME
Change the location of the standard Python libraries.  By default, the
libraries are searched in ${prefix}/lib/python<version> and
${exec_prefix}/lib/python<version>, where ${prefix} and ${exec_prefix}
are installation-dependent directories, both defaulting to
\fI/usr/local\fP.  When $PYTHONHOME is set to a single directory, its value
replaces both ${prefix} and ${exec_prefix}.  To specify different values
for these, set $PYTHONHOME to ${prefix}:${exec_prefix}.
.IP PYTHONPATH
Augments the default search path for module files.
The format is the same as the shell's $PATH: one or more directory
pathnames separated by colons.
Non-existent directories are silently ignored.
The default search path is installation dependent, but generally
begins with ${prefix}/lib/python<version> (see PYTHONHOME above).
The default search path is always appended to $PYTHONPATH.
If a script argument is given, the directory containing the script is
inserted in the path in front of $PYTHONPATH.
The search path can be manipulated from within a Python program as the
variable
.IR sys.path .
.IP PYTHONSTARTUP
If this is the name of a readable file, the Python commands in that
file are executed before the first prompt is displayed in interactive
mode.
The file is executed in the same name space where interactive commands
are executed so that objects defined or imported in it can be used
without qualification in the interactive session.
You can also change the prompts
.I sys.ps1
and
.I sys.ps2
in this file.
.IP PYTHONOPTIMIZE
If this is set to a non-empty string it is equivalent to specifying
the \fB\-O\fP option. If set to an integer, it is equivalent to
specifying \fB\-O\fP multiple times.
.IP PYTHONDEBUG
If this is set to a non-empty string it is equivalent to specifying
the \fB\-d\fP option. If set to an integer, it is equivalent to
specifying \fB\-d\fP multiple times.
.IP PYTHONDONTWRITEBYTECODE
If this is set to a non-empty string it is equivalent to specifying
the \fB\-B\fP option (don't try to write
.I .py[co]
files).
.IP PYTHONINSPECT
If this is set to a non-empty string it is equivalent to specifying
the \fB\-i\fP option.
.IP PYTHONIOENCODING
If this is set before running the interpreter, it overrides the encoding used
for stdin/stdout/stderr, in the syntax
.IB encodingname ":" errorhandler
The
.IB errorhandler
part is optional and has the same meaning as in str.encode. For stderr, the
.IB errorhandler
 part is ignored; the handler will always be \'backslashreplace\'.
.IP PYTHONNOUSERSITE
If this is set to a non-empty string it is equivalent to specifying the
\fB\-s\fP option (Don't add the user site directory to sys.path).
.IP PYTHONUNBUFFERED
If this is set to a non-empty string it is equivalent to specifying
the \fB\-u\fP option.
.IP PYTHONVERBOSE
If this is set to a non-empty string it is equivalent to specifying
the \fB\-v\fP option. If set to an integer, it is equivalent to
specifying \fB\-v\fP multiple times. 
.IP PYTHONWARNINGS
If this is set to a comma-separated string it is equivalent to
specifying the \fB\-W\fP option for each separate value.
.IP PYTHONHASHSEED
If this variable is set to "random", a random value is used to seed the hashes
of str, bytes and datetime objects.

If PYTHONHASHSEED is set to an integer value, it is used as a fixed seed for
generating the hash() of the types covered by the hash randomization.  Its
purpose is to allow repeatable hashing, such as for selftests for the
interpreter itself, or to allow a cluster of python processes to share hash
values.

The integer must be a decimal number in the range [0,4294967295].  Specifying
the value 0 will disable hash randomization.
.SH AUTHOR
The Python Software Foundation: https://www.python.org/psf/
.SH INTERNET RESOURCES
Main website:  https://www.python.org/
.br
Documentation:  https://docs.python.org/
.br
Developer resources:  https://docs.python.org/devguide/
.br
Downloads:  https://www.python.org/downloads/
.br
Module repository:  https://pypi.python.org/
.br
Newsgroups:  comp.lang.python, comp.lang.python.announce
.SH LICENSING
Python is distributed under an Open Source license.  See the file
"LICENSE" in the Python source distribution for information on terms &
conditions for accessing and otherwise using Python and for a
DISCLAIMER OF ALL WARRANTIES.
