;; DFA-based pipeline description for P5600.
;;
;; Copyright (C) 2007-2015 Free Software Foundation, Inc.
;;
;; This file is part of GCC.
;;
;; GCC is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published
;; by the Free Software Foundation; either version 3, or (at your
;; option) any later version.

;; GCC is distributed in the hope that it will be useful, but WITHOUT
;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
;; or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
;; License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GCC; see the file COPYING3.  If not see
;; <http://www.gnu.org/licenses/>.

(define_automaton "p5600_agen_alq_pipe, p5600_fpu_pipe")

;; The address generation queue (AGQ) has AL2, CTISTD and LDSTA pipes
(define_cpu_unit "p5600_agq, p5600_al2, p5600_ctistd, p5600_ldsta,
		  p5600_gpdiv" "p5600_agen_alq_pipe")

;; The arithmetic-logic-unit queue (ALQ) has ALU pipe
(define_cpu_unit "p5600_alq, p5600_alu" "p5600_agen_alq_pipe")

;; The floating-point-unit queue (FPQ) has short and long pipes
(define_cpu_unit "p5600_fpu_short, p5600_fpu_long" "p5600_fpu_pipe")

;; Short FPU pipeline
(define_cpu_unit "p5600_fpu_store" "p5600_fpu_pipe")

;; Long FPU pipeline
(define_cpu_unit "p5600_fpu_apu" "p5600_fpu_pipe")

(define_reservation "p5600_agq_al2" "p5600_agq, p5600_al2")
(define_reservation "p5600_agq_ctistd" "p5600_agq, p5600_ctistd")
(define_reservation "p5600_agq_ldsta" "p5600_agq, p5600_ldsta")
(define_reservation "p5600_alq_alu" "p5600_alq, p5600_alu")

;;
;; FPU pipe
;;

;; fadd, fsub
(define_insn_reservation "p5600_fpu_fadd" 4
  (and (eq_attr "cpu" "p5600")
       (eq_attr "type" "fadd,fabs,fneg"))
  "p5600_fpu_long, p5600_fpu_apu")

;; fabs, fneg, fcmp
(define_insn_reservation "p5600_fpu_fabs" 2
  (and (eq_attr "cpu" "p5600")
       (eq_attr "type" "fabs,fneg,fcmp,fmove"))
  "p5600_fpu_short, p5600_fpu_apu")

;; fload
(define_insn_reservation "p5600_fpu_fload" 8
  (and (eq_attr "cpu" "p5600")
       (eq_attr "type" "fpload,fpidxload"))
  "p5600_fpu_long, p5600_fpu_apu")

;; fstore
(define_insn_reservation "p5600_fpu_fstore" 1
  (and (eq_attr "cpu" "p5600")
       (eq_attr "type" "fpstore,fpidxstore"))
  "p5600_fpu_short, p5600_fpu_apu")

;; fmadd
(define_insn_reservation "p5600_fpu_fmadd" 9
  (and (eq_attr "cpu" "p5600")
       (eq_attr "type" "fmadd"))
  "p5600_fpu_long, p5600_fpu_apu")

;; fmul
(define_insn_reservation "p5600_fpu_fmul" 5
  (and (eq_attr "cpu" "p5600")
       (eq_attr "type" "fmul"))
  "p5600_fpu_long, p5600_fpu_apu")

;; fdiv, fsqrt
(define_insn_reservation "p5600_fpu_div" 17
  (and (eq_attr "cpu" "p5600")
       (eq_attr "type" "fdiv,frdiv,fsqrt,frsqrt"))
  "p5600_fpu_long, p5600_fpu_apu*17")

;; fcvt
(define_insn_reservation "p5600_fpu_fcvt" 4
  (and (eq_attr "cpu" "p5600")
       (eq_attr "type" "fcvt"))
  "p5600_fpu_long, p5600_fpu_apu")

;; mtc
(define_insn_reservation "p5600_fpu_fmtc" 7
  (and (eq_attr "cpu" "p5600")
       (eq_attr "type" "mtc"))
  "p5600_fpu_short, p5600_fpu_store")

;; mfc
(define_insn_reservation "p5600_fpu_fmfc" 4
  (and (eq_attr "cpu" "p5600")
       (eq_attr "type" "mfc"))
  "p5600_fpu_short, p5600_fpu_store")

;; madd/msub feeding into the add source
;; madd.fmt dst, x, y, z -> madd.fmt a, dst, b, c 5 cycles
(define_bypass 5 "p5600_fpu_fmadd" "p5600_fpu_fmadd" "mips_fmadd_bypass")

;;
;; Integer pipe
;;

;; and
(define_insn_reservation "p5600_int_and" 1
  (and (eq_attr "cpu" "p5600")
       (eq_attr "move_type" "logical"))
  "p5600_alq_alu")

;; lui
(define_insn_reservation "p5600_int_lui" 1
  (and (eq_attr "cpu" "p5600")
       (eq_attr "move_type" "const"))
  "p5600_alq_alu")

;; Load lb, lbu, lh, lhu, lq, lw, lw_i2f, lwxs
(define_insn_reservation "p5600_int_load" 4
  (and (eq_attr "cpu" "p5600")
       (eq_attr "move_type" "load"))
  "p5600_agq_ldsta")

;; store
(define_insn_reservation "p5600_int_store" 3
  (and (eq_attr "cpu" "p5600")
       (eq_attr "move_type" "store"))
  "p5600_agq_ldsta")

;; andi, sll, srl, seb, seh
(define_insn_reservation "p5600_int_arith_1" 1
  (and (eq_attr "cpu" "p5600")
       (eq_attr "move_type" "andi,sll0,signext"))
  "p5600_alq_alu | p5600_agq_al2")

;; addi, addiu, ori, xori, add, addu
(define_insn_reservation "p5600_int_arith_2" 1
  (and (eq_attr "cpu" "p5600")
       (eq_attr "alu_type" "add,or,xor"))
  "p5600_alq_alu | p5600_agq_al2")

;; nor, sub
(define_insn_reservation "p5600_int_arith_3" 1
  (and (eq_attr "cpu" "p5600")
       (eq_attr "alu_type" "nor,sub"))
  "p5600_alq_alu")

;; srl, sra, rotr, slt, sllv, srlv
(define_insn_reservation "p5600_int_arith_4" 1
  (and (eq_attr "cpu" "p5600")
       (eq_attr "type" "shift,slt,move"))
  "p5600_alq_alu | p5600_agq_al2")

;; nop
(define_insn_reservation "p5600_int_nop" 0
  (and (eq_attr "cpu" "p5600")
       (eq_attr "type" "nop"))
  "p5600_agq_al2")

;; clo, clz
(define_insn_reservation "p5600_int_countbits" 1
  (and (eq_attr "cpu" "p5600")
       (eq_attr "type" "clz"))
  "p5600_agq_al2")

;; Conditional moves
(define_insn_reservation "p5600_int_condmove" 1
  (and (eq_attr "cpu" "p5600")
       (eq_attr "type" "condmove"))
  "p5600_agq_al2")

;; madd, msub
(define_insn_reservation "p5600_dsp_mac" 5
  (and (eq_attr "cpu" "p5600")
       (eq_attr "type" "imadd"))
  "p5600_agq_al2")

;; mfhi/lo
(define_insn_reservation "p5600_dsp_mfhilo" 1
  (and (eq_attr "cpu" "p5600")
       (eq_attr "type" "mfhi,mflo"))
  "p5600_agq_al2")

;; mthi/lo
(define_insn_reservation "p5600_dsp_mthilo" 5
  (and (eq_attr "cpu" "p5600")
       (eq_attr "type" "mthi,mtlo"))
  "p5600_agq_al2")

;; mult, multu, mul
(define_insn_reservation "p5600_dsp_mult" 5
  (and (eq_attr "cpu" "p5600")
       (eq_attr "type" "imul3,imul"))
  "p5600_agq_al2")

;; branch and jump
(define_insn_reservation "p5600_int_branch" 1
  (and (eq_attr "cpu" "p5600")
       (eq_attr "type" "branch,jump"))
  "p5600_agq_ctistd")

;; prefetch
(define_insn_reservation "p5600_int_prefetch" 3
  (and (eq_attr "cpu" "p5600")
       (eq_attr "type" "prefetch,prefetchx"))
  "p5600_agq_ldsta")

;; divide
(define_insn_reservation "p5600_int_div" 8
  (and (eq_attr "cpu" "p5600")
       (eq_attr "type" "idiv"))
  "p5600_agq_al2+p5600_gpdiv*8")

;; arith
(define_insn_reservation "p5600_int_arith_5" 2
  (and (eq_attr "cpu" "p5600")
       (eq_attr "type" "arith"))
  "p5600_agq_al2")

;; call
(define_insn_reservation "p5600_int_call" 2
  (and (eq_attr "cpu" "p5600")
       (eq_attr "jal" "indirect,direct"))
  "p5600_agq_ctistd")
