# this macro is used to bring the template header syntax of ldap to the cmake syntax
macro(prepare_configure_file _infile)
    string(LENGTH ${_infile} __namelength)
    math(EXPR __namelength "${__namelength} - 2")
    string(SUBSTRING ${_infile} 0 ${__namelength} __outfile)
    file(RELATIVE_PATH __outfile ${CMAKE_SOURCE_DIR}/include ${__outfile})
    file(READ ${_infile} __content)
    string(REPLACE ";" "\\;" __content "${__content}") # make sure that also ; get through cmake and won't get interpreted as array separators
    string(REGEX REPLACE "\#undef ([^\r\n ]*)" "#cmakedefine \\1 @\\1@" __content "${__content}")
    string(REGEX REPLACE "%([A-Za-z0-9_]*)%" "@\\1@" __content "${__content}")
    file(WRITE ${CMAKE_BINARY_DIR}/${__outfile}.cmake ${__content})
endmacro(prepare_configure_file _infile)
