/* This file is part of the KDE project
   Copyright (C) 2003-2004 Jarosław Staniek <staniek@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef NO_KDEWIN
#ifndef KDEWIN_SYS_LOCK_H
#define KDEWIN_SYS_LOCK_H

// include everywhere
#include <sys/types.h>

/* dummy lock routines for single-threaded aps */

typedef int _LOCK_T;
typedef int _LOCK_RECURSIVE_T;

#define __LOCK_INIT(class,lock) static int lock = 0;
#define __LOCK_INIT_RECURSIVE(class,lock) static int lock = 0;
#define __lock_init(lock) {}
#define __lock_init_recursive(lock) {}
#define __lock_close(lock) {}
#define __lock_close_recursive(lock) {}
#define __lock_acquire(lock) {}
#define __lock_acquire_recursive(lock) {}
#define __lock_try_acquire(lock) {}
#define __lock_try_acquire_recursive(lock) {}
#define __lock_release(lock) {}
#define __lock_release_recursive(lock) {}

#endif // KDEWIN_SYS_LOCK_H
#endif /* NO_KDEWIN */