# configure checks.
find_package(OpenGL)

include_directories(${CMAKE_BINARY_DIR})

# options
if(APPLE)
    set(AC_APPLE_UNIVERSAL_BUILD 1)
endif(APPLE)

option(CCITT_SUPPORT "CCITT Group 3 & 4 algorithms" ON)
option(LOGLUV_SUPPORT "LogLuv high dynamic range encoding" ON)
option(CXX_SUPPORT "C++ stream API (requires C++ compiler)" OFF)
option(LZW_SUPPORT "LZW algorithm" ON)
option(JBIG_SUPPORT "ISO JBIG compression (requires JBIG-KIT library)" OFF)
option(MDI_SUPPORT "Microsoft Document Imaging format" OFF)
option(NEXT_SUPPORT "NeXT 2-bit RLE algorithm" ON)
option(SUBIFD_SUPPORT "SubIFD tag (330) support" ON)
option(THUNDER_SUPPORT "ThunderScan 4-bit RLE algorithm" ON)
option(OJPEG_SUPPORT "Old JPEG compresson (read-only)" OFF)
option(PACKBITS_SUPPORT "Macintosh PackBits algorithm" ON)

option(CHECK_JPEG_YCBCR_SUBSAMPLING 1)
option(DEFAULT_EXTRASAMPLE_AS_ALPHA "Treat extra sample as alpha" ON)


if(WIN32)
    set(X_DISPLAY_MISSING 1)
else(WIN32)
    set(STDC_HEADERS 1)
    set(HAVE_LIBC 1)
    set(HAVE_LIBM 1)
    set(HAVE_PTHREAD 1)
endif(WIN32)

if(NOT WINCE)
    set(HAVE_IEEEFP 1)
endif(NOT WINCE)

if(MSVC)
    set(inline "__inline")
else(MSVC)
    set(inline "inline")
endif(MSVC)

include(CheckIncludeFiles)
include(CheckFunctionExists)
include(CheckLibraryExists)
include(CheckSymbolExists)
include(CheckTypeSize)
include(TestBigEndian)

test_big_endian(HOST_BIGENDIAN)

if(HOST_BIGENDIAN)
    set(HOST_FILLORDER "FILLORDER_MSB2LSB")
else(HOST_BIGENDIAN)
    set(HOST_FILLORDER "FILLORDER_LSB2MSB")
endif(HOST_BIGENDIAN)



check_include_files("assert.h" HAVE_ASSERT_H)
check_include_files("dlfcn.h" HAVE_DLFCN_H)
check_include_files("fcntl.h" HAVE_FCNTL_H)
check_include_files("inttypes.h" HAVE_INTTYPES_H)
check_include_files("io.h" HAVE_IO_H)
check_include_files("limits.h" HAVE_LIMITS_H)
check_include_files("malloc.h" HAVE_MALLOC_H)
check_include_files("memory.h" HAVE_MEMORY_H)
check_include_files("search.h" HAVE_SEARCH_H)
check_include_files("stdint.h" HAVE_STDINT_H)
check_include_files("stdlib.h" HAVE_STDLIB_H)
check_include_files("strings.h" HAVE_STRINGS_H)
check_include_files("string.h" HAVE_STRING_H)
check_include_files("sys/stat.h" HAVE_SYS_STAT_H)
check_include_files("sys/time.h" HAVE_SYS_TIME_H)
check_include_files("sys/types.h" HAVE_SYS_TYPES_H)
check_include_files("unistd.h" HAVE_UNISTD_H)
check_include_files("windows.h" HAVE_WINDOWS_H)

check_function_exists("floor" HAVE_FLOOR)
check_function_exists("getopt" HAVE_GETOPT)
check_function_exists("isascii" HAVE_ISASCII)
check_function_exists("jbg_newlen" HAVE_JBG_NEWLEN)
check_function_exists("lfind" HAVE_LFIND)
check_function_exists("memmove" HAVE_MEMMOVE)
check_function_exists("memset" HAVE_MEMSET)
check_function_exists("mmap" HAVE_MMAP)
check_function_exists("pow" HAVE_POW)
check_function_exists("setmode" HAVE_SETMODE)
check_function_exists("sqrt" HAVE_SQRT)
check_function_exists("strcasecmp" HAVE_STRCASECMP)
check_function_exists("strchr" HAVE_STRCHR)
check_function_exists("strrchr" HAVE_STRRCHR)
check_function_exists("strstr" HAVE_STRSTR)
check_function_exists("strtol" HAVE_STRTOL)
check_function_exists("strtoul" HAVE_STRTOUL)

check_symbol_exists("int8" "stdint.h" HAVE_INT8)
check_symbol_exists("int16" "stdint.h" HAVE_INT16)
check_symbol_exists("int32" "stdint.h" HAVE_INT32)


set(PACKAGE "tiff")
set(PACKAGE_BUGREPORT "tiff@lists.maptools.org")
set(PACKAGE_NAME "LibTIFF Software")
set(PACKAGE_STRING "LibTIFF Software 3.9.2")
set(PACKAGE_TARNAME "tiff")
set(PACKAGE_URL "http://www.libtiff.org/")
set(PACKAGE_VERSION "3.9.2")
set(VERSION "3.9.2")


find_package(JPEG)
find_package(ZLIB)

if(HAVE_JPEG)
    include_directories(${JPEG_INCLUDE_DIR})
    option(JPEG_SUPPORT "JPEG compression" ON)
endif(HAVE_JPEG)

if(ZLIB_FOUND)
    include_directories(${ZLIB_INCLUDE_DIR})
    option(PIXARLOG_SUPPORT "Deflate compression" ON)
    option(ZIP_SUPPORT "Pixar log-format algorithm" ON)
endif(ZLIB_FOUND)

CHECK_TYPE_SIZE("int" SIZEOF_INT)
CHECK_TYPE_SIZE("long" SIZEOF_LONG)
CHECK_TYPE_SIZE("signed long" SIZEOF_SIGNED_LONG)
CHECK_TYPE_SIZE("signed long long" SIZEOF_SIGNED_LONG_LONG)
CHECK_TYPE_SIZE("unsigned long" SIZEOF_UNSIGNED_LONG)
CHECK_TYPE_SIZE("unsigned long long" SIZEOF_UNSIGNED_LONG_LONG)

set(STRIPCHOP_DEFAULT "TIFF_STRIPCHOP")

if(STRIPCHOP_DEFAULT AND NOT WIN32)
    set(STRIP_SIZE_DEFAULT 8192)
endif(STRIPCHOP_DEFAULT AND NOT WIN32)

if(WIN32)
    set(TIFF_INT64_FORMAT "\"%I64d\"")
    set(TIFF_INT64_T "signed __int64")
    set(TIFF_UINT64_FORMAT "\"%I64u\"")
    set(TIFF_UINT64_T "unsigned __int64")
endif(WIN32)

check_symbol_exists("tm" "sys/time.h" TM_IN_SYS_TIME)

check_symbol_exists("off_t" "sys/types.h" HAVE_OFF_T)
if(NOT HAVE_OFF_T)
    set(OFF_T "long int")
endif(NOT HAVE_OFF_T)

check_symbol_exists("size_t" "sys/types.h" HAVE_SIZE_T)
if(NOT HAVE_SIZE_T)
    set(SIZE_T "unsigned int")
endif(NOT HAVE_SIZE_T)

#***************************************************************************************
# still to fix later
#/* Define to necessary symbol if this constant uses a non-standard name on
#   your system. */
#cmakedefine PTHREAD_CREATE_JOINABLE

#/* Define to 1 if your C compiler doesn't accept -c and -o together. */
#cmakedefine NO_MINUS_C_MINUS_O

#/* Number of bits in a file offset, on hosts where this is settable. */
#cmakedefine _FILE_OFFSET_BITS

#/* Define for large files, on AIX-style hosts. */
#cmakedefine _LARGE_FILES
#***************************************************************************************

configure_file(${CMAKE_SOURCE_DIR}/libtiff/tif_config.h.cmake ${CMAKE_BINARY_DIR}/tif_config.h)
configure_file(${CMAKE_SOURCE_DIR}/libtiff/tiffconf.h.cmake ${CMAKE_BINARY_DIR}/tiffconf.h)

