/*
    This file is part of Contact Editor.

    SPDX-FileCopyrightText: 2010 Tobias Koenig <tokoe@kde.org>

    SPDX-License-Identifier: LGPL-2.0-or-later
*/

#ifndef CUSTOMFIELDSMODEL_H
#define CUSTOMFIELDSMODEL_H

#include "customfields_p.h"

#include <QAbstractItemModel>

class CustomFieldsModel : public QAbstractItemModel
{
    Q_OBJECT
public:
    enum Role {
        TypeRole = Qt::UserRole,
        ScopeRole
    };

    explicit CustomFieldsModel(QObject *parent = nullptr);
    ~CustomFieldsModel();

    void setCustomFields(const CustomField::List &addresses);
    CustomField::List customFields() const;

    QModelIndex index(int row, int col, const QModelIndex &parent = QModelIndex()) const override;
    QModelIndex parent(const QModelIndex &child) const override;
    QVariant data(const QModelIndex &index, int role) const override;
    bool setData(const QModelIndex &index, const QVariant &value, int role = Qt::EditRole) override;
    QVariant headerData(int section, Qt::Orientation orientation, int role) const override;
    Qt::ItemFlags flags(const QModelIndex &index) const override;
    int columnCount(const QModelIndex &parent = QModelIndex()) const override;
    int rowCount(const QModelIndex &parent = QModelIndex()) const override;

    bool insertRows(int row, int count, const QModelIndex &parent = QModelIndex()) override;
    bool removeRows(int row, int count, const QModelIndex &parent = QModelIndex()) override;

private:
    CustomField::List mCustomFields;
};

#endif
