/*
 *  Copyright (c) 2013 Dmitry Kazakov <dimula73@gmail.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __KIS_TAKE_ALL_SHAPES_COMMAND_H
#define __KIS_TAKE_ALL_SHAPES_COMMAND_H

#include <QList>

#include "kundo2command.h"

#include "kritaui_export.h"
#include "kis_types.h"

class KoShape;
class KisShapeSelection;


class KisTakeAllShapesCommand : public KUndo2Command
{
public:
    KisTakeAllShapesCommand(KisShapeSelection *shapeSelection, bool takeSilently);
    ~KisTakeAllShapesCommand() override;

    void redo() override;
    void undo() override;

private:
    KisShapeSelection *m_shapeSelection;
    QList<KoShape*> m_shapes;
    bool m_takeSilently;
};

#endif /* __KIS_TAKE_ALL_SHAPES_COMMAND_H */
