/*
* This file is part of Akonadi
*
* Copyright (c) 2010 Volker Krause <vkrause@kde.org>
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
* 02110-1301  USA
*/
#ifndef MAINVIEW_H
#define MAINVIEW_H

#include "kdeclarativemainview.h"

namespace Akonadi
{
class Calendar;
}

class MainView : public KDeclarativeMainView
{
  Q_OBJECT
public:
    explicit MainView( QWidget *parent = 0 );

public slots:
    void showFavoriteCalendar();
    void showRegularCalendar();

    void setCurrentEventItemId( qint64 id );

    void startIncidenceEditor();

private:
  Akonadi::Calendar *m_calendar;
};

#endif // MAINVIEW_H
