/***************************************************************************
 *   Copyright (C) 2011 by Francesco Nwokeka <francesco.nwokeka@gmail.com> *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA            *
 ***************************************************************************/

#ifndef KTP_PRESENCE_APPLET_GENERAL_SETTINGS_H
#define KTP_PRESENCE_APPLET_GENERAL_SETTINGS_H

#include <QtGui/QWidget>

#include "presenceapplet.h"
#include "ui_generalsettings.h"

namespace Ui {
    class GeneralSettings;
}

class GeneralSettings : public QWidget
{
    Q_OBJECT

public:
    GeneralSettings(TelepathyPresenceApplet::OnClickAction clickAction, QWidget *parent = 0);
    ~GeneralSettings();

Q_SIGNALS:
    void clickActionUpdated(TelepathyPresenceApplet::OnClickAction clickAction);
    void modified();

public Q_SLOTS:
    void save();
/*
private Q_SLOTS:
    void saveDoNothingConfig(bool checked);
    void saveShowContactlistConfig(bool checked);
    void saveShowMenuConfig(bool checked);*/

private:
    Ui::GeneralSettings *ui;
};

#endif  // KTP_PRESENCE_APPLET_GENERAL_SETTINGS_H