/* sugar_share.c generated by valac, the Vala compiler
 * generated from sugar_share.vala, do not modify */

/* gcompris - sugar_share.vala
 *
 * Copyright (C) 2010, Aleksey Lim
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "sugar_share.h"
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <gobject/gvaluecollector.h>
#include <dbus/dbus.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _dbus_g_connection_unref0(var) ((var == NULL) ? NULL : (var = (dbus_g_connection_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ParamSpecAdministrationClient ParamSpecAdministrationClient;
typedef struct _ParamSpecAdministrationServer ParamSpecAdministrationServer;
typedef struct _DBusObjectVTable _DBusObjectVTable;

struct _AdministrationPrivate {
	GetProfileCallback _GetProfile_cb;
	gpointer _GetProfile_cb_target;
	GDestroyNotify _GetProfile_cb_target_destroy_notify;
	ReportCallback _Report_cb;
	gpointer _Report_cb_target;
	GDestroyNotify _Report_cb_target_destroy_notify;
};

struct _AdministrationClientPrivate {
	DBusGProxy* _server;
	DBusGConnection* _connection;
	GotProfileCallback _GotProfile_cb;
	gpointer _GotProfile_cb_target;
	GDestroyNotify _GotProfile_cb_target_destroy_notify;
};

struct _ParamSpecAdministrationClient {
	GParamSpec parent_instance;
};

struct _AdministrationServerPrivate {
	Administration* _server;
	DBusGConnection* _connection;
};

struct _ParamSpecAdministrationServer {
	GParamSpec parent_instance;
};

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};


static gpointer administration_parent_class = NULL;
static gpointer administration_client_parent_class = NULL;
static gpointer administration_server_parent_class = NULL;

#define _PATH "/org/gcompris/Administration"
#define _IFACE "org.gcompris.Administration"
#define ADMINISTRATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ADMINISTRATION, AdministrationPrivate))
enum  {
	ADMINISTRATION_DUMMY_PROPERTY
};
void administration_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _administration_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult administration_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_administration_introspect (Administration* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_administration_property_get_all (Administration* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_administration_GetProfile (Administration* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_administration_Report (Administration* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_administration_update_profile (GObject* _sender, DBusConnection* _connection);
static void administration_finalize (GObject* obj);
#define ADMINISTRATION_CLIENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ADMINISTRATION_CLIENT, AdministrationClientPrivate))
enum  {
	ADMINISTRATION_CLIENT_DUMMY_PROPERTY
};
static void _administration_client_UpdateProfile_cb (AdministrationClient* self, DBusGProxy* sender);
static void __administration_client_UpdateProfile_cb_dynamic_UpdateProfile_ (DBusGProxy* _sender, gpointer self);
void _dynamic_UpdateProfile_conect (gpointer obj, const char * signal_name, GCallback handler, gpointer data);
static void _administration_client_GetProfile_cb (AdministrationClient* self, const char* profile_data, GError* _error_);
static void _dynamic_GetProfile0 (DBusGProxy* self, gpointer param1, void* param1_target, GError** error);
static void _administration_client_Report_cb (AdministrationClient* self, GError* _error_);
static void _dynamic_Report1 (DBusGProxy* self, const char* param1, gint param2, const char* param3, const char* param4, gint param5, gint param6, gint param7, const char* param8, gpointer param9, void* param9_target, GError** error);
static void administration_client_finalize (AdministrationClient* obj);
#define ADMINISTRATION_SERVER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ADMINISTRATION_SERVER, AdministrationServerPrivate))
enum  {
	ADMINISTRATION_SERVER_DUMMY_PROPERTY
};
static void administration_server_finalize (AdministrationServer* obj);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);

static const DBusObjectPathVTable _administration_dbus_path_vtable = {_administration_dbus_unregister, administration_dbus_message};
static const _DBusObjectVTable _administration_dbus_vtable = {administration_dbus_register_object};


Administration* administration_construct (GType object_type, GetProfileCallback GetProfile_cb, void* GetProfile_cb_target, ReportCallback Report_cb, void* Report_cb_target) {
	Administration * self;
	GetProfileCallback _tmp0_;
	ReportCallback _tmp1_;
	self = (Administration*) g_object_new (object_type, NULL);
	self->priv->_GetProfile_cb = (_tmp0_ = GetProfile_cb, ((self->priv->_GetProfile_cb_target_destroy_notify == NULL) ? NULL : (self->priv->_GetProfile_cb_target_destroy_notify (self->priv->_GetProfile_cb_target), NULL), self->priv->_GetProfile_cb = NULL, self->priv->_GetProfile_cb_target = NULL, self->priv->_GetProfile_cb_target_destroy_notify = NULL), self->priv->_GetProfile_cb_target = GetProfile_cb_target, self->priv->_GetProfile_cb_target_destroy_notify = NULL, _tmp0_);
	self->priv->_Report_cb = (_tmp1_ = Report_cb, ((self->priv->_Report_cb_target_destroy_notify == NULL) ? NULL : (self->priv->_Report_cb_target_destroy_notify (self->priv->_Report_cb_target), NULL), self->priv->_Report_cb = NULL, self->priv->_Report_cb_target = NULL, self->priv->_Report_cb_target_destroy_notify = NULL), self->priv->_Report_cb_target = Report_cb_target, self->priv->_Report_cb_target_destroy_notify = NULL, _tmp1_);
	return self;
}


Administration* administration_new (GetProfileCallback GetProfile_cb, void* GetProfile_cb_target, ReportCallback Report_cb, void* Report_cb_target) {
	return administration_construct (TYPE_ADMINISTRATION, GetProfile_cb, GetProfile_cb_target, Report_cb, Report_cb_target);
}


char* administration_GetProfile (Administration* self) {
	char* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_debug ("sugar_share.vala:53: GetProfile called on server");
	result = self->priv->_GetProfile_cb (self->priv->_GetProfile_cb_target);
	return result;
}


void administration_Report (Administration* self, const char* date, gint duration, const char* user, const char* board, gint level, gint sublevel, gint status, const char* comment) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (date != NULL);
	g_return_if_fail (user != NULL);
	g_return_if_fail (board != NULL);
	g_return_if_fail (comment != NULL);
	g_debug ("sugar_share.vala:62: Report called on server");
	self->priv->_Report_cb (date, duration, user, board, level, sublevel, status, comment, self->priv->_Report_cb_target);
}


void _administration_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_administration_introspect (Administration* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gcompris.Administration\">\n  <method name=\"GetProfile\">\n    <arg name=\"result\" type=\"s\" direction=\"out\"/>\n  </method>\n  <method name=\"Report\">\n    <arg name=\"date\" type=\"s\" direction=\"in\"/>\n    <arg name=\"duration\" type=\"i\" direction=\"in\"/>\n    <arg name=\"user\" type=\"s\" direction=\"in\"/>\n    <arg name=\"board\" type=\"s\" direction=\"in\"/>\n    <arg name=\"level\" type=\"i\" direction=\"in\"/>\n    <arg name=\"sublevel\" type=\"i\" direction=\"in\"/>\n    <arg name=\"status\" type=\"i\" direction=\"in\"/>\n    <arg name=\"comment\" type=\"s\" direction=\"in\"/>\n  </method>\n  <signal name=\"UpdateProfile\">\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_administration_property_get_all (Administration* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp0_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp0_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp0_);
	if (strcmp (interface_name, "org.gcompris.Administration") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_administration_GetProfile (Administration* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* result;
	DBusMessage* reply;
	const char* _tmp1_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	result = administration_GetProfile (self);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp1_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &_tmp1_);
	_g_free0 (result);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_administration_Report (Administration* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* date = NULL;
	const char* _tmp2_;
	gint duration = 0;
	dbus_int32_t _tmp3_;
	char* user = NULL;
	const char* _tmp4_;
	char* board = NULL;
	const char* _tmp5_;
	gint level = 0;
	dbus_int32_t _tmp6_;
	gint sublevel = 0;
	dbus_int32_t _tmp7_;
	gint status = 0;
	dbus_int32_t _tmp8_;
	char* comment = NULL;
	const char* _tmp9_;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "sissiiis")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp2_);
	dbus_message_iter_next (&iter);
	date = g_strdup (_tmp2_);
	dbus_message_iter_get_basic (&iter, &_tmp3_);
	dbus_message_iter_next (&iter);
	duration = _tmp3_;
	dbus_message_iter_get_basic (&iter, &_tmp4_);
	dbus_message_iter_next (&iter);
	user = g_strdup (_tmp4_);
	dbus_message_iter_get_basic (&iter, &_tmp5_);
	dbus_message_iter_next (&iter);
	board = g_strdup (_tmp5_);
	dbus_message_iter_get_basic (&iter, &_tmp6_);
	dbus_message_iter_next (&iter);
	level = _tmp6_;
	dbus_message_iter_get_basic (&iter, &_tmp7_);
	dbus_message_iter_next (&iter);
	sublevel = _tmp7_;
	dbus_message_iter_get_basic (&iter, &_tmp8_);
	dbus_message_iter_next (&iter);
	status = _tmp8_;
	dbus_message_iter_get_basic (&iter, &_tmp9_);
	dbus_message_iter_next (&iter);
	comment = g_strdup (_tmp9_);
	administration_Report (self, date, duration, user, board, level, sublevel, status, comment);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_g_free0 (date);
	_g_free0 (user);
	_g_free0 (board);
	_g_free0 (comment);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult administration_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_administration_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_administration_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gcompris.Administration", "GetProfile")) {
		result = _dbus_administration_GetProfile (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gcompris.Administration", "Report")) {
		result = _dbus_administration_Report (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static void _dbus_administration_update_profile (GObject* _sender, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.gcompris.Administration", "UpdateProfile");
	dbus_message_iter_init_append (_message, &_iter);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


void administration_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_administration_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	g_signal_connect (object, "update-profile", (GCallback) _dbus_administration_update_profile, connection);
}


static void administration_class_init (AdministrationClass * klass) {
	administration_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AdministrationPrivate));
	G_OBJECT_CLASS (klass)->finalize = administration_finalize;
	g_signal_new ("update_profile", TYPE_ADMINISTRATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_type_set_qdata (TYPE_ADMINISTRATION, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_administration_dbus_vtable));
}


static void administration_instance_init (Administration * self) {
	self->priv = ADMINISTRATION_GET_PRIVATE (self);
}


static void administration_finalize (GObject* obj) {
	Administration * self;
	self = ADMINISTRATION (obj);
	(self->priv->_GetProfile_cb_target_destroy_notify == NULL) ? NULL : (self->priv->_GetProfile_cb_target_destroy_notify (self->priv->_GetProfile_cb_target), NULL);
	self->priv->_GetProfile_cb = NULL;
	self->priv->_GetProfile_cb_target = NULL;
	self->priv->_GetProfile_cb_target_destroy_notify = NULL;
	(self->priv->_Report_cb_target_destroy_notify == NULL) ? NULL : (self->priv->_Report_cb_target_destroy_notify (self->priv->_Report_cb_target), NULL);
	self->priv->_Report_cb = NULL;
	self->priv->_Report_cb_target = NULL;
	self->priv->_Report_cb_target_destroy_notify = NULL;
	G_OBJECT_CLASS (administration_parent_class)->finalize (obj);
}


GType administration_get_type (void) {
	static volatile gsize administration_type_id__volatile = 0;
	if (g_once_init_enter (&administration_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AdministrationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) administration_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Administration), 0, (GInstanceInitFunc) administration_instance_init, NULL };
		GType administration_type_id;
		administration_type_id = g_type_register_static (G_TYPE_OBJECT, "Administration", &g_define_type_info, 0);
		g_once_init_leave (&administration_type_id__volatile, administration_type_id);
	}
	return administration_type_id__volatile;
}


static void __administration_client_UpdateProfile_cb_dynamic_UpdateProfile_ (DBusGProxy* _sender, gpointer self) {
	_administration_client_UpdateProfile_cb (self, _sender);
}


void _dynamic_UpdateProfile_conect (gpointer obj, const char * signal_name, GCallback handler, gpointer data) {
	dbus_g_object_register_marshaller (g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, G_TYPE_INVALID);
	dbus_g_proxy_add_signal (obj, "UpdateProfile", G_TYPE_INVALID);
	dbus_g_proxy_connect_signal (obj, signal_name, handler, data, NULL);
}


AdministrationClient* administration_client_construct (GType object_type, const char* address, const char* name, GotProfileCallback GotProfile_cb, void* GotProfile_cb_target) {
	GError * _inner_error_;
	AdministrationClient* self;
	GotProfileCallback _tmp0_;
	DBusGProxy* _tmp3_;
	g_return_val_if_fail (address != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_inner_error_ = NULL;
	self = (AdministrationClient*) g_type_create_instance (object_type);
	self->priv->_GotProfile_cb = (_tmp0_ = GotProfile_cb, ((self->priv->_GotProfile_cb_target_destroy_notify == NULL) ? NULL : (self->priv->_GotProfile_cb_target_destroy_notify (self->priv->_GotProfile_cb_target), NULL), self->priv->_GotProfile_cb = NULL, self->priv->_GotProfile_cb_target = NULL, self->priv->_GotProfile_cb_target_destroy_notify = NULL), self->priv->_GotProfile_cb_target = GotProfile_cb_target, self->priv->_GotProfile_cb_target_destroy_notify = NULL, _tmp0_);
	{
		DBusGConnection* _tmp1_;
		DBusGConnection* _tmp2_;
		_tmp1_ = dbus_g_connection_open (address, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		self->priv->_connection = (_tmp2_ = _tmp1_, _dbus_g_connection_unref0 (self->priv->_connection), _tmp2_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("sugar_share.vala:88: Cannot open DBus connection: %s", _error_->message);
			_g_error_free0 (_error_);
			return self;
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	self->priv->_server = (_tmp3_ = dbus_g_proxy_new_for_name (self->priv->_connection, name, _PATH, _IFACE), _g_object_unref0 (self->priv->_server), _tmp3_);
	_dynamic_UpdateProfile_conect (self->priv->_server, "UpdateProfile", (GCallback) __administration_client_UpdateProfile_cb_dynamic_UpdateProfile_, self);
	return self;
}


AdministrationClient* administration_client_new (const char* address, const char* name, GotProfileCallback GotProfile_cb, void* GotProfile_cb_target) {
	return administration_client_construct (TYPE_ADMINISTRATION_CLIENT, address, name, GotProfile_cb, GotProfile_cb_target);
}


static void __administration_client_GetProfile_cb_cb (DBusGProxy* proxy, DBusGProxyCall* call, void* user_data) {
	GError* error;
	const char* profile_data;
	error = NULL;
	dbus_g_proxy_end_call (proxy, call, &error, G_TYPE_STRING, &profile_data, G_TYPE_INVALID);
	_administration_client_GetProfile_cb (user_data, profile_data, error);
	administration_client_unref (user_data);
}


static void _dynamic_GetProfile0 (DBusGProxy* self, gpointer param1, void* param1_target, GError** error) {
	dbus_g_proxy_begin_call (self, "GetProfile", __administration_client_GetProfile_cb_cb, administration_client_ref (param1_target), NULL, G_TYPE_INVALID, G_TYPE_INVALID);
	if (*error) {
		return;
	}
}


void administration_client_import_profile (AdministrationClient* self) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	if (self->priv->_server == NULL) {
		return;
	}
	g_debug ("sugar_share.vala:103: GetProfile called on client");
	{
		_dynamic_GetProfile0 (self->priv->_server, _administration_client_GetProfile_cb, self, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("sugar_share.vala:108: Cannot get server profile: %s", _error_->message);
			self->priv->_GotProfile_cb (NULL, self->priv->_GotProfile_cb_target);
			_g_error_free0 (_error_);
		}
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void __administration_client_Report_cb_cb (DBusGProxy* proxy, DBusGProxyCall* call, void* user_data) {
	GError* error;
	error = NULL;
	dbus_g_proxy_end_call (proxy, call, &error, G_TYPE_INVALID);
	_administration_client_Report_cb (user_data, error);
	administration_client_unref (user_data);
}


static void _dynamic_Report1 (DBusGProxy* self, const char* param1, gint param2, const char* param3, const char* param4, gint param5, gint param6, gint param7, const char* param8, gpointer param9, void* param9_target, GError** error) {
	dbus_g_proxy_begin_call (self, "Report", __administration_client_Report_cb_cb, administration_client_ref (param9_target), NULL, G_TYPE_STRING, param1, G_TYPE_INT, param2, G_TYPE_STRING, param3, G_TYPE_STRING, param4, G_TYPE_INT, param5, G_TYPE_INT, param6, G_TYPE_INT, param7, G_TYPE_STRING, param8, G_TYPE_INVALID, G_TYPE_INVALID);
	if (*error) {
		return;
	}
}


void administration_client_report (AdministrationClient* self, const char* date, gint duration, const char* user, const char* board, gint level, gint sublevel, gint status, const char* comment) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (date != NULL);
	g_return_if_fail (user != NULL);
	g_return_if_fail (board != NULL);
	g_return_if_fail (comment != NULL);
	_inner_error_ = NULL;
	if (self->priv->_server == NULL) {
		return;
	}
	g_debug ("sugar_share.vala:121: Send report");
	_dynamic_Report1 (self->priv->_server, date, duration, user, board, level, sublevel, status, comment, _administration_client_Report_cb, self, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void _administration_client_Report_cb (AdministrationClient* self, GError* _error_) {
	g_return_if_fail (self != NULL);
	if (_error_ != NULL) {
		g_warning ("sugar_share.vala:129: Cannot send report to server: %s", _error_->message);
	}
}


static void _administration_client_GetProfile_cb (AdministrationClient* self, const char* profile_data, GError* _error_) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (profile_data != NULL);
	if (_error_ != NULL) {
		g_warning ("sugar_share.vala:135: Cannot get server profile: %s", _error_->message);
		self->priv->_GotProfile_cb (NULL, self->priv->_GotProfile_cb_target);
	} else {
		self->priv->_GotProfile_cb (profile_data, self->priv->_GotProfile_cb_target);
	}
}


static void _administration_client_UpdateProfile_cb (AdministrationClient* self, DBusGProxy* sender) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	administration_client_import_profile (self);
}


static void value_administration_client_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_administration_client_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		administration_client_unref (value->data[0].v_pointer);
	}
}


static void value_administration_client_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = administration_client_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_administration_client_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_administration_client_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		AdministrationClient* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = administration_client_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_administration_client_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	AdministrationClient** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = administration_client_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_administration_client (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecAdministrationClient* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_ADMINISTRATION_CLIENT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_administration_client (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ADMINISTRATION_CLIENT), NULL);
	return value->data[0].v_pointer;
}


void value_set_administration_client (GValue* value, gpointer v_object) {
	AdministrationClient* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ADMINISTRATION_CLIENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ADMINISTRATION_CLIENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		administration_client_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		administration_client_unref (old);
	}
}


void value_take_administration_client (GValue* value, gpointer v_object) {
	AdministrationClient* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ADMINISTRATION_CLIENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ADMINISTRATION_CLIENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		administration_client_unref (old);
	}
}


static void administration_client_class_init (AdministrationClientClass * klass) {
	administration_client_parent_class = g_type_class_peek_parent (klass);
	ADMINISTRATION_CLIENT_CLASS (klass)->finalize = administration_client_finalize;
	g_type_class_add_private (klass, sizeof (AdministrationClientPrivate));
}


static void administration_client_instance_init (AdministrationClient * self) {
	self->priv = ADMINISTRATION_CLIENT_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void administration_client_finalize (AdministrationClient* obj) {
	AdministrationClient * self;
	self = ADMINISTRATION_CLIENT (obj);
	_g_object_unref0 (self->priv->_server);
	_dbus_g_connection_unref0 (self->priv->_connection);
	(self->priv->_GotProfile_cb_target_destroy_notify == NULL) ? NULL : (self->priv->_GotProfile_cb_target_destroy_notify (self->priv->_GotProfile_cb_target), NULL);
	self->priv->_GotProfile_cb = NULL;
	self->priv->_GotProfile_cb_target = NULL;
	self->priv->_GotProfile_cb_target_destroy_notify = NULL;
}


GType administration_client_get_type (void) {
	static volatile gsize administration_client_type_id__volatile = 0;
	if (g_once_init_enter (&administration_client_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_administration_client_init, value_administration_client_free_value, value_administration_client_copy_value, value_administration_client_peek_pointer, "p", value_administration_client_collect_value, "p", value_administration_client_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (AdministrationClientClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) administration_client_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AdministrationClient), 0, (GInstanceInitFunc) administration_client_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType administration_client_type_id;
		administration_client_type_id = g_type_register_fundamental (g_type_fundamental_next (), "AdministrationClient", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&administration_client_type_id__volatile, administration_client_type_id);
	}
	return administration_client_type_id__volatile;
}


gpointer administration_client_ref (gpointer instance) {
	AdministrationClient* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void administration_client_unref (gpointer instance) {
	AdministrationClient* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		ADMINISTRATION_CLIENT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


AdministrationServer* administration_server_construct (GType object_type, const char* address, GetProfileCallback GetProfile_cb, void* GetProfile_cb_target, ReportCallback Report_cb, void* Report_cb_target) {
	GError * _inner_error_;
	AdministrationServer* self;
	Administration* _tmp2_;
	g_return_val_if_fail (address != NULL, NULL);
	_inner_error_ = NULL;
	self = (AdministrationServer*) g_type_create_instance (object_type);
	{
		DBusGConnection* _tmp0_;
		DBusGConnection* _tmp1_;
		_tmp0_ = dbus_g_connection_open (address, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
		self->priv->_connection = (_tmp1_ = _tmp0_, _dbus_g_connection_unref0 (self->priv->_connection), _tmp1_);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("sugar_share.vala:165: Cannot open DBus connection: %s", _error_->message);
			_g_error_free0 (_error_);
			return self;
		}
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	self->priv->_server = (_tmp2_ = administration_new (GetProfile_cb, GetProfile_cb_target, Report_cb, Report_cb_target), _g_object_unref0 (self->priv->_server), _tmp2_);
	_vala_dbus_register_object (dbus_g_connection_get_connection (self->priv->_connection), _PATH, (GObject*) self->priv->_server);
	return self;
}


AdministrationServer* administration_server_new (const char* address, GetProfileCallback GetProfile_cb, void* GetProfile_cb_target, ReportCallback Report_cb, void* Report_cb_target) {
	return administration_server_construct (TYPE_ADMINISTRATION_SERVER, address, GetProfile_cb, GetProfile_cb_target, Report_cb, Report_cb_target);
}


void administration_server_update_profile (AdministrationServer* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->_server == NULL) {
		return;
	}
	g_debug ("sugar_share.vala:179: Force to update students profiles");
	g_signal_emit_by_name (self->priv->_server, "update-profile");
}


static void value_administration_server_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_administration_server_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		administration_server_unref (value->data[0].v_pointer);
	}
}


static void value_administration_server_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = administration_server_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_administration_server_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_administration_server_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		AdministrationServer* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = administration_server_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_administration_server_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	AdministrationServer** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = administration_server_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_administration_server (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecAdministrationServer* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_ADMINISTRATION_SERVER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_administration_server (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ADMINISTRATION_SERVER), NULL);
	return value->data[0].v_pointer;
}


void value_set_administration_server (GValue* value, gpointer v_object) {
	AdministrationServer* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ADMINISTRATION_SERVER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ADMINISTRATION_SERVER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		administration_server_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		administration_server_unref (old);
	}
}


void value_take_administration_server (GValue* value, gpointer v_object) {
	AdministrationServer* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ADMINISTRATION_SERVER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ADMINISTRATION_SERVER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		administration_server_unref (old);
	}
}


static void administration_server_class_init (AdministrationServerClass * klass) {
	administration_server_parent_class = g_type_class_peek_parent (klass);
	ADMINISTRATION_SERVER_CLASS (klass)->finalize = administration_server_finalize;
	g_type_class_add_private (klass, sizeof (AdministrationServerPrivate));
}


static void administration_server_instance_init (AdministrationServer * self) {
	self->priv = ADMINISTRATION_SERVER_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void administration_server_finalize (AdministrationServer* obj) {
	AdministrationServer * self;
	self = ADMINISTRATION_SERVER (obj);
	_g_object_unref0 (self->priv->_server);
	_dbus_g_connection_unref0 (self->priv->_connection);
}


GType administration_server_get_type (void) {
	static volatile gsize administration_server_type_id__volatile = 0;
	if (g_once_init_enter (&administration_server_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_administration_server_init, value_administration_server_free_value, value_administration_server_copy_value, value_administration_server_peek_pointer, "p", value_administration_server_collect_value, "p", value_administration_server_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (AdministrationServerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) administration_server_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AdministrationServer), 0, (GInstanceInitFunc) administration_server_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType administration_server_type_id;
		administration_server_type_id = g_type_register_fundamental (g_type_fundamental_next (), "AdministrationServer", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&administration_server_type_id__volatile, administration_server_type_id);
	}
	return administration_server_type_id__volatile;
}


gpointer administration_server_ref (gpointer instance) {
	AdministrationServer* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void administration_server_unref (gpointer instance) {
	AdministrationServer* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		ADMINISTRATION_SERVER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}




