/*
*   Copyright (C) 2011 by Marco Martin <mart@kde.org>
*
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU Library General Public License as
*   published by the Free Software Foundation; either version 2, or
*   (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU Library General Public License for more details
*
*   You should have received a copy of the GNU Library General Public
*   License along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   51 Franklin Street, Fifth Floor, Boston, MA  2.010-1301, USA.
*/

import QtQuick 2.1
import QtQuick.Window 2.2
import QtQuick.Controls 1.0
import QtQuick.Controls.Private 1.0 as QtQuickControlsPrivate
import org.kde.plasma.core 2.0 as PlasmaCore

/**
 * This is a label which uses the plasma theme.
 *
 * The characteristics of the text will be automatically set according to the
 * plasma theme. If you need a more customized text item use the Text component
 * from QtQuick.
 *
 * You can use all elements of the QML Text component, in particular the "text"
 * property to define the label text.
 *
 * @inherit QtQuick.Text
 */
Text {
    id: root

    height: Math.round(Math.max(paintedHeight, PlasmaCore.Theme.mSize(PlasmaCore.Theme.defaultFont).height*1.6))
    verticalAlignment: lineCount > 1 ? Text.AlignTop : Text.AlignVCenter

    activeFocusOnTab: false

    // Work around Qt bug where NativeRendering breaks for non-integer scale factors
    // https://bugreports.qt.io/browse/QTBUG-70481
    renderType: QtQuickControlsPrivate.Settings.isMobile || Screen.devicePixelRatio % 1 !== 0 ? Text.QtRendering : Text.NativeRendering

    font.capitalization: PlasmaCore.Theme.defaultFont.capitalization
    font.family: PlasmaCore.Theme.defaultFont.family
    font.italic: PlasmaCore.Theme.defaultFont.italic
    font.letterSpacing: PlasmaCore.Theme.defaultFont.letterSpacing
    font.pointSize: PlasmaCore.Theme.defaultFont.pointSize
    font.strikeout: PlasmaCore.Theme.defaultFont.strikeout
    font.underline: PlasmaCore.Theme.defaultFont.underline
    font.weight: PlasmaCore.Theme.defaultFont.weight
    font.wordSpacing: PlasmaCore.Theme.defaultFont.wordSpacing
    color: PlasmaCore.ColorScope.textColor

    opacity: enabled? 1 : 0.6

    Accessible.role: Accessible.StaticText
    Accessible.name: text
}
