/*
 * This file is part of the DOM implementation for KDE.
 *
 * Copyright 2003 Lars Knoll (knoll@kde.org)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

/* This file is mostly data generated by flex. Unfortunately flex
   can't handle 16bit strings directly, so we just copy the part of
   the code we need and modify it to our needs.

   Most of the defines below are to make sure we can easily use the
   flex generated code, using as little editing as possible.

   The flex syntax to generate the lexer are more or less directly
   copied from the CSS2.1 specs, with some fixes for comments and
   the important symbol.

   To regenerate, run flex on tokenizer.flex. After this, copy the
   data tables and the YY_DECL method over to this file. Remove the
   init code from YY_DECL and change the YY_END_OF_BUFFER to only call
   yyterminate().

*/

// --------- begin generated code -------------------


#include "parser.h"

#define INITIAL 0
#define mediaquery 1
#define at_rule 2
#define block 3

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined __STDC_VERSION__ && __STDC_VERSION__ >= 199901L
#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t;
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;
#endif /* ! C99 */
#define YY_NUM_RULES 67
#define YY_END_OF_BUFFER 68
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[411] =
    {   0,
        0,    0,    0,    0,    0,    0,    0,    0,   68,   66,
        2,    2,   66,   66,   66,   66,   66,   66,   66,   66,
       66,   66,   52,   66,   66,   14,   14,   14,   66,   66,
       60,   66,   66,   66,   52,   65,   14,   14,   14,   64,
       62,   61,   66,   63,    2,    0,    0,    0,   13,    0,
        0,   17,    0,    8,    0,    0,    9,    0,   15,    0,
       14,   14,    0,   53,    0,   51,    0,    0,   52,   50,
       50,   50,   50,   50,   50,   50,   50,   50,   15,   50,
       50,   45,    0,   50,    0,    0,    0,    0,    0,    0,
        0,    0,   57,   14,    0,    0,    0,   14,   14,    0,

       14,   14,   14,    7,    6,    5,   53,    0,   52,   50,
       14,   14,   14,    0,   17,    0,    0,    0,   13,    0,
        0,   17,    0,   17,   17,    0,    0,   13,    0,    0,
        4,    0,    0,   50,    0,   33,   36,   50,   30,   32,
       50,   46,   38,   50,   37,   44,   50,   40,   39,   35,
       50,   50,   50,   50,   50,    0,    0,    0,    0,    0,
        0,    0,    0,   14,   14,    0,   15,   14,   14,   58,
       58,   14,   14,   50,   12,   10,   14,    0,   17,    0,
        0,    0,   17,   17,   17,    0,    0,    0,    1,   50,
       50,   41,   50,   49,   15,   42,   34,   50,   50,    3,

        0,    0,    0,    0,    0,    0,    0,   14,   54,    0,
       58,   58,   58,   57,   14,   50,   47,   11,   16,   16,
        0,    0,   17,   17,    0,    0,    0,   50,   43,   50,
       50,    0,    0,    0,    0,    0,    0,   19,   14,   59,
       58,   58,   58,   58,    0,    0,    0,    0,   56,    0,
       14,   48,    0,   17,    0,    0,   17,   17,    0,   50,
       50,   31,    0,    0,    0,    0,   20,    0,   14,   59,
       58,   58,   58,   58,   58,    0,    0,    0,    0,    0,
        0,    0,    0,    0,   56,    0,    0,   14,    0,   17,
        0,    0,   17,   17,    0,   50,   50,    0,    0,    0,

       18,    0,   14,   59,   58,   58,   58,   58,   58,   58,
        0,   55,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,   14,   16,   16,    0,    0,   17,   17,
        0,   50,   50,    0,   22,    0,    0,   14,   59,   58,
       58,   58,   58,   58,   58,   58,    0,   55,    0,    0,
        0,   55,    0,    0,    0,    0,   17,   50,    0,    0,
        0,    0,    0,    0,    0,   59,    0,    0,    0,   29,
        0,    0,    0,    0,    0,   21,   23,   59,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,   24,    0,    0,    0,    0,   25,    0,    0,   26,

        0,    0,    0,    0,    0,    0,    0,   27,   28,    0
    } ;

static yyconst flex_int32_t yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    4,    5,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    6,    7,    8,    9,   10,   11,   12,   13,   14,
       15,   16,   17,   12,   18,   19,   20,   21,   21,   21,
       21,   21,   21,   21,   21,   21,   21,   12,   22,   23,
       24,   25,   26,   27,   28,   29,   30,   31,   32,   33,
       34,   35,   36,   37,   38,   39,   40,   41,   42,   43,
       44,   45,   46,   47,   48,   49,   37,   50,   51,   52,
       12,   53,   12,   54,   55,   12,   56,   29,   57,   58,

       59,   60,   61,   62,   63,   37,   64,   65,   66,   67,
       68,   69,   70,   71,   72,   73,   74,   75,   37,   76,
       77,   78,   79,   80,   81,   82,    1,   83,   83,   83,
       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,

       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   83,   83
    } ;

static yyconst flex_int32_t yy_meta[84] =
    {   0,
        1,    2,    3,    3,    3,    4,    4,    4,    4,    4,
        4,    4,    4,    5,    4,    4,    4,    6,    4,    4,
        7,    4,    4,    4,    4,    8,    4,    9,    9,    9,
        9,    9,    9,   10,   10,   10,   10,   10,   10,   10,
       10,   10,   10,   10,   10,   10,   10,   10,   10,   10,
       10,   10,   10,    4,   10,    9,    9,    9,    9,    9,
       10,   10,   10,   10,   10,   10,   10,   10,   10,   10,
       10,   10,   10,   10,   10,   10,   10,   10,    4,    4,
        4,    4,   10
    } ;

static yyconst flex_int16_t yy_base[444] =
    {   0,
        0,    0,   65,   69,   63,   67,   83,   86, 1316, 2828,
       96,  110,  124,   86,   78, 1240,   90, 1239,   83,   99,
     1213, 1217,  177, 1222,  243,   94,  260,  254,  259, 1198,
     2828, 1168, 1167, 1169,  132, 2828,  104,  318,  108, 2828,
     2828, 2828,  369, 2828,  174,  291,   69,  115, 2828,  428,
      101, 1136,  309, 2828,  121,  487, 2828,  117,  341, 1134,
      141,  371,  351,  329, 1130, 2828, 1087, 1117,    0, 1047,
      381,  138,  232,  128,  300,  350,  384,  398,  507,  422,
      386, 1046,  473,  130, 1052,  118,  124,  189,  235,  272,
      113,  144, 2828,  341,  506,  550,  567,  572,  401, 1043,

      543,  342,  624, 2828, 2828, 2828,  564, 1026,  560,  580,
      409,  537,  593,  638,  678,  407,  470,  261,  273,  737,
      796,  986,  657,  957,  855,  545,  298,  351,  914,  973,
     2828,  952,  173,  895,  691,  885,  884,  359,  881,  848,
      427,  846,  781,  444,  780,  779,  598,  778,  767,  763,
      410,  571,  760, 1032,  536,  759,  299,  277,  520,  551,
      435,  569,  465,  468, 1091,  658,  751,  620,  583,  241,
      737,  651,  697,  749,  679,  691,  738,  809,  815,  572,
      506,  849,  650, 1150,  900,  400,  933,  686, 2828,  639,
     1209,  638,  590,  619,  594,  560,  546,  986,  727, 2828,

      569,  605,  627,  633,  581,  701,  714,  992, 2828, 1045,
      331,  566,  502,  887, 1051,  721,  454,  750, 1085, 1104,
      717, 1137, 1195, 1215, 1228,  461,  755, 1249,  418, 1262,
      752,  741,  736,  447,  738,  794,  738, 2828, 1268, 1282,
      523,  409,  380,  379, 1341, 1355,  768,  798, 2828, 1407,
     1343,  339, 1413, 1426,  849, 1447, 1460, 1466, 1480, 1500,
     1513,  310,  858,  803,  865,  863, 2828,  881, 1533, 1546,
      524,  336,  303,  244,  232,  993,  770, 1052, 1605,  850,
     1664, 1376, 1617, 1637, 1676, 1728, 1787, 1747, 1793, 1806,
      913, 1827, 1840, 1846, 1860, 1880, 1893,  238,  879,  923,

     2828,  925, 1913, 1926,  962,  178,  177,  176,  175,  166,
     1124, 2828,  811,  886, 1697, 1985, 2044, 1352,  974, 1997,
     2103, 2162, 2221, 1998, 2828, 2004,  942, 2061, 2120, 1170,
     2181, 2227, 2240, 2261, 2828,  925,  954, 1182, 2283,   87,
     2828, 2828, 2828, 2828, 2828, 2828, 2320,  896, 1033, 2323,
     2344,  987, 1015, 2356, 2370, 1084, 1196, 1215,  953, 1039,
     1129, 1172, 1031, 1173, 1203, 2389, 2403, 2422, 2436, 2828,
     1272, 1273, 1211, 1297, 1312, 2828, 2828, 2828, 2455, 2469,
     2488, 1327, 1287, 1337, 1355, 1319, 2502, 2521, 2535, 1344,
     1367, 2828, 1367, 1366, 1545, 1760, 2828, 1360, 1359, 2828,

     1359, 1384, 1468, 1382, 1403, 1509, 1517, 2828, 2828, 2828,
     2594, 2599, 2608, 2613, 2619, 2626, 2635, 2640, 2647, 2656,
     2666, 2668, 2673, 2680, 2687, 2691, 2697, 2707, 2714, 2719,
     2728, 2733, 2741, 2751, 2756, 2764, 2773, 2782, 2787, 2795,
     2804, 2809, 2817
    } ;

static yyconst flex_int16_t yy_def[444] =
    {   0,
      410,    1,    1,    1,    1,    1,    1,    1,  410,  410,
      410,  410,  410,  411,  412,  410,  413,  410,  410,  414,
      410,  410,  410,  410,  410,  415,  415,  415,  416,  410,
      410,  410,  410,  410,   23,  410,  415,  415,  415,  410,
      410,  410,  412,  410,  410,  410,  410,  411,  410,  417,
      412,  418,  419,  410,  413,  420,  410,  410,  410,  410,
      415,  415,  416,   23,  421,  410,  422,  410,   23,  423,
      423,  423,  423,  423,  423,  423,  423,  423,  423,  423,
      423,  423,  424,  423,  410,  410,  410,  410,  410,  410,
      410,  410,  410,  415,  425,  410,  410,  415,  415,  426,

      415,  415,  415,  410,  410,  410,   23,  410,   23,  423,
      415,  415,  415,  410,  418,  410,  411,  411,  411,  411,
      417,  418,  427,  418,  115,  413,  413,  413,  413,  420,
      410,  421,  428,  423,  429,  423,  423,  423,  423,  423,
      423,  423,  423,  423,  423,  423,  423,  423,  423,  423,
      423,  423,  423,  423,  423,  410,  410,  410,  410,  410,
      410,  410,  410,  415,  103,  410,  410,  415,  415,  430,
      410,  415,  103,  423,  415,  415,  415,  410,  115,  410,
      411,  120,  418,  115,  125,  413,  129,  431,  410,  423,
      154,  423,  423,  423,  423,  423,  423,  154,  423,  410,

      410,  410,  410,  410,  410,  410,  410,  165,  410,  410,
      432,  410,  410,  433,  103,  423,  423,  415,  410,  115,
      410,  120,  184,  125,  129,  431,  434,  191,  423,  154,
      423,  410,  410,  410,  410,  410,  410,  410,  165,  410,
      435,  410,  410,  410,  433,  433,  436,  437,  410,  438,
      103,  423,  410,  115,  410,  120,  184,  125,  129,  191,
      154,  423,  410,  410,  410,  410,  410,  410,  165,  410,
      439,  410,  410,  410,  410,  410,  436,  410,  440,  437,
      441,  433,  433,  433,  433,  433,  438,  251,  410,  115,
      410,  120,  184,  125,  129,  191,  154,  410,  410,  410,

      410,  410,  165,  410,  442,  410,  410,  410,  410,  410,
      410,  410,  436,  436,  436,  436,  440,  437,  437,  437,
      437,  443,  433,  288,  410,  115,  410,  120,  184,  326,
      129,  191,  154,  410,  410,  410,  410,  324,  410,  410,
      410,  410,  410,  410,  410,  410,  436,  436,  436,  316,
      437,  437,  437,  321,  323,  410,  326,  333,  410,  410,
      410,  410,  410,  410,  410,  410,  316,  321,  323,  410,
      410,  410,  410,  410,  410,  410,  410,  410,  316,  321,
      323,  410,  410,  410,  410,  410,  316,  321,  323,  410,
      410,  410,  410,  410,  436,  437,  410,  410,  410,  410,

      410,  410,  410,  410,  410,  410,  410,  410,  410,    0,
      410,  410,  410,  410,  410,  410,  410,  410,  410,  410,
      410,  410,  410,  410,  410,  410,  410,  410,  410,  410,
      410,  410,  410,  410,  410,  410,  410,  410,  410,  410,
      410,  410,  410
    } ;

static yyconst flex_int16_t yy_nxt[2912] =
    {   0,
       10,   11,   12,   11,   11,   11,   13,   14,   15,   16,
       10,   10,   17,   10,   10,   18,   19,   20,   21,   22,
       23,   10,   24,   10,   10,   10,   25,   26,   26,   26,
       26,   26,   26,   26,   26,   26,   26,   26,   26,   26,
       27,   26,   26,   26,   26,   26,   26,   28,   26,   26,
       26,   26,   29,   30,   26,   26,   26,   26,   26,   26,
       26,   26,   26,   26,   26,   26,   27,   26,   26,   26,
       26,   26,   26,   28,   26,   26,   26,   26,   31,   32,
       10,   33,   26,   34,   41,   35,   36,   34,   41,   35,
       36,   43,   37,   49,   43,   51,   37,   45,   45,   45,

       45,   45,   49,   58,  210,   38,   39,   93,  116,   38,
       39,   45,   45,   45,   45,   45,   60,   93,  410,   58,
       37,   93,   49,   59,   37,   46,   46,   46,   46,   46,
       53,   38,   39,   49,  116,   38,   39,   58,   50,   62,
      162,   42,   56,   40,  111,   42,   95,   40,  113,   59,
      108,   63,  109,   53,   93,  157,   95,   59,  158,   47,
       95,   10,  110,   44,   10,   62,   44,   50,  162,  138,
      111,  163,  141,   56,  113,   45,   45,   45,   45,   45,
      135,  157,  135,   59,  155,  158,   47,   66,  133,  110,
      135,  346,  189,   95,   67,   68,  138,   69,  141,  163,

      345,  344,  343,  342,   70,   70,   71,   72,   73,   70,
       74,   75,   76,   70,   77,   70,   78,   79,   70,   80,
       70,   81,   82,   70,   70,   70,   70,   70,   70,   83,
      159,   84,   70,   71,   72,   73,   70,   74,   75,   76,
       77,   70,   78,   79,   70,   80,   70,   81,   82,   70,
       70,   70,   70,   70,   70,  334,  159,  310,  210,   70,
       86,   96,   96,   96,   96,   96,  212,   93,   49,  309,
      100,  139,   87,   93,  160,   88,   97,   98,   89,  103,
       49,  140,   90,   91,  135,   92,  103,  103,  103,  103,
      103,  103,   46,   46,   46,   46,   46,  139,  101,   87,

      160,   99,   88,  161,  202,   89,   95,  140,   90,   91,
       49,   92,   95,   50,  103,  103,  103,  103,  103,   96,
       96,   96,   96,   96,  101,   50,   47,   99,  308,  125,
      161,   93,  202,  201,   97,   98,  125,  125,  125,  125,
      125,  125,   96,   96,   96,   96,   96,  410,  210,   64,
       56,  142,  135,   47,   93,   93,  242,   97,   97,  112,
      201,  307,  135,   49,  125,  125,  125,  125,  125,   70,
       95,  103,   96,   96,   96,   96,   96,  142,  103,  103,
      103,  103,  103,  103,   93,  112,   51,   97,   98,  114,
      143,  135,  192,   95,   95,   70,  115,  115,  115,  115,

      115,  115,  135,   56,  275,  274,  103,  103,  103,  103,
      103,  135,   49,  151,   93,  136,  143,  152,  144,  192,
      137,   53,   93,   95,  115,  115,  115,  115,  115,   48,
       48,   48,  117,  135,  273,  119,  135,  145,  135,  175,
      196,  151,  136,  146,  152,  144,  137,  169,  120,  180,
      135,  148,   56,   95,  193,  120,  120,  120,  120,  120,
      120,   95,  135,  145,  265,  205,  175,  196,  149,  146,
      135,  150,   48,  169,  135,  180,  227,   49,  148,  135,
      121,   93,  193,  120,  120,  120,  120,  120,   55,   55,
       55,  126,  205,  154,  149,  194,  135,  150,  207,  128,

      154,  154,  154,  154,  154,  154,  135,  129,   96,   96,
       96,   96,   96,   49,  129,  129,  129,  129,  129,  129,
       95,  194,   50,   97,  147,  207,  165,  244,  154,  154,
      154,  154,  154,  165,  165,  165,  165,  165,  165,  130,
      210,  210,  129,  129,  129,  129,  129,   55,  272,  306,
       93,   96,   96,   96,   96,   96,   93,   49,   50,  135,
      203,  165,  165,  165,  165,  165,   97,   97,  166,  166,
      166,  166,  166,  166,  166,  166,  166,  166,  108,  199,
      109,  172,  410,  176,  107,   93,  203,  167,  135,   95,
      110,  243,  168,  204,  110,   95,  209,   56,  135,  166,

      166,  166,  166,  166,   70,  199,   93,  172,  206,  176,
      197,  138,  135,  221,  195,  232,  236,  110,  195,  204,
      229,  110,  174,  135,   95,  102,  102,  102,  102,  102,
       70,  177,  135,   93,  206,   95,  197,   93,  138,  221,
      168,  232,  135,  236,  173,   95,  135,  229,  174,  233,
      135,  173,  173,  173,  173,  173,  173,  177,  178,  166,
      166,  166,  166,  166,  214,  178,  178,  178,  178,  178,
      178,  135,   95,  234,  235,  233,   95,  184,  167,  173,
      173,  173,  173,  173,  184,  184,  184,  184,  184,  184,
      135,  135,   93,  178,  178,  178,  178,  178,  179,  234,

      235,  227,  123,   95,  209,  179,  179,  179,  179,  179,
      179,  191,  184,  184,  184,  184,  184,  215,  191,  191,
      191,  191,  191,  191,  215,  215,  215,  215,  215,  215,
      123,   95,  237,  179,  179,  179,  179,  179,  118,  181,
      181,  181,  118,   95,   49,  238,  191,  191,  191,  191,
      191,   93,  215,  215,  215,  215,  215,  182,  231,  237,
      252,  255,  213,   93,  182,  182,  182,  182,  182,  182,
      227,  167,  238,  135,  189,  278,  200,  278,  216,  135,
      263,  264,  266,  268,  217,  231,  252,  255,  218,   50,
       95,  262,  182,  182,  182,  182,  182,   48,   48,   48,

      117,  135,   95,  119,  135,  216,  263,  264,  266,  268,
      278,  217,  135,  277,  218,  135,  120,  262,  278,  135,
      279,  267,  279,  120,  120,  120,  120,  120,  120,  219,
      135,  135,  135,  135,  299,  220,  219,  219,  219,  219,
      219,  219,  220,  220,  220,  220,  220,  220,  121,  267,
      281,  120,  120,  120,  120,  120,  124,  124,  124,  124,
      124,  299,  278,  279,  219,  219,  219,  219,  219,  222,
      220,  220,  220,  220,  220,  185,  222,  222,  222,  222,
      222,  222,  185,  185,  185,  185,  185,  185,  245,  245,
      245,  245,  245,  278,  247,  291,  298,  300,  135,  248,

      135,  249,  281,  278,  222,  222,  222,  222,  222,  301,
      185,  185,  185,  185,  185,  127,  186,  186,  186,  127,
      224,  291,  298,  302,  300,  335,   49,  224,  224,  224,
      224,  224,  224,  135,  187,  301,  135,  135,  279,  250,
      327,  187,  187,  187,  187,  187,  187,  135,  279,  302,
      336,  335,  337,  225,  364,  224,  224,  224,  224,  224,
      225,  225,  225,  225,  225,  225,   56,  133,  327,  187,
      187,  187,  187,  187,   55,   55,   55,  126,  336,  210,
      337,  364,  356,  365,  371,  128,  278,  341,  225,  225,
      225,  225,  225,  129,  276,  276,  276,  276,  276,  278,

      129,  129,  129,  129,  129,  129,  230,  249,  356,  123,
      365,  371,  239,  230,  230,  230,  230,  230,  230,  239,
      239,  239,  239,  239,  239,  130,  281,  278,  129,  129,
      129,  129,  129,  153,  153,  153,  153,  153,  123,  281,
      278,  230,  230,  230,  230,  230,  107,  239,  239,  239,
      239,  239,  198,  311,  311,  311,  311,  311,  375,  198,
      198,  198,  198,  198,  198,  240,  312,  281,  171,  156,
      372,  251,  240,  240,  240,  240,  240,  240,  251,  251,
      251,  251,  251,  251,  135,  279,  375,  198,  198,  198,
      198,  198,  164,  164,  164,  164,  164,  372,  135,  135,

      240,  240,  240,  240,  240,  253,  251,  251,  251,  251,
      251,  208,  253,  253,  253,  253,  253,  253,  208,  208,
      208,  208,  208,  208,  254,  311,  311,  311,  311,  311,
      370,  254,  254,  254,  254,  254,  254,   64,  312,   83,
      253,  253,  253,  253,  253,  133,  208,  208,  208,  208,
      208,  183,  183,  183,  183,  183,  370,  256,  131,  254,
      254,  254,  254,  254,  256,  256,  256,  256,  256,  256,
      223,  124,  124,  124,  124,  124,  373,  223,  223,  223,
      223,  223,  223,  164,  164,  164,  164,  164,  123,  107,
      106,  105,  256,  256,  256,  256,  256,  183,  183,  183,

      183,  183,  373,  374,  376,  223,  223,  223,  223,  223,
      190,  190,  190,  190,  190,  257,  190,  190,  190,  190,
      190,  104,  257,  257,  257,  257,  257,  257,   85,  228,
      374,  376,   65,   64,  377,  258,  228,  228,  228,  228,
      228,  228,  258,  258,  258,  258,  258,  258,  259,  384,
      257,  257,  257,  257,  257,  259,  259,  259,  259,  259,
      259,  377,   57,   54,  228,  228,  228,  228,  228,  260,
      258,  258,  258,  258,  258,  384,  260,  260,  260,  260,
      260,  260,  261,  259,  259,  259,  259,  259,  269,  261,
      261,  261,  261,  261,  261,  269,  269,  269,  269,  269,

      269,  382,  270,  383,  260,  260,  260,  260,  260,  270,
      270,  270,  270,  270,  270,  410,  410,  261,  261,  261,
      261,  261,  391,  269,  269,  269,  269,  269,  382,  410,
      383,  410,  410,  410,  410,  385,  410,  270,  270,  270,
      270,  270,  245,  245,  245,  245,  245,  410,  247,  391,
      386,  410,  410,  248,  280,  249,  276,  276,  276,  276,
      276,  385,  410,  288,  278,  390,  394,  410,  392,  249,
      288,  288,  288,  288,  288,  288,  386,  276,  276,  276,
      276,  276,  410,  410,  410,  410,  393,  410,  410,  397,
      249,  390,  394,  250,  398,  392,  399,  400,  288,  288,

      288,  288,  288,  401,  281,  402,  403,  250,  276,  276,
      276,  276,  282,  393,  284,  397,  410,  410,  410,  284,
      284,  285,  398,  399,  400,  404,  406,  286,  250,  401,
      410,  402,  403,  289,  286,  286,  286,  286,  286,  286,
      289,  289,  289,  289,  289,  289,  290,  407,  410,  410,
      410,  404,  406,  290,  290,  290,  290,  290,  290,  287,
      410,  410,  286,  286,  286,  286,  286,  292,  289,  289,
      289,  289,  289,  407,  292,  292,  292,  292,  292,  292,
      293,  290,  290,  290,  290,  290,  294,  293,  293,  293,
      293,  293,  293,  294,  294,  294,  294,  294,  294,  405,

      295,  410,  292,  292,  292,  292,  292,  295,  295,  295,
      295,  295,  295,  410,  410,  293,  293,  293,  293,  293,
      296,  294,  294,  294,  294,  294,  405,  296,  296,  296,
      296,  296,  296,  297,  410,  295,  295,  295,  295,  295,
      297,  297,  297,  297,  297,  297,  314,  349,  349,  349,
      314,  410,  278,  303,  408,  296,  296,  296,  296,  296,
      303,  303,  303,  303,  303,  303,  304,  409,  297,  297,
      297,  297,  297,  304,  304,  304,  304,  304,  304,  410,
      408,  410,  410,  410,  410,  410,  410,  410,  303,  303,
      303,  303,  303,  409,  410,  410,  410,  279,  410,  410,

      410,  304,  304,  304,  304,  304,  277,  277,  277,  313,
      410,  410,  315,  410,  410,  410,  410,  410,  276,  276,
      276,  276,  276,  410,  410,  316,  410,  410,  410,  410,
      410,  249,  316,  316,  316,  316,  316,  316,  276,  276,
      276,  276,  276,  410,  410,  410,  410,  410,  410,  410,
      410,  249,  410,  410,  410,  410,  410,  317,  410,  410,
      316,  316,  316,  316,  316,  280,  280,  280,  318,  250,
      410,  410,  410,  410,  410,  410,  320,  276,  276,  276,
      276,  276,  410,  410,  321,  410,  410,  410,  410,  250,
      249,  321,  321,  321,  321,  321,  321,  410,  347,  311,

      311,  311,  347,  410,  278,  410,  410,  410,  410,  410,
      410,  348,  410,  410,  410,  410,  322,  410,  410,  321,
      321,  321,  321,  321,  410,  410,  410,  410,  250,  282,
      282,  282,  282,  282,  410,  410,  410,  410,  410,  410,
      410,  410,  249,  410,  410,  410,  410,  410,  323,  279,
      410,  410,  410,  410,  410,  323,  323,  323,  323,  323,
      323,  319,  353,  353,  353,  319,  410,  324,  410,  410,
      410,  410,  278,  410,  324,  324,  324,  324,  324,  324,
      250,  410,  410,  323,  323,  323,  323,  323,  276,  276,
      276,  276,  282,  410,  284,  410,  410,  410,  410,  284,

      284,  285,  324,  324,  324,  324,  324,  286,  410,  410,
      410,  410,  281,  325,  286,  286,  286,  286,  286,  286,
      325,  325,  325,  325,  325,  325,  326,  410,  410,  410,
      410,  410,  410,  326,  326,  326,  326,  326,  326,  287,
      410,  410,  286,  286,  286,  286,  286,  328,  325,  325,
      325,  325,  325,  410,  328,  328,  328,  328,  328,  328,
      329,  326,  326,  326,  326,  326,  330,  329,  329,  329,
      329,  329,  329,  330,  330,  330,  330,  330,  330,  410,
      331,  410,  328,  328,  328,  328,  328,  331,  331,  331,
      331,  331,  331,  410,  410,  329,  329,  329,  329,  329,

      332,  330,  330,  330,  330,  330,  410,  332,  332,  332,
      332,  332,  332,  333,  410,  331,  331,  331,  331,  331,
      333,  333,  333,  333,  333,  333,  410,  410,  410,  410,
      410,  410,  410,  338,  410,  332,  332,  332,  332,  332,
      338,  338,  338,  338,  338,  338,  339,  410,  333,  333,
      333,  333,  333,  339,  339,  339,  339,  339,  339,  410,
      410,  410,  410,  410,  410,  410,  410,  410,  338,  338,
      338,  338,  338,  410,  410,  410,  410,  410,  410,  410,
      410,  339,  339,  339,  339,  339,  314,  349,  349,  349,
      314,  410,  278,  410,  410,  410,  410,  410,  351,  311,

      311,  311,  351,  410,  410,  350,  410,  410,  410,  278,
      410,  352,  350,  350,  350,  350,  350,  350,   94,  410,
      410,  410,  410,  410,  122,   94,   94,   94,   94,   94,
       94,  122,  122,  122,  122,  122,  122,  279,  410,  410,
      350,  350,  350,  350,  350,  277,  277,  277,  313,  281,
      410,  315,  410,   94,   94,   94,   94,   94,  410,  122,
      122,  122,  122,  122,  316,  410,  410,  410,  410,  410,
      410,  316,  316,  316,  316,  316,  316,  410,  410,  410,
      410,   48,  410,  410,  410,  410,  410,  410,   48,   48,
       48,   48,   48,   48,  410,  410,  317,  410,  410,  316,

      316,  316,  316,  316,  319,  353,  353,  353,  319,  410,
      410,  410,  410,  410,  410,  278,   48,   48,   48,   48,
       48,  410,  410,  354,  410,  410,  410,  410,  410,  410,
      354,  354,  354,  354,  354,  354,  410,  410,  410,  410,
      357,  410,  410,  410,  410,  410,  410,  357,  357,  357,
      357,  357,  357,  410,  410,  281,  410,  410,  354,  354,
      354,  354,  354,  280,  280,  280,  318,  410,  410,  410,
      410,  410,  410,  410,  320,  357,  357,  357,  357,  357,
      410,  410,  321,  410,  410,  410,  410,  410,  410,  321,
      321,  321,  321,  321,  321,  410,  410,  410,  410,  410,

      410,   55,  410,  410,  410,  410,  410,  410,   55,   55,
       55,   55,   55,   55,  322,  410,  410,  321,  321,  321,
      321,  321,  282,  282,  282,  282,  282,  410,  410,  410,
      410,  410,  410,  410,  410,  249,   55,   55,   55,   55,
       55,  355,  410,  410,  410,  410,  410,  358,  355,  355,
      355,  355,  355,  355,  358,  358,  358,  358,  358,  358,
      134,  410,  410,  410,  410,  410,  410,  134,  134,  134,
      134,  134,  134,  250,  410,  410,  355,  355,  355,  355,
      355,  410,  358,  358,  358,  358,  358,  410,  410,  410,
      410,  359,  410,  410,  410,  134,  134,  134,  134,  134,

      360,  410,  410,  366,  410,  361,  362,  410,  410,  363,
      366,  366,  366,  366,  366,  366,  410,  410,  359,  410,
      410,  347,  311,  311,  311,  347,  360,  278,  410,  410,
      410,  361,  362,  410,  348,  363,  410,  410,  366,  366,
      366,  366,  366,  367,  410,  351,  311,  311,  311,  351,
      367,  367,  367,  367,  367,  367,  278,  410,  352,  410,
      410,  410,  410,  410,  410,  410,  410,  410,  410,  410,
      410,  410,  279,  410,  410,  410,  368,  410,  367,  367,
      367,  367,  367,  368,  368,  368,  368,  368,  368,  410,
      369,  410,  410,  410,  410,  410,  281,  369,  369,  369,

      369,  369,  369,  410,  410,  410,  410,  410,  410,  378,
      410,  368,  368,  368,  368,  368,  378,  378,  378,  378,
      378,  378,  410,  379,  410,  369,  369,  369,  369,  369,
      379,  379,  379,  379,  379,  379,  410,  410,  410,  410,
      410,  410,  380,  410,  378,  378,  378,  378,  378,  380,
      380,  380,  380,  380,  380,  410,  381,  410,  379,  379,
      379,  379,  379,  381,  381,  381,  381,  381,  381,  410,
      410,  410,  410,  410,  410,  387,  410,  380,  380,  380,
      380,  380,  387,  387,  387,  387,  387,  387,  410,  388,
      410,  381,  381,  381,  381,  381,  388,  388,  388,  388,

      388,  388,  410,  410,  410,  410,  410,  410,  389,  410,
      387,  387,  387,  387,  387,  389,  389,  389,  389,  389,
      389,  410,  395,  410,  388,  388,  388,  388,  388,  395,
      395,  395,  395,  395,  395,  410,  410,  410,  410,  410,
      410,  396,  410,  389,  389,  389,  389,  389,  396,  396,
      396,  396,  396,  396,  410,  246,  410,  395,  395,  395,
      395,  395,  246,  246,  246,  246,  246,  246,  410,  410,
      410,  410,  410,  410,  410,  410,  396,  396,  396,  396,
      396,  410,  410,  410,  410,  410,  410,  410,  410,  410,
      246,  246,  246,  246,  246,   48,  410,   48,   48,   48,

       48,   48,   48,   48,   52,  410,  410,   52,   52,   55,
      410,   55,   55,   55,   55,   55,   55,   55,   61,   61,
      410,   61,   61,   94,   94,   94,  410,   94,   94,  102,
      102,  102,  102,  102,  102,  102,  118,  118,  118,  118,
      118,  118,  118,  118,  118,  122,  122,  410,  122,  122,
      124,  124,  124,  124,  124,  124,  124,  127,  127,  127,
      127,  127,  127,  127,  127,  127,  132,  132,  132,  132,
      132,  132,  132,  132,  132,  132,   70,   70,  134,  134,
      410,  134,  134,  153,  153,  153,  153,  153,  153,  153,
      164,  164,  164,  164,  164,  164,  164,  170,  170,  170,

      183,  183,  183,  183,  183,  183,  183,  188,  188,  188,
      188,  188,  188,  188,  188,  188,  188,  190,  190,  190,
      190,  190,  190,  190,  211,  211,  211,  211,  226,  226,
      226,  226,  226,  226,  226,  226,  226,  226,  241,  241,
      241,  241,  246,  246,  246,  410,  246,  246,  246,  246,
      246,  188,  188,  188,  188,  188,  188,  188,  188,  188,
      188,  271,  271,  271,  271,  277,  410,  277,  277,  277,
      277,  277,  277,  277,  280,  410,  280,  280,  280,  280,
      280,  280,  280,  283,  283,  283,  283,  283,  283,  283,
      283,  283,  305,  305,  305,  305,  314,  314,  314,  314,

      314,  314,  314,  314,  314,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  340,  340,  340,  340,  319,  319,
      319,  319,  319,  319,  319,  319,  319,    9,  410,  410,
      410,  410,  410,  410,  410,  410,  410,  410,  410,  410,
      410,  410,  410,  410,  410,  410,  410,  410,  410,  410,
      410,  410,  410,  410,  410,  410,  410,  410,  410,  410,
      410,  410,  410,  410,  410,  410,  410,  410,  410,  410,
      410,  410,  410,  410,  410,  410,  410,  410,  410,  410,
      410,  410,  410,  410,  410,  410,  410,  410,  410,  410,
      410,  410,  410,  410,  410,  410,  410,  410,  410,  410,

      410,  410,  410,  410,  410,  410,  410,  410,  410,  410,
      410
    } ;

static yyconst flex_int16_t yy_chk[2912] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    3,    5,    3,    3,    4,    6,    4,
        4,    7,    3,   14,    8,   15,    4,   11,   11,   11,

       11,   11,   17,   19,  340,    3,    3,   26,   47,    4,
        4,   12,   12,   12,   12,   12,   20,   37,   51,   20,
        3,   39,   48,   19,    4,   13,   13,   13,   13,   13,
       15,    3,    3,   55,   47,    4,    4,   58,   14,   20,
       91,    5,   17,    3,   37,    6,   26,    4,   39,   19,
       35,   20,   35,   51,   61,   86,   37,   58,   87,   13,
       39,    7,   35,    7,    8,   20,    8,   48,   91,   72,
       37,   92,   74,   55,   39,   45,   45,   45,   45,   45,
       74,   86,   84,   58,   84,   87,   13,   23,  133,   35,
       72,  310,  133,   61,   23,   23,   72,   23,   74,   92,

      309,  308,  307,  306,   23,   23,   23,   23,   23,   23,
       23,   23,   23,   23,   23,   23,   23,   23,   23,   23,
       23,   23,   23,   23,   23,   23,   23,   23,   23,   23,
       88,   23,   23,   23,   23,   23,   23,   23,   23,   23,
       23,   23,   23,   23,   23,   23,   23,   23,   23,   23,
       23,   23,   23,   23,   23,  298,   88,  275,  170,   23,
       25,   27,   27,   27,   27,   27,  170,   28,  118,  274,
       28,   73,   25,   27,   89,   25,   27,   27,   25,   29,
      119,   73,   25,   25,   73,   25,   29,   29,   29,   29,
       29,   29,   46,   46,   46,   46,   46,   73,   28,   25,

       89,   27,   25,   90,  158,   25,   28,   73,   25,   25,
      127,   25,   27,  118,   29,   29,   29,   29,   29,   38,
       38,   38,   38,   38,   28,  119,   46,   27,  273,   53,
       90,   38,  158,  157,   38,   38,   53,   53,   53,   53,
       53,   53,   59,   59,   59,   59,   59,   64,  211,   64,
      127,   75,   75,   46,   94,  102,  211,   59,   59,   38,
      157,  272,  262,  128,   53,   53,   53,   53,   53,   64,
       38,   63,   62,   62,   62,   62,   62,   75,   63,   63,
       63,   63,   63,   63,   62,   38,   43,   62,   62,   43,
       76,  252,  138,   94,  102,   64,   43,   43,   43,   43,

       43,   43,   76,  128,  244,  243,   63,   63,   63,   63,
       63,  138,  186,   81,   99,   71,   76,   81,   77,  138,
       71,   43,  111,   62,   43,   43,   43,   43,   43,   50,
       50,   50,   50,   71,  242,   50,   77,   78,   81,  111,
      151,   81,   71,   78,   81,   77,   71,   99,   50,  116,
       78,   80,  186,   99,  141,   50,   50,   50,   50,   50,
       50,  111,  151,   78,  234,  161,  111,  151,   80,   78,
      229,   80,  117,   99,   80,  116,  226,  117,   80,  141,
       50,  164,  141,   50,   50,   50,   50,   50,   56,   56,
       56,   56,  161,   83,   80,  144,  144,   80,  163,   56,

       83,   83,   83,   83,   83,   83,  217,   56,   79,   79,
       79,   79,   79,  181,   56,   56,   56,   56,   56,   56,
      164,  144,  117,   79,   79,  163,   95,  213,   83,   83,
       83,   83,   83,   95,   95,   95,   95,   95,   95,   56,
      241,  271,   56,   56,   56,   56,   56,  126,  241,  271,
      112,   96,   96,   96,   96,   96,  101,  126,  181,   79,
      159,   95,   95,   95,   95,   95,   96,   96,   97,   97,
       97,   97,   97,   98,   98,   98,   98,   98,  109,  155,
      109,  101,  107,  112,  107,   98,  159,   97,  155,  112,
      109,  212,   98,  160,  107,  101,  169,  126,  197,  147,

      147,  147,  147,  147,  107,  155,  113,  101,  162,  112,
      152,  110,  196,  180,  195,  201,  205,  109,  147,  160,
      193,  107,  110,  152,   98,  103,  103,  103,  103,  103,
      107,  113,  110,  168,  162,  169,  152,  103,  110,  180,
      168,  201,  193,  205,  103,  113,  195,  193,  110,  202,
      147,  103,  103,  103,  103,  103,  103,  113,  114,  166,
      166,  166,  166,  166,  172,  114,  114,  114,  114,  114,
      114,  194,  168,  203,  204,  202,  103,  123,  166,  103,
      103,  103,  103,  103,  123,  123,  123,  123,  123,  123,
      192,  190,  175,  114,  114,  114,  114,  114,  115,  203,

      204,  188,  183,  172,  176,  115,  115,  115,  115,  115,
      115,  135,  123,  123,  123,  123,  123,  173,  135,  135,
      135,  135,  135,  135,  173,  173,  173,  173,  173,  173,
      115,  175,  206,  115,  115,  115,  115,  115,  120,  120,
      120,  120,  120,  176,  120,  207,  135,  135,  135,  135,
      135,  177,  173,  173,  173,  173,  173,  120,  199,  206,
      216,  221,  171,  218,  120,  120,  120,  120,  120,  120,
      227,  167,  207,  216,  227,  247,  156,  277,  174,  199,
      232,  233,  235,  237,  174,  199,  216,  221,  177,  120,
      177,  231,  120,  120,  120,  120,  120,  121,  121,  121,

      121,  174,  218,  121,  231,  174,  232,  233,  235,  237,
      248,  174,  153,  313,  177,  150,  121,  231,  313,  149,
      247,  236,  277,  121,  121,  121,  121,  121,  121,  178,
      148,  146,  145,  143,  264,  179,  178,  178,  178,  178,
      178,  178,  179,  179,  179,  179,  179,  179,  121,  236,
      248,  121,  121,  121,  121,  121,  125,  125,  125,  125,
      125,  264,  280,  313,  178,  178,  178,  178,  178,  182,
      179,  179,  179,  179,  179,  125,  182,  182,  182,  182,
      182,  182,  125,  125,  125,  125,  125,  125,  214,  214,
      214,  214,  214,  314,  214,  255,  263,  265,  142,  214,

      140,  214,  280,  348,  182,  182,  182,  182,  182,  266,
      125,  125,  125,  125,  125,  129,  129,  129,  129,  129,
      185,  255,  263,  268,  265,  299,  129,  185,  185,  185,
      185,  185,  185,  139,  129,  266,  137,  136,  314,  214,
      291,  129,  129,  129,  129,  129,  129,  134,  348,  268,
      300,  299,  302,  187,  336,  185,  185,  185,  185,  185,
      187,  187,  187,  187,  187,  187,  129,  132,  291,  129,
      129,  129,  129,  129,  130,  130,  130,  130,  300,  305,
      302,  336,  327,  337,  359,  130,  319,  305,  187,  187,
      187,  187,  187,  130,  276,  276,  276,  276,  276,  352,

      130,  130,  130,  130,  130,  130,  198,  276,  327,  124,
      337,  359,  208,  198,  198,  198,  198,  198,  198,  208,
      208,  208,  208,  208,  208,  130,  319,  353,  130,  130,
      130,  130,  130,  154,  154,  154,  154,  154,  122,  352,
      349,  198,  198,  198,  198,  198,  108,  208,  208,  208,
      208,  208,  154,  278,  278,  278,  278,  278,  363,  154,
      154,  154,  154,  154,  154,  210,  278,  353,  100,   85,
      360,  215,  210,  210,  210,  210,  210,  210,  215,  215,
      215,  215,  215,  215,  154,  349,  363,  154,  154,  154,
      154,  154,  165,  165,  165,  165,  165,  360,   82,   70,

      210,  210,  210,  210,  210,  219,  215,  215,  215,  215,
      215,  165,  219,  219,  219,  219,  219,  219,  165,  165,
      165,  165,  165,  165,  220,  311,  311,  311,  311,  311,
      356,  220,  220,  220,  220,  220,  220,   68,  311,   67,
      219,  219,  219,  219,  219,   65,  165,  165,  165,  165,
      165,  184,  184,  184,  184,  184,  356,  222,   60,  220,
      220,  220,  220,  220,  222,  222,  222,  222,  222,  222,
      184,  330,  330,  330,  330,  330,  361,  184,  184,  184,
      184,  184,  184,  338,  338,  338,  338,  338,   52,   34,
       33,   32,  222,  222,  222,  222,  222,  357,  357,  357,

      357,  357,  361,  362,  364,  184,  184,  184,  184,  184,
      191,  191,  191,  191,  191,  223,  358,  358,  358,  358,
      358,   30,  223,  223,  223,  223,  223,  223,   24,  191,
      362,  364,   22,   21,  365,  224,  191,  191,  191,  191,
      191,  191,  224,  224,  224,  224,  224,  224,  225,  373,
      223,  223,  223,  223,  223,  225,  225,  225,  225,  225,
      225,  365,   18,   16,  191,  191,  191,  191,  191,  228,
      224,  224,  224,  224,  224,  373,  228,  228,  228,  228,
      228,  228,  230,  225,  225,  225,  225,  225,  239,  230,
      230,  230,  230,  230,  230,  239,  239,  239,  239,  239,

      239,  371,  240,  372,  228,  228,  228,  228,  228,  240,
      240,  240,  240,  240,  240,    9,    0,  230,  230,  230,
      230,  230,  383,  239,  239,  239,  239,  239,  371,    0,
      372,    0,    0,    0,    0,  374,    0,  240,  240,  240,
      240,  240,  245,  245,  245,  245,  245,    0,  245,  383,
      375,    0,    0,  245,  318,  245,  246,  246,  246,  246,
      246,  374,  246,  251,  318,  382,  386,  246,  384,  246,
      251,  251,  251,  251,  251,  251,  375,  282,  282,  282,
      282,  282,    0,  282,    0,    0,  385,    0,  282,  390,
      282,  382,  386,  245,  391,  384,  393,  394,  251,  251,

      251,  251,  251,  398,  318,  399,  401,  246,  250,  250,
      250,  250,  250,  385,  250,  390,    0,    0,    0,  250,
      250,  250,  391,  393,  394,  402,  404,  250,  282,  398,
        0,  399,  401,  253,  250,  250,  250,  250,  250,  250,
      253,  253,  253,  253,  253,  253,  254,  405,    0,    0,
        0,  402,  404,  254,  254,  254,  254,  254,  254,  250,
        0,    0,  250,  250,  250,  250,  250,  256,  253,  253,
      253,  253,  253,  405,  256,  256,  256,  256,  256,  256,
      257,  254,  254,  254,  254,  254,  258,  257,  257,  257,
      257,  257,  257,  258,  258,  258,  258,  258,  258,  403,

      259,    0,  256,  256,  256,  256,  256,  259,  259,  259,
      259,  259,  259,    0,    0,  257,  257,  257,  257,  257,
      260,  258,  258,  258,  258,  258,  403,  260,  260,  260,
      260,  260,  260,  261,    0,  259,  259,  259,  259,  259,
      261,  261,  261,  261,  261,  261,  395,  395,  395,  395,
      395,    0,  395,  269,  406,  260,  260,  260,  260,  260,
      269,  269,  269,  269,  269,  269,  270,  407,  261,  261,
      261,  261,  261,  270,  270,  270,  270,  270,  270,    0,
      406,    0,    0,    0,    0,    0,    0,    0,  269,  269,
      269,  269,  269,  407,    0,    0,    0,  395,    0,    0,

        0,  270,  270,  270,  270,  270,  279,  279,  279,  279,
        0,    0,  279,    0,    0,    0,    0,    0,  283,  283,
      283,  283,  283,    0,  283,  279,    0,    0,    0,  283,
        0,  283,  279,  279,  279,  279,  279,  279,  284,  284,
      284,  284,  284,    0,  284,    0,    0,    0,    0,  284,
        0,  284,    0,    0,    0,    0,    0,  279,    0,    0,
      279,  279,  279,  279,  279,  281,  281,  281,  281,  283,
        0,    0,    0,    0,    0,    0,  281,  285,  285,  285,
      285,  285,    0,  285,  281,    0,    0,    0,  285,  284,
      285,  281,  281,  281,  281,  281,  281,    0,  315,  315,

      315,  315,  315,    0,  315,    0,    0,    0,    0,    0,
        0,  315,    0,    0,    0,    0,  281,    0,    0,  281,
      281,  281,  281,  281,    0,    0,    0,    0,  285,  286,
      286,  286,  286,  286,    0,  286,    0,    0,    0,    0,
      286,    0,  286,    0,    0,    0,    0,    0,  286,  315,
        0,    0,    0,    0,    0,  286,  286,  286,  286,  286,
      286,  396,  396,  396,  396,  396,    0,  288,    0,    0,
        0,    0,  396,    0,  288,  288,  288,  288,  288,  288,
      286,    0,    0,  286,  286,  286,  286,  286,  287,  287,
      287,  287,  287,    0,  287,    0,    0,    0,    0,  287,

      287,  287,  288,  288,  288,  288,  288,  287,    0,    0,
        0,    0,  396,  289,  287,  287,  287,  287,  287,  287,
      289,  289,  289,  289,  289,  289,  290,    0,    0,    0,
        0,    0,    0,  290,  290,  290,  290,  290,  290,  287,
        0,    0,  287,  287,  287,  287,  287,  292,  289,  289,
      289,  289,  289,    0,  292,  292,  292,  292,  292,  292,
      293,  290,  290,  290,  290,  290,  294,  293,  293,  293,
      293,  293,  293,  294,  294,  294,  294,  294,  294,    0,
      295,    0,  292,  292,  292,  292,  292,  295,  295,  295,
      295,  295,  295,    0,    0,  293,  293,  293,  293,  293,

      296,  294,  294,  294,  294,  294,    0,  296,  296,  296,
      296,  296,  296,  297,    0,  295,  295,  295,  295,  295,
      297,  297,  297,  297,  297,  297,    0,    0,    0,    0,
        0,    0,    0,  303,    0,  296,  296,  296,  296,  296,
      303,  303,  303,  303,  303,  303,  304,    0,  297,  297,
      297,  297,  297,  304,  304,  304,  304,  304,  304,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  303,  303,
      303,  303,  303,    0,    0,    0,    0,    0,    0,    0,
        0,  304,  304,  304,  304,  304,  316,  316,  316,  316,
      316,    0,  316,    0,    0,    0,    0,    0,  320,  320,

      320,  320,  320,    0,    0,  316,    0,    0,    0,  320,
        0,  320,  316,  316,  316,  316,  316,  316,  324,    0,
        0,    0,    0,    0,  326,  324,  324,  324,  324,  324,
      324,  326,  326,  326,  326,  326,  326,  316,    0,    0,
      316,  316,  316,  316,  316,  317,  317,  317,  317,  320,
        0,  317,    0,  324,  324,  324,  324,  324,    0,  326,
      326,  326,  326,  326,  317,    0,    0,    0,    0,    0,
        0,  317,  317,  317,  317,  317,  317,    0,    0,    0,
        0,  328,    0,    0,    0,    0,    0,    0,  328,  328,
      328,  328,  328,  328,    0,    0,  317,    0,    0,  317,

      317,  317,  317,  317,  321,  321,  321,  321,  321,    0,
        0,    0,    0,    0,    0,  321,  328,  328,  328,  328,
      328,    0,    0,  321,    0,    0,    0,    0,    0,    0,
      321,  321,  321,  321,  321,  321,    0,    0,    0,    0,
      329,    0,    0,    0,    0,    0,    0,  329,  329,  329,
      329,  329,  329,    0,    0,  321,    0,    0,  321,  321,
      321,  321,  321,  322,  322,  322,  322,    0,    0,    0,
        0,    0,    0,    0,  322,  329,  329,  329,  329,  329,
        0,    0,  322,    0,    0,    0,    0,    0,    0,  322,
      322,  322,  322,  322,  322,    0,    0,    0,    0,    0,

        0,  331,    0,    0,    0,    0,    0,    0,  331,  331,
      331,  331,  331,  331,  322,    0,    0,  322,  322,  322,
      322,  322,  323,  323,  323,  323,  323,    0,  323,    0,
        0,    0,    0,  323,    0,  323,  331,  331,  331,  331,
      331,  323,    0,    0,    0,    0,    0,  332,  323,  323,
      323,  323,  323,  323,  332,  332,  332,  332,  332,  332,
      333,    0,    0,    0,    0,    0,    0,  333,  333,  333,
      333,  333,  333,  323,    0,    0,  323,  323,  323,  323,
      323,    0,  332,  332,  332,  332,  332,    0,    0,    0,
        0,  334,    0,    0,    0,  333,  333,  333,  333,  333,

      334,    0,    0,  339,    0,  334,  334,    0,    0,  334,
      339,  339,  339,  339,  339,  339,    0,    0,  334,    0,
        0,  347,  347,  347,  347,  347,  334,  347,    0,    0,
        0,  334,  334,    0,  347,  334,    0,    0,  339,  339,
      339,  339,  339,  350,    0,  351,  351,  351,  351,  351,
      350,  350,  350,  350,  350,  350,  351,    0,  351,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  347,    0,    0,    0,  354,    0,  350,  350,
      350,  350,  350,  354,  354,  354,  354,  354,  354,    0,
      355,    0,    0,    0,    0,    0,  351,  355,  355,  355,

      355,  355,  355,    0,    0,    0,    0,    0,    0,  366,
        0,  354,  354,  354,  354,  354,  366,  366,  366,  366,
      366,  366,    0,  367,    0,  355,  355,  355,  355,  355,
      367,  367,  367,  367,  367,  367,    0,    0,    0,    0,
        0,    0,  368,    0,  366,  366,  366,  366,  366,  368,
      368,  368,  368,  368,  368,    0,  369,    0,  367,  367,
      367,  367,  367,  369,  369,  369,  369,  369,  369,    0,
        0,    0,    0,    0,    0,  379,    0,  368,  368,  368,
      368,  368,  379,  379,  379,  379,  379,  379,    0,  380,
        0,  369,  369,  369,  369,  369,  380,  380,  380,  380,

      380,  380,    0,    0,    0,    0,    0,    0,  381,    0,
      379,  379,  379,  379,  379,  381,  381,  381,  381,  381,
      381,    0,  387,    0,  380,  380,  380,  380,  380,  387,
      387,  387,  387,  387,  387,    0,    0,    0,    0,    0,
        0,  388,    0,  381,  381,  381,  381,  381,  388,  388,
      388,  388,  388,  388,    0,  389,    0,  387,  387,  387,
      387,  387,  389,  389,  389,  389,  389,  389,    0,    0,
        0,    0,    0,    0,    0,    0,  388,  388,  388,  388,
      388,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      389,  389,  389,  389,  389,  411,    0,  411,  411,  411,

      411,  411,  411,  411,  412,    0,    0,  412,  412,  413,
        0,  413,  413,  413,  413,  413,  413,  413,  414,  414,
        0,  414,  414,  415,  415,  415,    0,  415,  415,  416,
      416,  416,  416,  416,  416,  416,  417,  417,  417,  417,
      417,  417,  417,  417,  417,  418,  418,    0,  418,  418,
      419,  419,  419,  419,  419,  419,  419,  420,  420,  420,
      420,  420,  420,  420,  420,  420,  421,  421,  421,  421,
      421,  421,  421,  421,  421,  421,  422,  422,  423,  423,
        0,  423,  423,  424,  424,  424,  424,  424,  424,  424,
      425,  425,  425,  425,  425,  425,  425,  426,  426,  426,

      427,  427,  427,  427,  427,  427,  427,  428,  428,  428,
      428,  428,  428,  428,  428,  428,  428,  429,  429,  429,
      429,  429,  429,  429,  430,  430,  430,  430,  431,  431,
      431,  431,  431,  431,  431,  431,  431,  431,  432,  432,
      432,  432,  433,  433,  433,    0,  433,  433,  433,  433,
      433,  434,  434,  434,  434,  434,  434,  434,  434,  434,
      434,  435,  435,  435,  435,  436,    0,  436,  436,  436,
      436,  436,  436,  436,  437,    0,  437,  437,  437,  437,
      437,  437,  437,  438,  438,  438,  438,  438,  438,  438,
      438,  438,  439,  439,  439,  439,  440,  440,  440,  440,

      440,  440,  440,  440,  440,  441,  441,  441,  441,  441,
      441,  441,  441,  441,  442,  442,  442,  442,  443,  443,
      443,  443,  443,  443,  443,  443,  443,  410,  410,  410,
      410,  410,  410,  410,  410,  410,  410,  410,  410,  410,
      410,  410,  410,  410,  410,  410,  410,  410,  410,  410,
      410,  410,  410,  410,  410,  410,  410,  410,  410,  410,
      410,  410,  410,  410,  410,  410,  410,  410,  410,  410,
      410,  410,  410,  410,  410,  410,  410,  410,  410,  410,
      410,  410,  410,  410,  410,  410,  410,  410,  410,  410,
      410,  410,  410,  410,  410,  410,  410,  410,  410,  410,

      410,  410,  410,  410,  410,  410,  410,  410,  410,  410,
      410
    } ;

YY_DECL
{
	register yy_state_type yy_current_state;
	register unsigned short *yy_cp, *yy_bp;
	register int yy_act;
	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of yytext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 411 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 2828 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;


		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
/* rule 1 can match eol */
YY_RULE_SETUP
#line 30 "tokenizer.flex"
/* ignore comments */
	YY_BREAK
case 2:
/* rule 2 can match eol */
YY_RULE_SETUP
#line 32 "tokenizer.flex"
{yyTok = S; return yyTok;}
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 34 "tokenizer.flex"
{yyTok = SGML_CD; return yyTok;}
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 35 "tokenizer.flex"
{yyTok = SGML_CD; return yyTok;}
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 36 "tokenizer.flex"
{yyTok = INCLUDES; return yyTok;}
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 37 "tokenizer.flex"
{yyTok = DASHMATCH; return yyTok;}
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 38 "tokenizer.flex"
{yyTok = BEGINSWITH; return yyTok;}
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 39 "tokenizer.flex"
{yyTok = ENDSWITH; return yyTok;}
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 40 "tokenizer.flex"
{yyTok = CONTAINS; return yyTok;}
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 41 "tokenizer.flex"
{yyTok = MEDIA_NOT; return yyTok;}
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 42 "tokenizer.flex"
{yyTok = MEDIA_ONLY; return yyTok;}
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 43 "tokenizer.flex"
{yyTok = MEDIA_AND; return yyTok;}
	YY_BREAK
case 13:
/* rule 13 can match eol */
YY_RULE_SETUP
#line 45 "tokenizer.flex"
{yyTok = STRING; return yyTok;}
	YY_BREAK
case 14:
/* rule 14 can match eol */
YY_RULE_SETUP
#line 46 "tokenizer.flex"
{yyTok = IDENT; return yyTok;}
	YY_BREAK
case 15:
/* rule 15 can match eol */
YY_RULE_SETUP
#line 47 "tokenizer.flex"
{yyTok = NTH; return yyTok;}
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 50 "tokenizer.flex"
{yyTok = HEXCOLOR; return yyTok;}
	YY_BREAK
case 17:
/* rule 17 can match eol */
YY_RULE_SETUP
#line 51 "tokenizer.flex"
{yyTok = HASH; return yyTok;}
	YY_BREAK
/* @rule tokens surrounding css declaration blocks with { } braces must start a BEGIN(at_rule) context */
case 18:
YY_RULE_SETUP
#line 53 "tokenizer.flex"
{BEGIN(mediaquery); yyTok = IMPORT_SYM; return yyTok;}
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 54 "tokenizer.flex"
{BEGIN(at_rule); yyTok = PAGE_SYM; return yyTok;}
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 55 "tokenizer.flex"
{BEGIN(mediaquery); yyTok = MEDIA_SYM; return yyTok;}
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 56 "tokenizer.flex"
{BEGIN(at_rule); yyTok = FONT_FACE_SYM; return yyTok;}
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 57 "tokenizer.flex"
{BEGIN(at_rule); yyTok = CHARSET_SYM; return yyTok;}
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 58 "tokenizer.flex"
{BEGIN(at_rule); yyTok = NAMESPACE_SYM; return yyTok; }
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 59 "tokenizer.flex"
{BEGIN(at_rule); yyTok = KHTML_RULE_SYM; return yyTok; }
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 60 "tokenizer.flex"
{yyTok = KHTML_DECLS_SYM; return yyTok; }
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 61 "tokenizer.flex"
{yyTok = KHTML_VALUE_SYM; return yyTok; }
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 62 "tokenizer.flex"
{yyTok = KHTML_SELECTORS_SYM; return yyTok; }
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 63 "tokenizer.flex"
{BEGIN(mediaquery); yyTok = KHTML_MEDIAQUERY_SYM; return yyTok; }
	YY_BREAK
case 29:
/* rule 29 can match eol */
YY_RULE_SETUP
#line 65 "tokenizer.flex"
{yyTok = IMPORTANT_SYM; return yyTok;}
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 67 "tokenizer.flex"
{yyTok = EMS; return yyTok;}
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 68 "tokenizer.flex"
{yyTok = QEMS; return yyTok;} /* quirky ems */
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 69 "tokenizer.flex"
{yyTok = EXS; return yyTok;}
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 70 "tokenizer.flex"
{yyTok = CHS; return yyTok;}
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 71 "tokenizer.flex"
{yyTok = REMS; return yyTok;}
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 72 "tokenizer.flex"
{yyTok = PXS; return yyTok;}
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 73 "tokenizer.flex"
{yyTok = CMS; return yyTok;}
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 74 "tokenizer.flex"
{yyTok = MMS; return yyTok;}
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 75 "tokenizer.flex"
{yyTok = INS; return yyTok;}
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 76 "tokenizer.flex"
{yyTok = PTS; return yyTok;}
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 77 "tokenizer.flex"
{yyTok = PCS; return yyTok;}
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 78 "tokenizer.flex"
{yyTok = DEGS; return yyTok;}
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 79 "tokenizer.flex"
{yyTok = RADS; return yyTok;}
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 80 "tokenizer.flex"
{yyTok = GRADS; return yyTok;}
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 81 "tokenizer.flex"
{yyTok = MSECS; return yyTok;}
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 82 "tokenizer.flex"
{yyTok = SECS; return yyTok;}
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 83 "tokenizer.flex"
{yyTok = HERZ; return yyTok;}
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 84 "tokenizer.flex"
{yyTok = DPI; return yyTok;}
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 85 "tokenizer.flex"
{yyTok = DPCM; return yyTok;}
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 86 "tokenizer.flex"
{yyTok = KHERZ; return yyTok;}
	YY_BREAK
case 50:
/* rule 50 can match eol */
YY_RULE_SETUP
#line 87 "tokenizer.flex"
{yyTok = DIMEN; return yyTok;}
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 88 "tokenizer.flex"
{yyTok = PERCENTAGE; return yyTok;}
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 89 "tokenizer.flex"
{yyTok = INTEGER; return yyTok;}
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 90 "tokenizer.flex"
{yyTok = FLOAT; return yyTok;}
	YY_BREAK
case 54:
YY_RULE_SETUP
#line 93 "tokenizer.flex"
{yyTok = NOTFUNCTION; return yyTok;}
	YY_BREAK
case 55:
/* rule 55 can match eol */
YY_RULE_SETUP
#line 94 "tokenizer.flex"
{yyTok = URI; return yyTok;}
	YY_BREAK
case 56:
/* rule 56 can match eol */
YY_RULE_SETUP
#line 95 "tokenizer.flex"
{yyTok = URI; return yyTok;}
	YY_BREAK
case 57:
/* rule 57 can match eol */
YY_RULE_SETUP
#line 96 "tokenizer.flex"
{yyTok = FUNCTION; return yyTok;}
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 98 "tokenizer.flex"
{yyTok = UNICODERANGE; return yyTok;}
	YY_BREAK
case 59:
YY_RULE_SETUP
#line 99 "tokenizer.flex"
{yyTok = UNICODERANGE; return yyTok;}
	YY_BREAK
case 60:
YY_RULE_SETUP
#line 101 "tokenizer.flex"
{BEGIN(block); yyTok = *yytext; return yyTok;}
	YY_BREAK
case 61:
#line 103 "tokenizer.flex"
case 62:
#line 104 "tokenizer.flex"
case 63:
#line 105 "tokenizer.flex"
case 64:
#line 106 "tokenizer.flex"
case 65:
YY_RULE_SETUP
#line 106 "tokenizer.flex"
{BEGIN(INITIAL); yyTok = *yytext; return yyTok; }
	YY_BREAK
case 66:
YY_RULE_SETUP
#line 107 "tokenizer.flex"
{yyTok = *yytext; return yyTok;}
	YY_BREAK
case 67:
YY_RULE_SETUP
#line 109 "tokenizer.flex"
ECHO;
	YY_BREAK
#line 1871 "<stdout>"
case YY_STATE_EOF(INITIAL):
case YY_END_OF_BUFFER:
case YY_STATE_EOF(mediaquery):
case YY_STATE_EOF(at_rule):
case YY_STATE_EOF(block):
	yyterminate();

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of yylex */
