/* ============================================================
 *
 * This file is a part of kipi-plugins project
 * http://www.kipi-plugins.org
 *
 * Date        : 2008-02-21
 * Description : collections selection settings page.
 *
 * Copyright (C) 2008-2011 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef SELECTION_PAGE_H
#define SELECTION_PAGE_H

// Qt includes

#include <QWidget>

// Include files for KIPI

#include <libkipi/interface.h>
#include <libkipi/imagecollection.h>

namespace KIPIFlashExportPlugin
{

class SelectionPage : public QWidget
{
    Q_OBJECT

public:

    SelectionPage(KIPI::Interface* interface, QWidget* parent);
    ~SelectionPage();

    QList<KIPI::ImageCollection> selection() const;

private:

    class SelectionPagePriv;
    SelectionPagePriv* const d;
};

}  // namespace KIPIFlashExportPlugin

#endif // SELECTION_PAGE_H
