#ifndef THUMBNAILMT_H
#define THUMBNAILMT_H

#include <qpixmap.h>
#include <qimage.h>
#include <qstring.h>

#include "thumbnailsize.h"

class ThumbnailMT {

public:

    ThumbnailMT();
    ThumbnailMT(const QImage& image);
    ~ThumbnailMT();

    ThumbnailMT(const ThumbnailMT& thumb);
    ThumbnailMT& operator= (const ThumbnailMT& thumb);

    bool isNull();
    void load(const QImage& image);
    void load(const QString& fileName);
    void load(const uchar *data, uint size);
    void fillPixmap(QPixmap& pix);
    void scale(const ThumbnailSize& thumbSize);
    void save(const QString& fileName);

    void dropShadow();

private:

    QImage mImage;

};

#endif
