/***************************************************************************
                          imageviewer.cpp  -  description
                             -------------------
    begin                : Tue Jan 15 2002
    copyright            : (C) 2002 by Renchi Raju
    email                : renchi@green.tam.uiuc.edu
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qstring.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qpainter.h>
#include <qevent.h>
#include <qsize.h>
#include <qrect.h>
#include <qapplication.h>
#include <qcursor.h>

#include <kapp.h>

#include "imageviewer.h"


ImageViewer::ImageViewer(QWidget* parent,
                           const char* name, WFlags fl)
    : QScrollView(parent, name, fl)
{
}

ImageViewer::~ImageViewer()
{
}

void ImageViewer::loadImage(QString filePath)
{

    kapp->setOverrideCursor(QCursor(WaitCursor));

    image.load(filePath);
    if (image.isNull()) {
        kapp->restoreOverrideCursor();
        return;
    }


    QWidget *d = QApplication::desktop();
    if (image.width() > d->width() || image.height() > d->height()) {
        int w, h;
        if (image.width() > d->width()) {
            w= (int) (d->width()*0.90);
            h= (int) (image.height()*((float)w/(float)image.width()));
        }
        if (image.height() > d->height()){
            h= (int) (d->height()*0.90);
            w= (int) (image.width()*((float)h/(float)image.height()));
        }
        pixmap.convertFromImage(image.scale(w,h,QImage::ScaleMin));
    }
    else {
        pixmap.convertFromImage(image);
    }
    resizeContents(pixmap.width(), pixmap.height() );
    initialResize = true;
    QSize newSize(pixmap.width()+10,pixmap.height()+10);
    resize(newSize);

    kapp->restoreOverrideCursor();
}

void ImageViewer::drawContents(QPainter* painter,int clipx,int clipy,
                                int clipw,int cliph)
{

    if (pixmap.isNull()) {
        painter->eraseRect(clipx,clipy,clipw,cliph);
    } else {
        painter->drawPixmap(clipx,clipy,pixmap,clipx,clipy,clipw,cliph);
    }

}

void ImageViewer::resizeEvent(QResizeEvent* event)
{
    if (initialResize) {
        initialResize = false;
        return;
    }
    kapp->setOverrideCursor(QCursor(WaitCursor));

    QSize newSize(event->size().width()-10,event->size().height()-10);
    pixmap.convertFromImage(image.scale(newSize,QImage::ScaleFree));
    resizeContents(pixmap.width(), pixmap.height() );
    kapp->restoreOverrideCursor();
}
