/***************************************************************************
                          gphoto_interface.h  -  description
                             -------------------
    begin                : Sun Dec 30 2001
    copyright            : (C) 2001 by Renchi Raju
    email                : renchi@green.tam.uiuc.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GPHOTO_INTERFACE_H
#define GPHOTO_INTERFACE_H


/**
  *@author Renchi Raju
  */

#include <qstring.h>
#include <qstringlist.h>
#include <qmap.h>
#include <qobject.h>
#include <qpixmap.h>

extern "C" {
	#include <stdio.h>
	#include <gphoto2.h>
}

#include "gphoto_status.h"
#include "thumbnailmt.h"
#include "mtlist.h"
#include "camerafileiteminfo.h"

/* ************************************************************************
   Camera Errors:
   ErrorGphotoSetup:         Failure to setup camera
   ErrorGphotoInit:          Failure to initialize camera
   ErrorGphotoThumb:         Failure to Download a Thumbnail
   ErrorGphotoImage:         Failure to Download an Image
   ErrorGphotoImageName:     Failure to get image name
   ErrorGphotoImageDel:      Failure to delete image
   ErrorGphotoFolder:        Failure to get Folder List/Names
   ErrorGphotoFolderFiles:   Failure to get file list from Folder
   ErrorGphotoFolderMake:    Failure to create Folder
   ErrorGphotoFolderDel:     Failure to delete folder
   ErrorGphotoUnknown:       Unknown Error
   ErrorGphotoSuccess:       Successful Operation

   ************************************************************************ */


class Gphoto_Interface {

public:

    enum Gphoto_Errors { Error=0,
                         ErrorInit,
                         ErrorSetup,
                         Success };

    Gphoto_Interface();
    ~Gphoto_Interface();


    // Camera Operation functions
    int initializeCamera(QString& errorMsg);

    int getSubFolders(const QString& folder,
                      QStringList& subFolderList,
                      QStringList& subFolderNameList,
                      int& numSubFolders, QString& errorMsg);

    int getFilesInformation(const QString& folder,
                            MTList<CameraFileItemInfo>& infoList,
                            QString& errorMsg);

    void getThumbNail(const QString& folder,
                      const QString& imageName,
                      ThumbnailMT& thumb);

    int downloadImage(const QString& folder,
                      const QString& imageName,
                      const QString& saveFile, QString& errorMsg);

    int deleteImage(const QString& folder,
                    const QString& imageName,
                    QString& errorMsg);

    int uploadImage(const QString& camFolder,
                    const QString& localImagePath,
                    const QString& uploadName,
                    QString& errorMsg);

    int makeDir(const QString& folder,
                const QString& newFolder);


    // Query functions
    bool isCameraInitialised();
    bool cameraSupportsThumbNails();
    bool cameraSupportsDelete();
    bool cameraSupportsUpload();
    bool cameraSupportsMkDir();
    bool cameraSupportsDelDir();

    // setup functions
    void getSupportedCameras(QStringList& cameraList,
                             int& numSupported);
    void getSupportedPorts(QStringList& portList);
    void getCameraSettings(QString& cameraModel,
                           QString& cameraPort,
                           QString& cameraGlobalPath);
    void saveCameraSettings(const QString& cameraModel,
                            const QString& cameraPort,
                            const QString& cameraGlobalPath);
    void getCameraPorts(const QString& cameraModel,
                        QStringList& supportedPorts);
    int  autoDetectCamera(QString& cameraModel,
                          QString& cameraPort);

    // camera information functions
    void getCameraSummary(QString& cameraSummary);
    void getCameraManual(QString& cameraManual);
    void getCameraAbout(QString& cameraAbout);

private:

    Camera *my_camera;
    CameraAbilities my_cameraAbilities;
    GPContext *glob_context;
    QString my_cameraModel;
    QString my_cameraPort;
    QString my_cameraGlobalPath;

    bool my_cameraInitialised;

    bool my_cameraSupportsThumbNails;
    bool my_cameraSupportsDelete;
    bool my_cameraSupportsUpload;
    bool my_cameraSupportsMkDir;
    bool my_cameraSupportsDelDir;

    int  setupCamera();
    void getCameraAbilities();


};



#endif
