#ifndef CAMERAICONVIEW_H
#define CAMERAICONVIEW_H

#include <qiconview.h>
#include <qstring.h>
#include <kservice.h>
#include "thumbnailsize.h"

class QPoint;
class QColor;
class CameraIconItem;

class CameraIconView : public QIconView {

    Q_OBJECT

public:

    CameraIconView(QWidget *parent);
    ~CameraIconView();

    void setThumbnailSize(const ThumbnailSize& thumbSize);
    ThumbnailSize getThumbnailSize();
    void resizeThumbnails(const ThumbnailSize& thumbSize);

    void setBackGroundColor(const QColor& color);
    void setImageViewerParams(bool useInternal,
                              const QString& viewerName);

private:

    ThumbnailSize mThumbSize;
    bool    mUseInternalImageViewer;
    QString mImageViewerName;

    void startDrag();

private slots:

    void slot_rightClicked(QIconViewItem*,
                            const QPoint&);
    void slot_doubleClicked(QIconViewItem*);


signals:

    void signal_downloadSelectedItems();
    void signal_deleteSelectedItems();
    void signal_openItem(CameraIconItem*,
                         KService::Ptr);
    void signal_resizeThumbnails();

};
#endif
