/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Thu Dec 20 12:40:20 CST 2001
    copyright            : (C) 2001 by Renchi Raju
    email                : renchi@green.tam.uiuc.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>

#include "digikam.h"

static const char *description =
	I18N_NOOP("Digikam: A KDE frontend for gphoto2");

static const char *version = "0.3";	
	
static KCmdLineOptions options[] =
{
  { 0, 0, 0 }
};

int main(int argc, char *argv[])
{

  KAboutData aboutData( "digikam", I18N_NOOP("Digikam"),
			version, description, KAboutData::License_GPL,
			"(c) 2001, Renchi Raju", 0, "http://digikam.sourceforge.net", 
			"renchi@green.tam.uiuc.edu");
  aboutData.addAuthor("Renchi Raju (Pahli Bar)",0, "renchi@green.tam.uiuc.edu");
  KCmdLineArgs::init( argc, argv, &aboutData );
  KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.

  KApplication a;
  Digikam *digikam = new Digikam();
  a.setMainWidget(digikam);
  digikam->show();  

  return a.exec();
}
