var NAVTREE =
[
  [ "Qyoto", "index.html", [
    [ "Packages", null, [
      [ "Packages", "namespaces.html", "namespaces" ],
      [ "Package Functions", "namespacemembers.html", [
        [ "All", "namespacemembers.html", "namespacemembers_dup" ],
        [ "Functions", "namespacemembers_func.html", null ],
        [ "Variables", "namespacemembers_vars.html", null ],
        [ "Typedefs", "namespacemembers_type.html", null ],
        [ "Enumerations", "namespacemembers_enum.html", "namespacemembers_enum" ]
      ] ]
    ] ],
    [ "Classes", null, [
      [ "Class List", "annotated.html", "annotated" ],
      [ "Class Index", "classes.html", null ],
      [ "Class Hierarchy", "hierarchy.html", "hierarchy" ],
      [ "Class Members", "functions.html", [
        [ "All", "functions.html", "functions_dup" ],
        [ "Functions", "functions_func.html", "functions_func" ],
        [ "Variables", "functions_vars.html", "functions_vars" ],
        [ "Enumerations", "functions_enum.html", "functions_enum" ],
        [ "Properties", "functions_prop.html", "functions_prop" ]
      ] ]
    ] ]
  ] ]
];

var NAVTREEINDEX =
[
"annotated.html",
"class_qt_core_1_1_q_abstract_file_engine_1_1_map_extension_option.html",
"class_qt_core_1_1_q_basic_atomic_int.html#a0cb709d323d820f9b40eb6c3e572cf73",
"class_qt_core_1_1_q_byte_array.html#ac8c04ca3fcc4ff6d879c874238bd3621",
"class_qt_core_1_1_q_char.html#ae58e660bde165a71f5ac00c082e232ba",
"class_qt_core_1_1_q_date.html#a784b2e571edae0a9ce929bab05f62317",
"class_qt_core_1_1_q_easing_curve.html#a358986dc8475d2781d36c86aa5770886",
"class_qt_core_1_1_q_event_loop.html#a95e6f41766db10fe2966501332a3857a",
"class_qt_core_1_1_q_file_system_watcher.html#aa3870805d9ace25885350a2069b86444",
"class_qt_core_1_1_q_internal.html#a67a78bd6c381204231b8e9df6c2ce3c2",
"class_qt_core_1_1_q_locale.html#a45837e77974d680267aa5a3935064cd7",
"class_qt_core_1_1_q_locale.html#a5a4c85abb360336f28ae0d761839df59",
"class_qt_core_1_1_q_locale.html#a7bb5a8c608e53a7833665b56a071a915",
"class_qt_core_1_1_q_meta_object.html#a7c3cd489120d332ab9d4e658bb5a2b64",
"class_qt_core_1_1_q_object.html#a2e64cc5a8789f56b865f9a658b649c96",
"class_qt_core_1_1_q_process.html#a66dbb0a48c6f3b3d6adc2a6552093b97",
"class_qt_core_1_1_q_reg_exp.html#a216e56f76444067b87bc4a300c6243f2",
"class_qt_core_1_1_q_signal_mapper.html#ae3d9d10f0ff88c9832d8b2e7724f08fa",
"class_qt_core_1_1_q_string_ref.html#ab9bd709b29c5dc04d035d11ee82655c4",
"class_qt_core_1_1_q_text_codec_plugin.html#a54b688becbecf060fcafe2aedc43c833",
"class_qt_core_1_1_q_translator.html#a51cb57e62afafce06d4be495024382d0",
"class_qt_core_1_1_q_variant.html#af8bc235d984ecbd11b93937a3434c8ec",
"class_qt_core_1_1_q_xml_stream_reader.html#ae718c5369d73739ba1b00e34a975692f",
"class_qt_core_1_1_qt.html#a3338ded9e1624d056212ca027c5d271f",
"class_qt_core_1_1_qt.html#a632272b1f891fdbe394baf8babe399fa",
"class_qt_core_1_1_qt.html#a632272b1f891fdbe394baf8babe399fa",
"class_qt_core_1_1_qt.html#a968e87de4bfb82657e22d2a36cb7a7f7",
"class_qt_core_1_1_qt.html#ae143db05e5e2fdf80aa1cb10abc5e208",
"class_qt_gui_1_1_global.html#ae274f0790d958e4641bb29cf242c5784",
"class_qt_gui_1_1_q_abstract_item_view.html#ab1125b390485d586f86432ebe90a76b2",
"class_qt_gui_1_1_q_abstract_slider.html#ac39f18113b6622be4615a1a01f20dc4e",
"class_qt_gui_1_1_q_action_group.html#a74f87a3562837004c16b0ab051959245",
"class_qt_gui_1_1_q_calendar_widget.html#a2a8f27f50e4f26de1e401899c03ee3ea",
"class_qt_gui_1_1_q_color_dialog.html#a4888b2ad3fdeedc61c99d0f641cae7aa",
"class_qt_gui_1_1_q_completer.html#a33e4e4e8e052c3b1b9e92122ae893b2f",
"class_qt_gui_1_1_q_desktop_widget.html#a698674e4279d3d1078dc340bc6ed5e4d",
"class_qt_gui_1_1_q_dock_widget.html#ac0e4f9776db15441e4d93b500596c7c5",
"class_qt_gui_1_1_q_file_icon_provider.html#a2b1a6a6d0fd66211388a07869143e81e",
"class_qt_gui_1_1_q_font.html#ace2bee4687204fe3e19009f197b40ae1",
"class_qt_gui_1_1_q_font_metrics_f.html#ab7ad6b205ddcbe1aa01f00d100221f95",
"class_qt_gui_1_1_q_graphics_anchor_layout.html#ab09d945d3953ddc450e59375e2380bce",
"class_qt_gui_1_1_q_graphics_item.html#a5ec0f649095fba556b5298a832098115",
"class_qt_gui_1_1_q_graphics_layout.html#a709e334aa01cd85bf15e56bfc24fc33e",
"class_qt_gui_1_1_q_graphics_object.html#aa4105a9104aa87220eae4c8fba2fe857",
"class_qt_gui_1_1_q_graphics_scale.html#a4eba6524eddeb44ba78a6385b2d1f7a7",
"class_qt_gui_1_1_q_graphics_scene_resize_event.html#a72ec0b792feb1eacd168f5f7e0f6c13a",
"class_qt_gui_1_1_q_graphics_widget.html#a1dd6f39e8d8a339381bc20d3890d652e",
"class_qt_gui_1_1_q_header_view.html#a7391231e8e2532b912120800febc8430",
"class_qt_gui_1_1_q_image.html#a5f118489ba5290c1b4c5572ccc560635",
"class_qt_gui_1_1_q_input_context.html#a9f482cc4eb720fabb168e61a7171344c",
"class_qt_gui_1_1_q_item_selection.html#ae8c03b875a957c9e9b85611ae02585d6",
"class_qt_gui_1_1_q_l_c_d_number.html#a373b0aafd7e15ee7b50d7a363baae560",
"class_qt_gui_1_1_q_line_edit.html#adc6dbb793d78a720164f0fd0df1bee1f",
"class_qt_gui_1_1_q_main_window.html#a9d81df51382d72eb33d4a212661951e1",
"class_qt_gui_1_1_q_mdi_sub_window.html#addc583c29fa7a9c7c5d32bd8843cf828",
"class_qt_gui_1_1_q_mouse_event.html#a06f9be840d46db62d53629597ee74e6e",
"class_qt_gui_1_1_q_paint_engine.html#ab61fdc9e96d4167d1d861c5d995a971a",
"class_qt_gui_1_1_q_painter.html#aaf94541bb2088fb87437f3815bbd06a1",
"class_qt_gui_1_1_q_palette.html#a809e1bb6f6905b99e0a9f554afa0b5db",
"class_qt_gui_1_1_q_pixmap.html#ac694853f9600a4b078f005f0315f9b96",
"class_qt_gui_1_1_q_print_engine.html#a0c9c123703a9cc915558085f68083655",
"class_qt_gui_1_1_q_printer.html#afc7e8d2ba1e9af1227ef8fe553474dd0",
"class_qt_gui_1_1_q_radial_gradient.html#ac8396a2e5a7a9d3db591c3fc4a26ddac",
"class_qt_gui_1_1_q_shortcut.html#a12636d1fe416279696bab3681cfeb2d3",
"class_qt_gui_1_1_q_spin_box.html#a0a8f2be70344baba94bc8bb490961046",
"class_qt_gui_1_1_q_standard_item.html#af6bfc125b923ddcaffb8074a9b5fb94f",
"class_qt_gui_1_1_q_style.html#a5cdc599e78ae913beb8122eea2c93d7e",
"class_qt_gui_1_1_q_style.html#a80e4f384a304186e4bac6d7e1ff54160",
"class_qt_gui_1_1_q_style.html#afd5782d96394ecb65602e8e162ee60cf",
"class_qt_gui_1_1_q_style_option_frame_v3.html#a7417212d9fee389536f93bc6a0139419",
"class_qt_gui_1_1_q_style_option_tab_bar_base_v2.html#a710a703b696397a77e5dd7eb7c536492",
"class_qt_gui_1_1_q_style_plugin.html",
"class_qt_gui_1_1_q_tab_widget.html#aff483590e05d2d8f3befb96bb1a5821f",
"class_qt_gui_1_1_q_tablet_event.html#a3c5814624f91f646274f458a0a16a6b4",
"class_qt_gui_1_1_q_text_char_format.html#ad3fc260d3fa0ededd8247005719ac261",
"class_qt_gui_1_1_q_text_document_fragment.html#ac3bd7eaf03f41db44c9ebd1d9bd304df",
"class_qt_gui_1_1_q_text_format.html#a3b1f154bb0af40b8e857f05d3f66e15f",
"class_qt_gui_1_1_q_text_layout_1_1_format_range.html",
"class_qt_gui_1_1_q_text_table_format.html",
"class_qt_gui_1_1_q_transform.html#a30c9530c5c41300a7cab6788e456f892",
"class_qt_gui_1_1_q_tree_widget_item.html#a068faac72f46eb4420195abe112266c0",
"class_qt_gui_1_1_q_validator.html#a9c997d79ef24d6bd4952b7be92e2f2af",
"class_qt_gui_1_1_q_widget.html#a41ba179f17a47389b223695e932122c6",
"class_qt_gui_1_1_q_widget_item_v2.html#ac5e0e1472f2e11be13f8c9f7d4f7a71b",
"class_qt_network_1_1_global.html#a77d6927eb20a6d03d59b785d3b95d3d3",
"class_qt_network_1_1_q_ftp.html#a5df1e008319efbf48a7bc37bc9141602",
"class_qt_network_1_1_q_http_multi_part.html#a715b105e117b21ab6411b269c13b44a9",
"class_qt_network_1_1_q_network_configuration.html#a3a9fa597408c2e819977a18eaeaa2955",
"class_qt_network_1_1_q_network_reply.html#a444c597d72c131ffcced2388b1ed289d",
"class_qt_network_1_1_q_ssl_configuration.html#a35ce412867f050f935df8a53e1167fcd",
"class_qt_network_1_1_q_udp_socket.html#af0110f5fdf14556a36afa555211b2fc8",
"class_qt_open_g_l_1_1_global.html#ad808b60e060f58d01a14552abc74cec7",
"class_qt_open_g_l_1_1_q_g_l_framebuffer_object.html#af1eed4e1cf946c5327b1816d5713a911",
"class_qt_open_g_l_1_1_q_g_l_widget.html#aeac8f648c8c7711e5939b21bd33550bd",
"class_qt_script_1_1_q_script_syntax_check_result.html",
"class_qt_sql_1_1_global.html#a69a47a3dfe549f1236b59f643a33395c",
"class_qt_sql_1_1_q_sql_driver_creator_base.html#a8cd49361206d9f6c0aec119a4f990158",
"class_qt_sql_1_1_q_sql_relational_table_model.html#a8d407868575364a599025483aeed12ab",
"class_qt_svg_1_1_global.html#a79184833b305bdcb09741857ff8edc41",
"class_qt_web_kit_1_1_q_web_element_collection.html#a2f1289740bae6b05c49d0a26aefbc0a4",
"class_qt_web_kit_1_1_q_web_page.html#a519b393d241fa58a5967073bd70e4a94",
"class_qt_web_kit_1_1_q_web_plugin_factory.html#a416d22a84fe63b00f452834b8c450fe4",
"class_qt_xml_1_1_global.html#a2b1a2d0e5c72e2b73255dd7f6185f415",
"class_qt_xml_1_1_q_dom_element.html#a8c138d202efc20a74aba7e81061f811e",
"class_qt_xml_1_1_q_xml_content_handler.html#aaa40f1772accc83830c3d9e8be2c7a1a",
"class_qt_xml_patterns_1_1_global.html#a1328729aebdaa2d566319589e3e0bca9",
"class_qt_xml_patterns_1_1_q_xml_formatter.html#a857a1d8f3b43a07576de2973e5f39d52",
"functions_prop_0x79.html",
"interface_qt_gui_1_1_i_q_dock_widget_signals.html#a33f22f5934beb3d0b03d64617271bd66",
"interface_qt_gui_1_1_i_q_graphics_object_signals.html#acc6f1e08d21ee5de231ab17e8710b95e",
"interface_qt_gui_1_1_i_q_tab_bar_signals.html#a00cad2fdb694ae086165da7e04b92d21",
"interface_qt_web_kit_1_1_i_q_web_page_signals.html#a7f8c8aedff110c96127012b2284c5692"
];

var SYNCONMSG = 'click to disable panel synchronisation';
var SYNCOFFMSG = 'click to enable panel synchronisation';
var navTreeSubIndices = new Array();

function getData(varName)
{
  var i = varName.lastIndexOf('/');
  var n = i>=0 ? varName.substring(i+1) : varName;
  return eval(n.replace(/\-/g,'_'));
}

function stripPath(uri)
{
  return uri.substring(uri.lastIndexOf('/')+1);
}

function stripPath2(uri)
{
  var i = uri.lastIndexOf('/');
  var s = uri.substring(i+1);
  var m = uri.substring(0,i+1).match(/\/d\w\/d\w\w\/$/);
  return m ? uri.substring(i-6) : s;
}

function localStorageSupported()
{
  try {
    return 'localStorage' in window && window['localStorage'] !== null && window.localStorage.getItem;
  }
  catch(e) {
    return false;
  }
}


function storeLink(link)
{
  if (!$("#nav-sync").hasClass('sync') && localStorageSupported()) {
      window.localStorage.setItem('navpath',link);
  }
}

function deleteLink()
{
  if (localStorageSupported()) {
    window.localStorage.setItem('navpath','');
  } 
}

function cachedLink()
{
  if (localStorageSupported()) {
    return window.localStorage.getItem('navpath');
  } else {
    return '';
  }
}

function getScript(scriptName,func,show)
{
  var head = document.getElementsByTagName("head")[0]; 
  var script = document.createElement('script');
  script.id = scriptName;
  script.type = 'text/javascript';
  script.onload = func; 
  script.src = scriptName+'.js'; 
  if ($.browser.msie && $.browser.version<=8) { 
    // script.onload does work with older versions of IE
    script.onreadystatechange = function() {
      if (script.readyState=='complete' || script.readyState=='loaded') { 
        func(); if (show) showRoot(); 
      }
    }
  }
  head.appendChild(script); 
}

function createIndent(o,domNode,node,level)
{
  if (node.parentNode && node.parentNode.parentNode) {
    createIndent(o,domNode,node.parentNode,level+1);
  }
  var imgNode = document.createElement("img");
  imgNode.width = 16;
  imgNode.height = 22;
  if (level==0 && node.childrenData) {
    node.plus_img = imgNode;
    node.expandToggle = document.createElement("a");
    node.expandToggle.href = "javascript:void(0)";
    node.expandToggle.onclick = function() {
      if (node.expanded) {
        $(node.getChildrenUL()).slideUp("fast");
        if (node.isLast) {
          node.plus_img.src = node.relpath+"ftv2plastnode.png";
        } else {
          node.plus_img.src = node.relpath+"ftv2pnode.png";
        }
        node.expanded = false;
      } else {
        expandNode(o, node, false, false);
      }
    }
    node.expandToggle.appendChild(imgNode);
    domNode.appendChild(node.expandToggle);
  } else {
    domNode.appendChild(imgNode);
  }
  if (level==0) {
    if (node.isLast) {
      if (node.childrenData) {
        imgNode.src = node.relpath+"ftv2plastnode.png";
      } else {
        imgNode.src = node.relpath+"ftv2lastnode.png";
        domNode.appendChild(imgNode);
      }
    } else {
      if (node.childrenData) {
        imgNode.src = node.relpath+"ftv2pnode.png";
      } else {
        imgNode.src = node.relpath+"ftv2node.png";
        domNode.appendChild(imgNode);
      }
    }
  } else {
    if (node.isLast) {
      imgNode.src = node.relpath+"ftv2blank.png";
    } else {
      imgNode.src = node.relpath+"ftv2vertline.png";
    }
  }
  imgNode.border = "0";
}

function newNode(o, po, text, link, childrenData, lastNode)
{
  var node = new Object();
  node.children = Array();
  node.childrenData = childrenData;
  node.depth = po.depth + 1;
  node.relpath = po.relpath;
  node.isLast = lastNode;

  node.li = document.createElement("li");
  po.getChildrenUL().appendChild(node.li);
  node.parentNode = po;

  node.itemDiv = document.createElement("div");
  node.itemDiv.className = "item";

  node.labelSpan = document.createElement("span");
  node.labelSpan.className = "label";

  createIndent(o,node.itemDiv,node,0);
  node.itemDiv.appendChild(node.labelSpan);
  node.li.appendChild(node.itemDiv);

  var a = document.createElement("a");
  node.labelSpan.appendChild(a);
  node.label = document.createTextNode(text);
  node.expanded = false;
  a.appendChild(node.label);
  if (link) {
    var url;
    if (link.substring(0,1)=='^') {
      url = link.substring(1);
      link = url;
    } else {
      url = node.relpath+link;
    }
    a.className = stripPath(link.replace('#',':'));
    if (link.indexOf('#')!=-1) {
      var aname = '#'+link.split('#')[1];
      var srcPage = stripPath($(location).attr('pathname'));
      var targetPage = stripPath(link.split('#')[0]);
      a.href = srcPage!=targetPage ? url : '#';
      a.onclick = function(){
        storeLink(link);
        if (!$(a).parent().parent().hasClass('selected'))
        {
          $('.item').removeClass('selected');
          $('.item').removeAttr('id');
          $(a).parent().parent().addClass('selected');
          $(a).parent().parent().attr('id','selected');
        }
        var pos, anchor = $(aname), docContent = $('#doc-content');
        if (anchor.parent().attr('class')=='memItemLeft') {
          pos = anchor.parent().position().top;
        } else if (anchor.position()) {
          pos = anchor.position().top;
        }
        if (pos) {
          var dist = Math.abs(Math.min(
                     pos-docContent.offset().top,
                     docContent[0].scrollHeight-
                     docContent.height()-docContent.scrollTop()));
          docContent.animate({
            scrollTop: pos + docContent.scrollTop() - docContent.offset().top
          },Math.max(50,Math.min(500,dist)),function(){
            window.location.replace(aname);
          });
        }
      };
    } else {
      a.href = url;
      a.onclick = function() { storeLink(link); }
    }
  } else {
    if (childrenData != null) 
    {
      a.className = "nolink";
      a.href = "javascript:void(0)";
      a.onclick = node.expandToggle.onclick;
    }
  }

  node.childrenUL = null;
  node.getChildrenUL = function() {
    if (!node.childrenUL) {
      node.childrenUL = document.createElement("ul");
      node.childrenUL.className = "children_ul";
      node.childrenUL.style.display = "none";
      node.li.appendChild(node.childrenUL);
    }
    return node.childrenUL;
  };

  return node;
}

function showRoot()
{
  var headerHeight = $("#top").height();
  var footerHeight = $("#nav-path").height();
  var windowHeight = $(window).height() - headerHeight - footerHeight;
  (function (){ // retry until we can scroll to the selected item
    try {
      var navtree=$('#nav-tree');
      navtree.scrollTo('#selected',0,{offset:-windowHeight/2});
    } catch (err) {
      setTimeout(arguments.callee, 0);
    }
  })();
}

function expandNode(o, node, imm, showRoot)
{
  if (node.childrenData && !node.expanded) {
    if (typeof(node.childrenData)==='string') {
      var varName    = node.childrenData;
      getScript(node.relpath+varName,function(){
        node.childrenData = getData(varName);
        expandNode(o, node, imm, showRoot);
      }, showRoot);
    } else {
      if (!node.childrenVisited) {
        getNode(o, node);
      } if (imm || ($.browser.msie && $.browser.version>8)) { 
        // somehow slideDown jumps to the start of tree for IE9 :-(
        $(node.getChildrenUL()).show();
      } else {
        $(node.getChildrenUL()).slideDown("fast");
      }
      if (node.isLast) {
        node.plus_img.src = node.relpath+"ftv2mlastnode.png";
      } else {
        node.plus_img.src = node.relpath+"ftv2mnode.png";
      }
      node.expanded = true;
    }
  }
}

function glowEffect(n,duration)
{
  n.addClass('glow').delay(duration).queue(function(next){
    $(this).removeClass('glow');next();
  });
}

function highlightAnchor()
{
  var anchor = $($(location).attr('hash'));
  if (anchor.parent().attr('class')=='memItemLeft'){
    var rows = $('.memberdecls tr[class$="'+
               window.location.hash.substring(1)+'"]');
    glowEffect(rows.children(),300); // member without details
  } else if (anchor.parents().slice(2).prop('tagName')=='TR') {
    glowEffect(anchor.parents('div.memitem'),1000); // enum value
  } else if (anchor.parent().attr('class')=='fieldtype'){
    glowEffect(anchor.parent().parent(),1000); // struct field
  } else if (anchor.parent().is(":header")) {
    glowEffect(anchor.parent(),1000); // section header
  } else {
    glowEffect(anchor.next(),1000); // normal member
  }
}

function selectAndHighlight(hash,n)
{
  var a;
  if (hash) {
    var link=stripPath($(location).attr('pathname'))+':'+hash.substring(1);
    a=$('.item a[class$="'+link+'"]');
  }
  if (a && a.length) {
    a.parent().parent().addClass('selected');
    a.parent().parent().attr('id','selected');
    highlightAnchor();
  } else if (n) {
    $(n.itemDiv).addClass('selected');
    $(n.itemDiv).attr('id','selected');
  }
  showRoot();
}

function showNode(o, node, index, hash)
{
  if (node && node.childrenData) {
    if (typeof(node.childrenData)==='string') {
      var varName    = node.childrenData;
      getScript(node.relpath+varName,function(){
        node.childrenData = getData(varName);
        showNode(o,node,index,hash);
      },true);
    } else {
      if (!node.childrenVisited) {
        getNode(o, node);
      }
      $(node.getChildrenUL()).show();
      if (node.isLast) {
        node.plus_img.src = node.relpath+"ftv2mlastnode.png";
      } else {
        node.plus_img.src = node.relpath+"ftv2mnode.png";
      }
      node.expanded = true;
      var n = node.children[o.breadcrumbs[index]];
      if (index+1<o.breadcrumbs.length) {
        showNode(o,n,index+1,hash);
      } else {
        if (typeof(n.childrenData)==='string') {
          var varName = n.childrenData;
          getScript(n.relpath+varName,function(){
            n.childrenData = getData(varName);
            node.expanded=false;
            showNode(o,node,index,hash); // retry with child node expanded
          },true);
        } else {
          var rootBase = stripPath(o.toroot.replace(/\..+$/, ''));
          if (rootBase=="index" || rootBase=="pages") {
            expandNode(o, n, true, true);
          }
          selectAndHighlight(hash,n);
        }
      }
    }
  } else {
    selectAndHighlight(hash);
  }
}

function getNode(o, po)
{
  po.childrenVisited = true;
  var l = po.childrenData.length-1;
  for (var i in po.childrenData) {
    var nodeData = po.childrenData[i];
    po.children[i] = newNode(o, po, nodeData[0], nodeData[1], nodeData[2],
      i==l);
  }
}

function gotoNode(o,subIndex,root,hash,relpath)
{
  var nti = navTreeSubIndices[subIndex][root+hash];
  o.breadcrumbs = $.extend(true, [], nti ? nti : navTreeSubIndices[subIndex][root]);
  if (!o.breadcrumbs && root!=NAVTREE[0][1]) { // fallback: show index
    navTo(o,NAVTREE[0][1],"",relpath);
    $('.item').removeClass('selected');
    $('.item').removeAttr('id');
  }
  if (o.breadcrumbs) {
    o.breadcrumbs.unshift(0); // add 0 for root node
    showNode(o, o.node, 0, hash);
  }
}

function navTo(o,root,hash,relpath)
{
  var link = cachedLink();
  if (link) {
    var parts = link.split('#');
    root = parts[0];
    if (parts.length>1) hash = '#'+parts[1];
    else hash='';
  }
  if (root==NAVTREE[0][1]) {
    $('#nav-sync').css('top','30px');
  } else {
    $('#nav-sync').css('top','5px');
  }
  if (hash.match(/^#l\d+$/)) {
    var anchor=$('a[name='+hash.substring(1)+']');
    glowEffect(anchor.parent(),1000); // line number
    hash=''; // strip line number anchors
    //root=root.replace(/_source\./,'.'); // source link to doc link
  }
  var url=root+hash;
  var i=-1;
  while (NAVTREEINDEX[i+1]<=url) i++;
  if (navTreeSubIndices[i]) {
    gotoNode(o,i,root,hash,relpath)
  } else {
    getScript(relpath+'navtreeindex'+i,function(){
      navTreeSubIndices[i] = eval('NAVTREEINDEX'+i);
      if (navTreeSubIndices[i]) {
        gotoNode(o,i,root,hash,relpath);
      }
    },true);
  }
}

function showSyncOff(n,relpath)
{
    n.html('<img src="'+relpath+'sync_off.png" title="'+SYNCOFFMSG+'"/>');
}

function showSyncOn(n,relpath)
{
    n.html('<img src="'+relpath+'sync_on.png"/ title="'+SYNCONMSG+'">');
}

function toggleSyncButton(relpath)
{
  var navSync = $('#nav-sync');
  if (navSync.hasClass('sync')) {
    navSync.removeClass('sync');
    showSyncOff(navSync,relpath);
    storeLink(stripPath2($(location).attr('pathname'))+$(location).attr('hash'));
  } else {
    navSync.addClass('sync');
    showSyncOn(navSync,relpath);
    deleteLink();
  }
}

function initNavTree(toroot,relpath)
{
  var o = new Object();
  o.toroot = toroot;
  o.node = new Object();
  o.node.li = document.getElementById("nav-tree-contents");
  o.node.childrenData = NAVTREE;
  o.node.children = new Array();
  o.node.childrenUL = document.createElement("ul");
  o.node.getChildrenUL = function() { return o.node.childrenUL; };
  o.node.li.appendChild(o.node.childrenUL);
  o.node.depth = 0;
  o.node.relpath = relpath;
  o.node.expanded = false;
  o.node.isLast = true;
  o.node.plus_img = document.createElement("img");
  o.node.plus_img.src = relpath+"ftv2pnode.png";
  o.node.plus_img.width = 16;
  o.node.plus_img.height = 22;

  if (localStorageSupported()) {
    var navSync = $('#nav-sync');
    if (cachedLink()) {
      showSyncOff(navSync,relpath);
      navSync.removeClass('sync');
    } else {
      showSyncOn(navSync,relpath);
    }
    navSync.click(function(){ toggleSyncButton(relpath); });
  }

  navTo(o,toroot,window.location.hash,relpath);

  $(window).bind('hashchange', function(){
     if (window.location.hash && window.location.hash.length>1){
       var a;
       if ($(location).attr('hash')){
         var clslink=stripPath($(location).attr('pathname'))+':'+
                               $(location).attr('hash').substring(1);
         a=$('.item a[class$="'+clslink+'"]');
       }
       if (a==null || !$(a).parent().parent().hasClass('selected')){
         $('.item').removeClass('selected');
         $('.item').removeAttr('id');
       }
       var link=stripPath2($(location).attr('pathname'));
       navTo(o,link,$(location).attr('hash'),relpath);
     }
  })

  $(window).load(showRoot);
}

