/***************************************************************************
 *   Copyright (C) 2008 by Dario Freddi <drf@kdemod.ath.cx>                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .        *
 ***************************************************************************/

#include "AssignmentPage.h"

#include "PowerDevilSettings.h"

#include <solid/control/powermanager.h>
#include <solid/device.h>
#include <solid/deviceinterface.h>
#include <solid/processor.h>

#include <QtDBus/QDBusMessage>
#include <QtDBus/QDBusReply>
#include <QtDBus/QDBusConnection>

#include <KConfigGroup>
#include <KLineEdit>
#include <QCheckBox>
#include <QFormLayout>
#include <KDialog>
#include <KFileDialog>
#include <KMessageBox>
#include <KIconButton>

AssignmentPage::AssignmentPage( QWidget *parent )
        : QWidget( parent )
{
    setupUi( this );

    m_profilesConfig = KSharedConfig::openConfig( "powerdevilprofilesrc", KConfig::SimpleConfig );

    fillUi();
}

AssignmentPage::~AssignmentPage()
{
}

void AssignmentPage::fillUi()
{
    reloadAvailableProfiles();

    // modified fields...

    connect( acProfile, SIGNAL( currentIndexChanged( int ) ), SLOT( emitChanged() ) );
    connect( lowProfile, SIGNAL( currentIndexChanged( int ) ), SLOT( emitChanged() ) );
    connect( warningProfile, SIGNAL( currentIndexChanged( int ) ), SLOT( emitChanged() ) );
    connect( batteryProfile, SIGNAL( currentIndexChanged( int ) ), SLOT( emitChanged() ) );
}

void AssignmentPage::load()
{
    acProfile->setCurrentIndex( acProfile->findText( PowerDevilSettings::aCProfile() ) );
    lowProfile->setCurrentIndex( acProfile->findText( PowerDevilSettings::lowProfile() ) );
    warningProfile->setCurrentIndex( acProfile->findText( PowerDevilSettings::warningProfile() ) );
    batteryProfile->setCurrentIndex( acProfile->findText( PowerDevilSettings::batteryProfile() ) );
}

void AssignmentPage::save()
{
    PowerDevilSettings::setACProfile( acProfile->currentText() );
    PowerDevilSettings::setLowProfile( lowProfile->currentText() );
    PowerDevilSettings::setWarningProfile( warningProfile->currentText() );
    PowerDevilSettings::setBatteryProfile( batteryProfile->currentText() );

    PowerDevilSettings::self()->writeConfig();
}

void AssignmentPage::emitChanged()
{
    emit changed( true );
}

void AssignmentPage::reloadAvailableProfiles()
{
    m_profilesConfig->reparseConfiguration();

    acProfile->clear();
    batteryProfile->clear();
    lowProfile->clear();
    warningProfile->clear();

    if ( m_profilesConfig->groupList().isEmpty() ) {
        kDebug() << "No available profiles!";
        return;
    }

    foreach( const QString &ent, m_profilesConfig->groupList() ) {
        KConfigGroup *group = new KConfigGroup( m_profilesConfig, ent );

        acProfile->addItem( KIcon( group->readEntry( "iconname" ) ), ent );
        batteryProfile->addItem( KIcon( group->readEntry( "iconname" ) ), ent );
        lowProfile->addItem( KIcon( group->readEntry( "iconname" ) ), ent );
        warningProfile->addItem( KIcon( group->readEntry( "iconname" ) ), ent );
    }

    acProfile->setCurrentIndex( acProfile->findText( PowerDevilSettings::aCProfile() ) );
    lowProfile->setCurrentIndex( acProfile->findText( PowerDevilSettings::lowProfile() ) );
    warningProfile->setCurrentIndex( acProfile->findText( PowerDevilSettings::warningProfile() ) );
    batteryProfile->setCurrentIndex( acProfile->findText( PowerDevilSettings::batteryProfile() ) );

}

#include "AssignmentPage.moc"
