/* Copyright (C) 2002 Philippe Fremy <pfremy@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/


//
//  -----------     Uses the vim widget ---------------
//

#include <qmainwindow.h>
#include <qmultilineedit.h>
#include <qpopupmenu.h>
#include <qmenubar.h>

#include <kprocess.h>
#include <kapp.h>
#include <kcmdlineargs.h>

#include "vimwidget.h"

class MyMW : public QMainWindow
{
public:
    MyMW() : QMainWindow() {}

    bool close( bool alsoDelete ) {
        qDebug("MyMW::close( bool )");
        centralWidget()->close( alsoDelete );
        return QMainWindow::close( alsoDelete );
    }
};


static KCmdLineOptions options[] =
{
 { "+file(s)",          "Files to load", 0 },
 { 0,0,0 }
};

static const char *version = "v0.1 2001 (c) Philippe Fremy";
static const char *description = "Test Shell for the vim widget.";

int main( int argc, char **argv )
{
	KCmdLineArgs::init(argc, argv, "VimWidgetShell", description, version);
	KCmdLineArgs::addCmdLineOptions( options ); // Add my own options.
	KApplication app;

    QMainWindow * mw = new MyMW();
    mw->setCaption("Vim Widget Editor Shell");

    QPopupMenu* file = new QPopupMenu( mw );
    file->insertItem("E&xit", qApp, SLOT(quit()));
    mw->menuBar()->insertItem( "&File", file );

    QPopupMenu* edit = new QPopupMenu( mw );
    edit->insertItem("Search");
    mw->menuBar()->insertItem( "&Edit", edit );

    QPopupMenu* test = new QPopupMenu( mw );
    test->insertItem("test");
    mw->menuBar()->insertItem( "&Test", test );

    // Central Widget
    //VimWidget * vim = new VimWidget( true, true, mw );
    VimWidget * vim = new VimWidget( mw );

    vim->openFile("TODO");

    mw->setCentralWidget( vim );
    vim->setFocus();

    mw->resize( 800, 500 );

    app.setMainWidget( mw );
    mw->show();
    app.exec();

    qDebug("qApp finished!");

    delete mw;
}

