/***************************************************************************
                               bind_histogram.h
                             -------------------
    begin                : Mar 29 2005
    copyright            : (C) 2005 The University of Toronto
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef BIND_HISTOGRAM_H
#define BIND_HISTOGRAM_H

#include "bind_dataobject.h"

#include <ksthistogram.h>

#include <kjs/interpreter.h>
#include <kjs/object.h>

/* @class Histogram
   @inherits DataObject
   @collection HistogramCollection
   @description A class representing a histogram object in Kst.
*/
class KstBindHistogram : public KstBindDataObject {
  public:
    /* @constructor
       @arg Vector vector The input vector for the histogram.  May also be
                          specified by the tagName for an existing vector.
       @optarg number xMin The minimum X value.  Default is -10.
       @optarg number xMax The maximum X value.  Default is 10.
       @optarg number bins The number of bins to use.  Default is 60.
       @description Creates a new histogram with the defined properties.
    */
    KstBindHistogram(KJS::ExecState *exec, KstHistogramPtr d);
    KstBindHistogram(KJS::ExecState *exec, KJS::Object *globalObject = 0L);
    ~KstBindHistogram();

    KJS::Object construct(KJS::ExecState *exec, const KJS::List& args);
    KJS::Value call(KJS::ExecState *exec, KJS::Object& self, const KJS::List& args);
    KJS::Value get(KJS::ExecState *exec, const KJS::Identifier& propertyName) const;
    void put(KJS::ExecState *exec, const KJS::Identifier& propertyName, const KJS::Value& value, int attr = KJS::None);
    KJS::ReferenceList propList(KJS::ExecState *exec, bool recursive = true);
    bool hasProperty(KJS::ExecState *exec, const KJS::Identifier& propertyName) const;

    /* @method setVector
       @arg Vector vector The vector for the histogram to operate on.
       @description Sets the input vector for the histogram.
    */
    KJS::Value setVector(KJS::ExecState *exec, const KJS::List& args);

    /* @method setRange
       @arg number from The starting X value.
       @arg number to The ending X value.
       @description Sets the X range for the histogram.
    */
    KJS::Value setRange(KJS::ExecState *exec, const KJS::List& args);

    /* @property boolean realTimeAutoBin
       @description If true, the histogram automatically bins in real-time.
    */
    void setRealTimeAutoBin(KJS::ExecState *exec, const KJS::Value& value);
    KJS::Value realTimeAutoBin(KJS::ExecState *exec) const;

    /* @property number normalization
       @description Set the y-axis normalization.
                    <ul>
                    <li>0 - Number in bin</li>
                    <li>1 - Percent in bin</li>
                    <li>2 - Fraction in bin</li>
                    <li>3 - Peak bin = 1.0</li>
                    </ul>
    */
    void setNormalization(KJS::ExecState *exec, const KJS::Value& value);
    KJS::Value normalization(KJS::ExecState *exec) const;

    /* @property number bins
       @description The number of bins for the histogram.
    */
    void setBins(KJS::ExecState *exec, const KJS::Value& value);
    KJS::Value bins(KJS::ExecState *exec) const;

    /* @property number xMin
       @readonly
       @description The minimum X value for the histogram.
    */
    KJS::Value xMin(KJS::ExecState *exec) const;

    /* @property number xMax
       @readonly
       @description The maximum X value for the histogram.
    */
    KJS::Value xMax(KJS::ExecState *exec) const;

    /* @property Vector xVector
       @readonly
       @description The X-axis vector generated by the histogram.
    */
    KJS::Value xVector(KJS::ExecState *exec) const;

    /* @property Vector yVector
       @readonly
       @description The Y-axis vector generated by the histogram.
    */
    KJS::Value yVector(KJS::ExecState *exec) const;

  protected:
    KstBindHistogram(int id);
    void addBindings(KJS::ExecState *exec, KJS::Object& obj);
    static KstBindDataObject *bindFactory(KJS::ExecState *exec, KstDataObjectPtr obj);
};

#endif

