/***************************************************************************
                               bind_dir.h
                             -------------------
    begin                : Mar 2 2009
    copyright            : (C) 2009 The University of British Columbia
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef BIND_DIR_H
#define BIND_DIR_H

#include "kstbinding.h"

#include <kjs/interpreter.h>
#include <kjs/object.h>

/* @class Dir
   @description An object that represents a directory.
*/
class KstBindDir : public KstBinding {
  public:
    /* @constructor
       @arg string name Name of the directory.
       @description Constructs a dir in the given directory.
    */
    KstBindDir(KJS::ExecState *exec, QDir *d);
    KstBindDir(KJS::ExecState *exec, KJS::Object *globalObject = 0L);
    ~KstBindDir();

    KJS::Object construct(KJS::ExecState *exec, const KJS::List& args);
    KJS::Value call(KJS::ExecState *exec, KJS::Object& self, const KJS::List& args);
    KJS::Value get(KJS::ExecState *exec, const KJS::Identifier& propertyName) const;
    void put(KJS::ExecState *exec, const KJS::Identifier& propertyName, const KJS::Value& value, int attr = KJS::None);
    KJS::ReferenceList propList(KJS::ExecState *exec, bool recursive = true);
    bool hasProperty(KJS::ExecState *exec, const KJS::Identifier& propertyName) const;

    /* @method fileList
       @arg string nameFilters Specifies the name filters.
       @returns StringArray
       @description Returns a list of files in the directory that match the given name filters.
    */
    KJS::Value fileList(KJS::ExecState *exec, const KJS::List& args);

    /* @method dirList
       @arg string nameFilters Specifies the name filters.
       @returns StringArray
       @description Returns a list of sub-directories in the directory that match the given name filters.
    */
    KJS::Value dirList(KJS::ExecState *exec, const KJS::List& args);

   /* @property string path
       @description The path of the folder.
    */
    void setPath(KJS::ExecState *exec, const KJS::Value& value);
    KJS::Value path(KJS::ExecState *exec) const;

  protected:
    KstBindDir(int id);
    void addBindings(KJS::ExecState *exec, KJS::Object& obj);

  public:
    QDir *_d;
};


#endif
