/***************************************************************************
                       kstpsddialog_i.cpp  -  Part of KST
                             -------------------
    begin                :
    copyright            : (C) 2003 The University of Toronto
                           (C) 2003 C. Barth Netterfield
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for Qt
#include <qcheckbox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qspinbox.h>
#include <qstring.h>
#include <qwidget.h>

// include files for KDE
#include <kcombobox.h>
#include <kdebug.h>
#include <klocale.h>
#include <kmdimainfrm.h>
#include <kmessagebox.h>
#include <kstaticdeleter.h>

// application specific inclues
#include "fftoptionswidget.h"
#include "curveappearancewidget.h"
#include "curveplacementwidget.h"
#include "kst2dplot.h"
#include "kst.h"
#include "kstdatacollection.h"
#include "kstdoc.h"
#include "kstpsddialog_i.h"
#include "kstviewwindow.h"
#include "kstvectordialog_i.h"
#include "vectorselector.h"

#define DIALOGTYPE KstPsdDialogI
#define DTYPE "Power Spectrum"
#include "dataobjectdialog.h"

static const QString defaultTag = "<Auto Name>";

KstPsdDialogI *KstPsdDialogI::_inst = 0L;
static KStaticDeleter<KstPsdDialogI> _psInst;

KstPsdDialogI *KstPsdDialogI::globalInstance() {
  if (!_inst) {
    _inst = _psInst.setObject(new KstPsdDialogI);
  }
  return _inst;
}


KstPsdDialogI::KstPsdDialogI(QWidget* parent, const char* name, bool modal, WFlags fl)
: KstPsdDialog(parent, name, modal, fl) {
  Init();
  connect(_vector, SIGNAL(newVectorCreated(const QString&)), this, SIGNAL(modified()));
}

KstPsdDialogI::~KstPsdDialogI() {
  DP = 0L;
}

KstPSDCurvePtr KstPsdDialogI::_getPtr(const QString &tagin) {
  KstPSDCurveList c = kstObjectSubList<KstDataObject, KstPSDCurve>(KST::dataObjectList);
  return *c.findTag(tagin);
}

void KstPsdDialogI::updateWindow() {
  _curvePlacement->update();
}

void KstPsdDialogI::_fillFieldsForEdit() {
  if (DP == 0L) {
    return; // shouldn't be needed
  }

  DP->readLock();

  _tagName->setText(DP->tagName());

  _vector->setSelection(DP->getVTag());

  _curveAppearance->setValue(
    DP->hasLines(), DP->hasPoints(), DP->getColor(),
    DP->Point.getType(), DP->lineWidth(), DP->lineStyle());

  /* set sample rate, Units, FFT len, and vector units */
  _kstFFTOptions->FFTLen->setValue(DP->getLen());
  _kstFFTOptions->SampRate->setText(QString::number(DP->getFreq()));

  _kstFFTOptions->VectorUnits->setText(DP->VUnits);
  _kstFFTOptions->RateUnits->setText(DP->RUnits);
  _kstFFTOptions->Apodize->setChecked(DP->getApodize());
  _kstFFTOptions->RemoveMean->setChecked(DP->getRemoveMean());
  _kstFFTOptions->Interleaved->setChecked(DP->getAverage());

  DP->readUnlock();

  _curvePlacement->hide();

  adjustSize();
  resize(minimumSizeHint());
}

void KstPsdDialogI::_fillFieldsForNew() {
  /* set tag name */
  _tagName->setText(defaultTag);

  /* set the curve placement window  */
  _curvePlacement->update();

  /* set up the fft options */
  _kstFFTOptions->update();

  //for some reason the lower widget needs to be shown first to prevent overlapping?
  _curveAppearance->hide();
  _curvePlacement->show();
  _curveAppearance->show();
  _curveAppearance->reset();

  adjustSize();
  resize(minimumSizeHint());
}

void KstPsdDialogI::update() {
  _curvePlacement->update();
  _vector->update();
}

/* returns true if succesful */
bool KstPsdDialogI::new_I() {
  QString tag_name = _tagName->text();
  if (tag_name == defaultTag) {
    tag_name = KST::suggestPSDName(_vector->selectedVector());
  }

  /* verify that the curve name is unique */
  if (KST::dataTagNameNotUnique(tag_name)) {
    _tagName->setFocus();
    return false;
  }

  if (_vector->selectedVector().isEmpty()) {
    KMessageBox::sorry(0L, i18n("New PSD not made: define vectors first."));
    return false;
  }

  KST::vectorList.lock().readLock();
  KstVectorPtr p = *KST::vectorList.findTag(_vector->selectedVector());
  KST::vectorList.lock().readUnlock();
  if (!p) {
    kdFatal() << "Bug in kst: the vector field in plotDialog (PSD) refers to "
              << "a non existant vector...." << endl;
  }


  /* create the psd curve */
  if (!_kstFFTOptions->checkValues()) {
    return false;
  } else {
    p->readLock();
    KstPSDCurvePtr curve = new KstPSDCurve(tag_name, p,
                            _kstFFTOptions->SampRate->text().toDouble(),
                            _kstFFTOptions->Interleaved->isChecked(),
                            _kstFFTOptions->FFTLen->text().toInt(),
                            _kstFFTOptions->Apodize->isChecked(),
                            _kstFFTOptions->RemoveMean->isChecked(),
                            _kstFFTOptions->VectorUnits->text(),
                            _kstFFTOptions->RateUnits->text(),
                            _curveAppearance->color());

    curve->setHasPoints(_curveAppearance->showPoints());
    curve->setHasLines(_curveAppearance->showLines());
    curve->Point.setType(_curveAppearance->pointType());
    curve->setLineWidth(_curveAppearance->lineWidth());
    curve->setLineStyle(_curveAppearance->lineStyle());

    Kst2DPlotPtr plot;
    KstViewWindow *w = dynamic_cast<KstViewWindow*>(KstApp::inst()->findWindow(_curvePlacement->_plotWindow->currentText()));
    if (!w) {
      QString n = KstApp::inst()->newWindow(KST::suggestWinName());
      w = static_cast<KstViewWindow*>(KstApp::inst()->findWindow(n));
    }
    if (w) {
      if (_curvePlacement->existingPlot()) {
        /* assign curve to plot */
        plot = dynamic_cast<Kst2DPlot*>(w->view()->findChild(_curvePlacement->plotName()).data());
        if (plot) {
          plot->addCurve(curve.data());
          w->view()->paint(P_DATA);
        }
      }

      if (_curvePlacement->newPlot()) {
        /* assign curve to plot */
        QString name = w->createPlot<Kst2DPlot>(KST::suggestPlotName());
        if (_curvePlacement->reGrid()) {
          w->view()->cleanup(_curvePlacement->columns());
        }
        plot = dynamic_cast<Kst2DPlot*>(w->view()->findChild(name).data());
        if (plot) {
          _curvePlacement->update();
          _curvePlacement->setCurrentPlot(plot->tagName());
          plot->addCurve(curve.data());
          plot->GenerateDefaultLabels();
          w->view()->paint(P_DATA);
        }
      }
    }
    p->readUnlock();
    KST::dataObjectList.lock().writeLock();
    KST::dataObjectList.append(curve.data());
    KST::dataObjectList.lock().writeUnlock();
    curve = 0L;
    emit modified();
  }
  return true;
}

/* returns true if succesful */
bool KstPsdDialogI::edit_I() {
  /* verify that the curve name is unique */
  if (_tagName->text() != DP->tagName() && KST::dataTagNameNotUnique(_tagName->text())) {
    return false;
  }

  DP->writeLock();
  DP->setTagName(_tagName->text());

  KST::vectorList.lock().readLock();
  DP->setVector(*KST::vectorList.findTag(_vector->selectedVector()));
  KST::vectorList.lock().readUnlock();

  DP->setColor(_curveAppearance->color());
  DP->setHasPoints(_curveAppearance->showPoints());
  DP->setHasLines(_curveAppearance->showLines());
  DP->setLineWidth(_curveAppearance->lineWidth());
  DP->setLineStyle(_curveAppearance->lineStyle());
  DP->Point.setType(_curveAppearance->pointType());

  if (!_kstFFTOptions->checkValues()) {
    DP->writeUnlock();
    return false;
  }

  DP->setFreq(_kstFFTOptions->SampRate->text().toDouble());
  DP->setLen(_kstFFTOptions->FFTLen->text().toInt());

  DP->VUnits = _kstFFTOptions->VectorUnits->text();
  DP->RUnits = _kstFFTOptions->RateUnits->text();

  DP->setApodize(_kstFFTOptions->Apodize->isChecked());
  DP->setRemoveMean(_kstFFTOptions->RemoveMean->isChecked());
  DP->setAverage(_kstFFTOptions->Interleaved->isChecked());
  DP->update();
  DP->writeUnlock();

  emit modified();

  return true;
}

#include "kstpsddialog_i.moc"
// vim: ts=2 sw=2 et
