/***************************************************************************
                          textitem.h  -  description
                             -------------------
    begin                : Wed Apr 18 2001
    copyright            : (C) 2005 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TEXTITEM_H
#define TEXTITEM_H

#include <kplitem.h>

/**
  * Text item class. Class for text decoration items.
  * @author Werner Stille
  */
class TextItem : public DecoItem
{
public: 
  /** Constructor */
  TextItem();
  /**
    * Constructor. Initializes corresponding to autoplot settings.
    * @param aut pointer to structure containing autoplot settings.
    */
  TextItem(KplNamespace::AutoStruct* aut);
  /**
    * Constructor. Initializes corresponding to plot file.
    * @param plo pointer to KSimpleConfig object containing item data.
    * @param aut pointer to structure containing autoplot settings.
    */
  TextItem(KSimpleConfig* plo, KplNamespace::AutoStruct* aut);
  /**
    * Constructor. Initializes corresponding to arguments.
    * @param active true for visible item.
    * @param iAlign 1: left aligned, 2: centered, 3: right aligned.
    * @param color color for text.
    * @param x x position in cm.
    * @param y y position in cm.
    * @param dir direction in degree.
    * @param relSize relative size of text.
    * @param text text.
    */
  TextItem(bool active, int iAlign, const QString& color,
           double x, double y, double dir, double relSize,
           const QString& text);
  /** Destructor */
  ~TextItem();
  virtual ItemTypes iType() const;
  virtual void draw(KplGraph* g);
#ifndef KPL_CLASSES_ONLY
  virtual void writePlo(KSimpleConfig* plo, const KURL& url, bool abs,
                        KplDoc* m) const;
  virtual void setText(QListViewItem* it, bool* arrays, bool* funcs) const;
  virtual int editItem(QWidget* parent, KplDoc* m, int i);
#endif
  virtual KplItem* copy() const;

protected:
  int iAlign;
  double dir;
  QString s;

  friend class TextDlg;
};

#endif
