/***************************************************************************
                          kfvprojectlist.h  -  description
                             -------------------
    begin                : Sat Sep 1 2001
    copyright            : (C) 2001 by Jeffrey Yu
    email                : wehjin@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KFVPROJECTLIST_H
#define KFVPROJECTLIST_H

#include <qwidget.h>

class QLayout;
class QListBox;
class QListBoxItem;
class QPushButton;

class KFMProjectList;
class KFMProject;

class KFVProject;

/**View of a projectList
  *@author Jeffrey Yu
  */

class KFVProjectList : public QWidget  {
   Q_OBJECT
public: 
	KFVProjectList(QWidget *parent=0, const char *name=0);
	~KFVProjectList();
	
	////////////////////////////////////////////////
	
	/** Retrieve the projectList for this view. */
	KFMProjectList* projectList() const;
	
	/** Select the projectList for this view.
			@param projectList The projectList to select
		*/			
	void projectList(KFMProjectList* projectList, bool prevDeleted = false);
	
private:
	KFVProject* vProject_;
	QListBox* lbNames_;
	QPushButton* pbNew_;
	QPushButton* pbDelete_;
	int currentPosition_;
	
	KFMProjectList* projectList_;
	
private: // Private methods	
	void createWidgets();
	void createListWidgets(QLayout* lParent);
	void createButtonWidgets(QLayout* lParent);
	
	/** Change the current position
			@param pos Position to select */
	void currentPosition(int pos, bool prevDeleted = false);
	
private slots: // Private slots
	void onProjectListCurrentProjectChanged(KFMProject* project);
	void onProjectListProjectAdded(KFMProject* project);
	void onProjectListProjectRemoved(KFMProject* project, int pos);
	void onProjectListContentsChanged(void);
	void onCurrentProjectNameChanged();
	void onLbNamesCurrentChanged(QListBoxItem* item);
	void onPbNewClicked();
	void onPbDeleteClicked();
};

#endif
