/***************************************************************************
                          kfocustaskpropsview.h  -  description
                             -------------------
    begin                : Sun Aug 12 2001
    copyright            : (C) 2001 by Jeffrey Yu
    email                : jeffyu@cs.stanford.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KFOCUSTASKPROPSVIEW_H
#define KFOCUSTASKPROPSVIEW_H

#include <qgroupbox.h>
#include <qmultilineedit.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qdatetime.h>

// Forward declaration of KFocus classes
class KFMTask;
class KFVDate;
class QCheckBox;

/**View of task properties
  *@author Jeffrey Yu
  */

class KFVTask : public QGroupBox  {
   Q_OBJECT
public: 
	KFVTask(QWidget *parent=0, const char *name=0);
	~KFVTask();

public: // Public methods
  /** Read the current task */
  KFMTask* task();
  /** Specify a task for the Task Properties view */
  virtual void task(KFMTask* task);

  /** Change the state of the title lineedit widget */
  void titleLineEditSelected(bool selected);

private: // Private attributes
  /** Current task */
  KFMTask* task_;
  /** Boolean set to true while we're changing the current task */
  bool taskChangeInProgress_;
  /** QLineEdit for displaying the task title */
  QLineEdit* leTitle_;
  /** QMultiLineEdit for displaying the task comments */
  QMultiLineEdit* mleComments_;
  /** KFVDate for displaying and editing the task startdate */
  KFVDate* dvStartDate_;
  /** QCheckbox for enabling and disabling the task enddate */
  QCheckBox* cbEndDate_;
  /** KFVDate for displaying and editing the task enddate */
  KFVDate* dvEndDate_;

private: // Private methods
  /** Create widgets for the view */
  void createWidgets();
  /** Create widgets for the startdate */
  void createWidgetsStartDate(QWidget* parent, QLayout* parentLayout);
  /** Create widgets for the enddate */
  void createWidgetsEndDate(QWidget* parent, QLayout* parentLayout);

private slots: // Private slots
  /** Set the values in input fields back to their defaults. */
  void resetContents();
  /** Slot for changes to the title QLineEdit */
  void onLeTitleChanged(const QString& text);
  /** Slot to receive changes to the comments QMultiLineEdit */
  void onMleCommentsChanged();
  /** Slot to receive changes to the startdate view */
  void onDvStartDateDateChanged(const QDate& date);
  /** Slot to receive toggles of the enddate checkbox */
  void onCbEndDateToggled(bool on);
  /** Slot to receive changes to the enddate view */
  void onDvEndDateDateChanged(const QDate& date);
};

#endif
