/***************************************************************************
                          kfmenddate.cpp  -  description
                             -------------------
    begin                : Thu Sep 6 2001
    copyright            : (C) 2001 by Jeffrey Yu
    email                : wehjin@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kfmenddate.h"

KFMEndDate::KFMEndDate()
: QObject(){
	type_ = NotADate;
	date_ = QDate::currentDate();
}
	
KFMEndDate::KFMEndDate(const KFMEndDate* original)
: QObject(){
	endDate(original);
}

KFMEndDate::~KFMEndDate(){
}

void KFMEndDate::endDate(const KFMEndDate* endDate){
	type_ = endDate->type();
	date_ = endDate->date();
	emit contentsChanged();
}

int KFMEndDate::operator<(const KFMEndDate& other){
	switch(type()) {
		case Absolute:
			switch(other.type()) {
				case Absolute:
					return date() < other.date();
				default: /* NotADate */
					return 1;
			}
			break;
		default: /* NotADate */
			switch(other.type()) {
				case Absolute:
					return 0;
				default: /* NotADate */
					return 0;
			}
			break;
	}
}

int KFMEndDate::operator==(const KFMEndDate& other){
	switch(type()) {
		case Absolute:
			switch(other.type()) {
				case Absolute:
					return date() == other.date();
				default: /* NotADate */
					return 0;
			}
			break;
		default: /* NotADate */
			switch(other.type()) {
				case Absolute:
					return 0;
				default: /* NotADate */
					return 1;
			}
			break;
	}
}

KFMEndDate::Type KFMEndDate::type() const{
	return type_;
}
	
void KFMEndDate::type(const Type type){
	type_ = type;
	emit contentsChanged();
}
		
		
QDate KFMEndDate::date() const{
	return date_;
}
	
void KFMEndDate::date(const QDate date){
	date_ = date;
	emit contentsChanged();
}


int KFMEndDate::eta() const{
	return QDate::currentDate().daysTo(date_);
}
