/* -*- c++ -*-
 *
 * webbrowser.h
 *
 * Copyright (C) 2003 Petter Stokke <ummo@hellokitty.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#ifndef __kmldonkey_webbrowser_h__
#define __kmldonkey_webbrowser_h__

#include <qwidget.h>
#include <qcstring.h>
#include <qvaluelist.h>
#include <kurl.h>
#include <khtml_part.h>
#include <ed2kurl.h>

class KSqueezedTextLabel;
class KProgress;
class FileInfo;
class KPushButton;

class WebBrowser : public QWidget
{
    Q_OBJECT
public:

    WebBrowser(QWidget* parent = 0, const char* name = 0);
    ~WebBrowser();

    virtual void handleED2K(const ED2KURL& url);

public slots:

    void openURL(const QString& url);
    void openURL(const KURL& url);

protected slots:

    void slotUrlSelected(const KURL& url, const KParts::URLArgs& args);
    void setStatusBarText(const QString& text);
    void loadingProgress(int percent);

    void backState();
    void forwardState();
    void goHome();

private:
    void restoreState(const QByteArray& state);
    QByteArray saveState();
    void pushState();

    KHTMLPart* browser;
    KSqueezedTextLabel* statusbar;
    KProgress* progressbar;
    KPushButton *backButton, *forwardButton, *homeButton;

    QValueList<QByteArray> history;
    uint hpos;
    KURL initialURL;
    bool initialState;
};


#endif // __kmldonkey_webbrowser_h__
