/* -*- c++ -*-
*
* previewstreamer.h
*
* Copyright (C) 2004 Petter Stokke <ummo@hellokitty.com>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.
*
*/

#ifndef __kmldonkey_kded_kmldonkey_previewstreamer_h__
#define __kmldonkey_kded_kmldonkey_previewstreamer_h__

#include "generichttpserver.h"

#include <kio/jobclasses.h>

class DonkeyHost;
class DonkeyProtocol;
class FileInfo;

class PreviewStreamerServer : public GenericHTTPServer
{
    Q_OBJECT
public:
    PreviewStreamerServer();

protected:
    virtual GenericHTTPSession* buildSession(KExtendedSocket* sock);
};

class PreviewStreamer : public GenericHTTPSession
{
    Q_OBJECT
public:
    PreviewStreamer(GenericHTTPServer* parent, KExtendedSocket* sock);
    ~PreviewStreamer();

    virtual bool processRequest(const QHttpRequestHeader& header, const QByteArray& payload);

private slots:
    void donkeyConnected();
    void donkeyDisconnected(int err);
    void donkeyMsgReceived();
    void dataArrived(KIO::Job*, const QByteArray&);
    void ioResult(KIO::Job*);

private:
    DonkeyHost* m_host;
    DonkeyProtocol* m_donkey;
    int m_ct, m_id;
    KIO::TransferJob* m_job;
    FileInfo* m_file;
    bool m_headerSent;
    Q_ULLONG m_streamed;
};

#endif
