/* -*- c++ -*-
 *
 * mmserver.h
 *
 * Copyright (C) 2003 Petter Stokke <ummo@hellokitty.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#ifndef __kmldonkey_mobilemule_mmserver_h__
#define __kmldonkey_mobilemule_mmserver_h__

#include "donkeyprotocol.h"
#include "fileinfo.h"
#include <kextsock.h>

#define  MMS_BLOCKTIME     600000

class MMConnection;
class MMPacket;
class HostManager;

class ConsoleStatusCallback : public QObject, public ConsoleCallbackInterface
{
    Q_OBJECT
public:
    ConsoleStatusCallback(QObject* parent);
    virtual void callback(const QString& cmd, const QString& res);
signals:
    void updatedInfo(const QString& nick, int maxUp, int maxDown);
};

class MMServer : public KExtendedSocket
{
    Q_OBJECT

public:
    MMServer(const QString& listenAddress, int listenPort, const QString& host, const QString& password = QString::null);

    const char* getContentType();

protected slots:
    void hostListUpdated();
    void donkeyDisconnected(int);
    void donkeyConnected();
    void incomingConnection();

    void processMessage(MMConnection* sender, MMPacket* p);
    void processHelloPacket(MMPacket* p, MMConnection* sender);
    void processStatusRequest(MMConnection* sender, MMPacket* packet = 0);
    void processFileListRequest(MMConnection* sender, MMPacket* packet = 0);
    void processFinishedListRequest(MMConnection* sender);
    void processFileCommand(MMPacket* data, MMConnection* sender);
    void processDetailRequest(MMPacket* data, MMConnection* sender);
    void processCommandRequest(MMPacket* data, MMConnection* sender);
    void processSearchRequest(MMPacket* data, MMConnection* sender);
    void processChangeLimitRequest(MMPacket* data, MMConnection* sender);
    void processDownloadRequest(MMPacket* data, MMConnection* sender);
    void processPreviewRequest(MMPacket* data, MMConnection* sender);

    void clientStats(int64 ul, int64 dl, int64 sh, int nsh, int tul, int tdl, int uul, int udl, int ndl, int ncp, QMap<int,int>* nws);
    void updatedConnectedServers();
    void updatedOptionInfo(const QString& nick, int ul, int dl);

private:
    DonkeyProtocol* donkey;
    HostManager* hostManager;

    QString m_donkeyHost;
    bool m_donkeyConnected, m_useFakeContentType;
    int16 m_sessionID;
    int m_dwBlocked, m_cPWFailed;
    QString m_password;

    int64 m_uploaded, m_downloaded, m_shared;
    int m_sharedFiles, m_tcpUpload, m_tcpDownload, m_udpUpload, m_udpDownload, m_downloadingFiles, m_completedFiles;
    QMap<int,int> m_networks;
    const ServerInfo* m_currentServer;
    QValueList<FileInfo> m_sentFileList, m_sentFinishedList;
    int m_maxUpload, m_maxDownload;
    QString m_nick;
};

#endif
