/* -*- c++ -*-
*
* coreterminationdialog.cpp
*
* Copyright (C) 2004 Petter Stokke <ummo@hellokitty.com>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.
*
*/

#include "coreterminationdialog.h"

#include "corelauncher.h"

#include <kdebug.h>
#include <klocale.h>
#include <kguiitem.h>
#include <kactivelabel.h>
#include <kapplication.h>
#include <kiconloader.h>
#include <ktextbrowser.h>
#include <qlabel.h>
#include <qlayout.h>

CoreTerminationDialog::CoreTerminationDialog( CoreProcess* core, QWidget *parent, const char *name )
    : KDialogBase( parent, name, false, i18n("KMLDonkey Core Launcher Error"), User1|User2|Details, User1, true,
		   KGuiItem("&Ignore", "stop"), KGuiItem("&Restart core", "reload") )
    , m_core(core->id())
{
    QWidget* content = new QWidget(this);
    content->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed);
    QHBoxLayout* l = new QHBoxLayout(content);
    l->setMargin(KDialog::marginHint());
    l->setSpacing(KDialog::spacingHint());
    QLabel* icon = new QLabel(content);
    icon->setPixmap(KApplication::kApplication()->iconLoader()->loadIcon("messagebox_warning",
									 KIcon::NoGroup, KIcon::SizeMedium,
									 KIcon::DefaultState, 0, true));
    l->addWidget(icon, 0, AlignCenter);
    l->addSpacing(KDialog::spacingHint());
    QString text(i18n("The core \"<b>%1</b>\" terminated unexpectedly.\n\nWhat do you want to do about it?").arg(m_core));
    KActiveLabel* label = new KActiveLabel(text, content);
    l->addWidget(label);
    
    KTextBrowser* log = new KTextBrowser(this);
    log->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);
    log->setTextFormat(LogText);
    log->setText(core->output());
    log->scrollToBottom();

    setMainWidget(content);
    setDetailsWidget(log);

    connect(this, SIGNAL(user1Clicked()), SLOT(delayedDestruct()));
    connect(this, SIGNAL(user2Clicked()), SLOT(requestRestart()));
}

void CoreTerminationDialog::requestRestart()
{
    emit restartCore(m_core);
    delayedDestruct();
}





#include "coreterminationdialog.moc"
