/***************************************************************************
                          splineitem.h  -  description
                             -------------------
    begin                : Wed Feb 27 2002
    copyright            : (C) 2004 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SPLINEITEM_H
#define SPLINEITEM_H

#include <kplitem.h>

/**
  * Spline item class. Class for smoothing spline items for plotting spline
  * interpolations, derivatives or integrals by lines or markers.
  * @author Werner Stille
  */
class SplineItem : public ScaledItem {
public: 
  /** Constructor */
  SplineItem();
  /** Copy constructor */
  SplineItem(const SplineItem& f);
  /**
    * Constructor. Initializes corresponding to autoplot settings.
    * @param aut pointer to structure containing autoplot settings.
    */
  SplineItem(Kpl::AutoStruct* aut);
  /**
    * Constructor. Initializes corresponding to plot file.
    * @param plo pointer to KSimpleConfig object containing item data.
    * @param aut pointer to structure containing autoplot settings.
    * @param url URL of plot file.
    */
  SplineItem(KSimpleConfig* plo, Kpl::AutoStruct* aut, const KURL& url);
  /**
    * Constructor. Initializes corresponding to arguments.
    * @param active true for visible item.
    * @param fillStyle > 0 for filled polygon representation.
    * @param symb 0 for circles, < 0 for different markers,
    * >0 for different line types.
    * @param color color for function plot.
    * @param fx normalization factor for x values.
    * @param fy normalization factor for y values.
    * @param xmin minimum argument value.
    * @param xmax maximum argument value.
    * @param dx argument stepsize.
    * @param deriv order of derivative.
    * @param low lower limit for spline integral.
    * @param relSize relative size of lines or symbols.
    */
  SplineItem(bool active, int fillStyle, int symb, const QString& color,
             double fx, double fy, double xmin, double xmax, double dx,
             int deriv, double low, double relSize = 1.0);
  /** Destructor */
  ~SplineItem();
  /** Assignment operator */
  SplineItem& operator=(const SplineItem& f);
  virtual ItemTypes iType() const;
  virtual void draw(KplGraph* g);
  virtual void writePlo(KSimpleConfig* plo, const KURL& url, bool abs,
                        KplDoc* m) const;
  virtual void setText(KplCheckListItem* it, bool* arrays, bool* funcs) const;
  virtual int editItem(QWidget* parent, KplDoc* m, int i);
  virtual KplItem* copy() const;
  virtual void expoItem(int* iex, int* iey, double* fx, double* fy) const;
  virtual void minMax(double* xmi, double* xma, double* ymi, double* yma) const;
  virtual void exportTable(QTextStream& ts, KplDoc* m) const;

protected:
  /**
   * Calculates spline value table.
   * @param logx true for logarithmic steps
   * @return number of rows.
   */
  int calcTable(bool logx) const;
  mutable bool logxo;
  int kdeg, nk, nderiv;
  mutable int kdego, nko, nderivo;
  double xmin, xmax, dx, xlow;
  mutable double xmino, xmaxo, dxo, xlowo;
  mutable QArray<double> xv, yv, t, c;

  friend class FuncDlg;
  friend class KplView;
  friend class RootDlg;
  friend class SplFitDlg;
  friend class SplineDlg;
};

#endif
