/*
 * KMLOFax
 *
 * A utility to process facsimiles received with a modem of the
 * ELSA MicroLink Office family.
 *
 * Copyright (C) 1999,2000,2001,2002 Oliver Gantz <Oliver.Gantz@epost.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef MAILDLG_H
#define MAILDLG_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif 

#include <stdio.h>

#include <qwidget.h>
#include <qlineedit.h>
#include <qmultilinedit.h>
#include <qstring.h>

#include <kdialog.h>
#include <kconfig.h>

#include <mimelib/smtp.h>
#include <mimelib/string.h>


class MailClient : public DwSmtpClient
{
public:
	MailClient();
	virtual ~MailClient();
	
	bool SendDataMult(const DwString& aStr);
	bool SendDataMult(const char *aBuf, int aBufLen);

	void createBoundary();

	bool connect(const char *server, int port);
	bool sendHeader(const char *from,  const char *to, const char *subj);
	bool sendBody(const char *body);
	bool sendFile(FILE *stream);
	void disconnect();

private:
	bool connected;

	char boundary[40];
};



class MailDlg : public KDialog
{
	Q_OBJECT
public:
	MailDlg(QWidget *parent = 0, const char *name = 0);
	~MailDlg();

	void mailFax(const QString& name);

protected slots:
	void slotHelp();
	void slotSend();

private:
	KConfig *config;
	
	QLineEdit *header_to;
	QLineEdit *header_subject;
	QMultiLineEdit *body;

	QString m_name;
};


#endif // MAILDLG_H
