/*
 * KMLOFax
 *
 * A utility to process facsimiles received with a modem of the
 * ELSA MicroLink Office family.
 *
 * Copyright (C) 1999,2000,2001,2002 Oliver Gantz <Oliver.Gantz@epost.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * ------
 * PostScript(R) is a registered trademark of Adobe Systems Incorporated.
 */

#ifndef FILTERS_H
#define FILTERS_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>

#include <qstring.h>
#include <qdatetime.h>

#include "mlofile.h"



class MLOFilter
{
public:
	MLOFilter();
	MLOFilter(const QString &infile);
	~MLOFilter();

	void setFile(const QString &infile);
	void setRange(int first, int last);
	void setTime(const QDateTime &time);
	void setTime(int year, int month, int day, int hour, int minute, int second);

private:	
	void init();

protected:
	MLOFile mlofile;
	int m_first, m_last;
	int m_pages;
	QDateTime m_time;
};


inline void MLOFilter::setRange(int first, int last)
{	m_first = first; m_last = last; }


inline void MLOFilter::setTime(const QDateTime &time)
{ m_time = time; }



class MLO2TiffFilter: public MLOFilter
{
public:
	MLO2TiffFilter();
	MLO2TiffFilter(const QString &infile);
	~MLO2TiffFilter();

	bool convertFile(const QString &outfile);

private:	
	bool convertPage(int page);

protected:
	TiffFile tifffile;
};



class TiffFilter
{
public:
	TiffFilter();
	TiffFilter(const QString &infile);
	~TiffFilter();

	void setFile(const QString &infile);
	void setRange(int first, int last);
	
	bool convertFile(FILE *stream);

private:
	void init();

protected:
	TiffFile tifffile;
	int m_first, m_last;
	int m_pages;
	FILE *f;
};


inline void TiffFilter::setRange(int first, int last)
{	m_first = first; m_last = last; }



class Tiff2TiffFilter: public TiffFilter
{
public:
	Tiff2TiffFilter();
	~Tiff2TiffFilter();

	bool convertFile(const QString &outfile);

private:
	bool convertPage(int page);

protected:
	TiffFile tiffout;
};


class Tiff2PSFilter: public TiffFilter
{
public:
	Tiff2PSFilter();
	Tiff2PSFilter(const QString &infile);
	~Tiff2PSFilter();

	void setFormat(int format, bool landscape);
	void setLevel2(bool l2);
	void setInterpolate(bool interp);
	void setCopies(int copies);
	void setRibbons(bool ribbons_);
	void setMargins(int left, int right, int top, int bottom);

	bool convertFile(FILE *stream);

private:
	void init();

	bool convertPage(int tiff_page, int sub_page, int ps_page, int lines, int strech_y);
	
	bool writeLine(const QString &s);

	void writeBase85(uchar c);
	void flushBase85();

	void writeImageData(char c);
	void flushImageData();

	void resetImageData();

	int paper_x, paper_y;
	bool landscape;
	bool level2;
	bool interpolate;
	int doc_copies;
	bool ribbons;
	int l_margin, r_margin, t_margin, b_margin;

	int size_x, size_y;
	int view_x, view_y;
	int scale_x, scale_y;
	int trans_x, trans_y;

	uchar base85_buff[4];
	int base85_ind;

	char image_buff[254];
	int image_ind;
};


inline void Tiff2PSFilter::setLevel2(bool l2)
{ level2 = l2; }


inline void Tiff2PSFilter::setInterpolate(bool interp)
{	interpolate = interp; }


inline void Tiff2PSFilter::setMargins(int left, int right, int top, int bottom)
{
	l_margin = left;
	r_margin = right;
	t_margin = top;
	b_margin = bottom;
}


inline void Tiff2PSFilter::setCopies(int copies)
{	doc_copies = copies; }


inline void Tiff2PSFilter::setRibbons(bool ribbons_)
{ ribbons = ribbons_; }



#endif // FILTERS_H
