/*
 *   filetypeeditComponent.cpp
 *
 *   Copyright (C) 2004 Waldo Bastian <bastian@kde.org>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License version 2 as
 *   published by the Free Software Foundation.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "filetypeeditComponent.h"

#include <qdir.h>
#include <qdom.h>
#include <qfileinfo.h>

#include <kapplication.h>
#include <kdebug.h>
#include <kmimetype.h>
#include <kprocess.h>
#include <ksavefile.h>
#include <ksimpleconfig.h>
#include <kstandarddirs.h>
#include <kurl.h>

#include "kioskrun.h"
#include "kiosksync.h"

FileTypeEditComponent::FileTypeEditComponent( QObject *parent)
 : Component(parent)
{
}

FileTypeEditComponent::~FileTypeEditComponent()
{
}

void
FileTypeEditComponent::slotSetupPrepare()
{
}

void
FileTypeEditComponent::slotSetupStarted()
{
}

bool
FileTypeEditComponent::setupFinished()
{
   bool result;

   // Install mimetype files
   {
      QString mimetypeFiles = KioskRun::self()->locateLocal("mime", QString::null);
      QString mimetypeSaveFiles = KioskRun::self()->locateSave("mime", QString::null);
      
      KioskSync mimeDir(kapp->mainWidget());
      mimeDir.addDir(mimetypeFiles, KURL());

      QStringList newMimetypeFiles = mimeDir.listFiles();
   
      for(QStringList::ConstIterator it = newMimetypeFiles.begin();
          it != newMimetypeFiles.end(); ++it)
      {
         if ((*it).endsWith(".desktop"))
         {
            kdDebug() << "FileTypeEditComponent: New mimetype file %s" << (mimetypeFiles+(*it)) << endl;
            result = KioskRun::self()->install(mimetypeFiles+(*it), mimetypeSaveFiles+(*it));
            if (!result) return false;
         }
      }
   }

   // Install legacy .desktop files
   {
      QString legacyApplications = KioskRun::self()->locateLocal("apps", QString::null);
      QString legacySaveApplications = KioskRun::self()->locateSave("apps", QString::null);
      
      KioskSync legacyDir(kapp->mainWidget());
      legacyDir.addDir(legacyApplications, KURL());

      QStringList newLegacyApplications = legacyDir.listFiles();
   
      for(QStringList::ConstIterator it = newLegacyApplications.begin();
          it != newLegacyApplications.end(); ++it)
      {
         if ((*it).endsWith(".desktop") || (*it).endsWith(".kdelnk") || (*it).endsWith(".directory"))
         {
            kdDebug() << "MenueditComponent: New legacy file %s" << (legacyApplications+(*it)) << endl;
            result = KioskRun::self()->install(legacyApplications+(*it), legacySaveApplications+(*it));
            if (!result) return false;
         }
      }
   }

   // Install .desktop files
   {
      QString xdgApplications = KioskRun::self()->locateLocal("xdgdata-apps", QString::null);
      QString xdgSaveApplications = KioskRun::self()->locateSave("xdgdata-apps", QString::null);

      QDir dir(xdgApplications);
      QStringList newXdgApplications = dir.entryList(QDir::All, QDir::Unsorted);
      newXdgApplications.remove(".");
      newXdgApplications.remove("..");
   
      for(QStringList::ConstIterator it = newXdgApplications.begin();
          it != newXdgApplications.end(); ++it)
      {
         if ((*it).endsWith(".desktop") || (*it).endsWith(".kdelnk"))
         {
            kdDebug() << "MenueditComponent: New .desktop file %s" << (xdgApplications+(*it)) << endl;
            result = KioskRun::self()->install(xdgApplications+(*it), xdgSaveApplications+(*it));
            if (!result) return false;
         }
      }
   }

   KioskRun::self()->forceSycocaUpdate();

   return true;
}

#include "filetypeeditComponent.moc"
