/***************************************************************************
                          ksteakmainwindow.cpp  -  description
                             -------------------
    begin                : Sat Nov 14 2000
    copyright            : (C) 2000, 2001 by Michael Heidecke
    email                : heidecke@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ksteakmainwindow.h"
#include <qtooltip.h>
#include <kiconloader.h>
#include <kmessagebox.h>
#include <kaccel.h>
#include <kwin.h>
#include <kmenubar.h>
#include <kconfig.h>
#include <klocale.h>
#include <kdatetbl.h>
#include <stdio.h>


/************************************
 * constructor - main widget        *
 ************************************/
KSteakMainWindow::KSteakMainWindow(QWidget* , const char* name) : KMainWindow(0, name)
{
  //set MainWidget
  KSteakWidget = new Ksteak(this);
  setCentralWidget(KSteakWidget);

  //create DockWidget
  SteakDock = new dockwidget();
  SteakDock->setPixmap(BarIcon("ksteak.png"));

  connect(SteakDock, SIGNAL(undock()), this, SLOT(slotUndock()));
  connect(SteakDock, SIGNAL(done()), this, SLOT(slotQuit()));
  connect(SteakDock, SIGNAL(translate()), this, SLOT(slotTranslate()));
	
  //MenuBar
  QPopupMenu *filemenu = new QPopupMenu();
  filemenu->insertItem(BarIcon("search.png"), i18n("Start &Search"), this, SLOT(slotToolbarClicked(int)),  CTRL+Key_S, TOOLBAR_SEARCH);
  filemenu->insertSeparator();
  filemenu->insertItem(i18n("&Dock to Panel"), this, SLOT(slotToolbarClicked(int)), CTRL+Key_D, TOOLBAR_DOCK);
  filemenu->insertSeparator();
  filemenu->insertItem(BarIcon("exit.png"), i18n("&Quit"),  this, SLOT(slotToolbarClicked(int)), CTRL+Key_Q, TOOLBAR_EXIT);

  viewmenu = new QPopupMenu();
  viewmenu->insertItem(i18n("Show &Toolbar"), this, SLOT(slotToggleToolbar()), 0, 1);
  viewmenu->setCheckable(TRUE);
  viewmenu->setItemChecked(1, TRUE);

  searchmenu = new QPopupMenu();
  searchmenu->insertItem(i18n("&English"), 2);
  searchmenu->insertItem(i18n("&German"), 3);
  searchmenu->insertSeparator();
  searchmenu->insertItem(i18n("Show &Context"), 4);
  searchmenu->insertItem(i18n("Case &sensitive"), 5);
  searchmenu->insertSeparator();
  searchmenu->insertItem(i18n("&AND"), 6);
  searchmenu->insertItem(i18n("&OR"), 7);
  searchmenu->setCheckable(TRUE);
  connect(searchmenu, SIGNAL(activated(int)), this, SLOT(slotMenuClicked(int)));

  menuBar()->insertItem(i18n("&File"), filemenu);
  menuBar()->insertItem(i18n("&Options"), searchmenu);
  menuBar()->insertItem(i18n("&Settings"), viewmenu);
  helpmenu = helpMenu("");
  menuBar()->insertItem(i18n("&Help"), helpmenu);

  //ToolBar
  toolBar()->insertButton(BarIcon("exit.png"), TOOLBAR_EXIT, true, i18n("Quit"));
  toolBar()->insertSeparator();
  //toolBar()->insertButton(BarIcon("bottom.png"), TOOLBAR_DOCK, true, i18n("Dock"));
  //toolBar()->insertSeparator();
  toolBar()->insertButton(BarIcon("search.png"), TOOLBAR_SEARCH, true, i18n("Search"));
  toolBar()->insertSeparator();
  toolBar()->insertButton(BarIcon("flag-en.png"), TOOLBAR_ENG, true, i18n("English"));
  toolBar()->insertButton(BarIcon("flag-de.png"), TOOLBAR_GER, true, i18n("German"));
  toolBar()->insertButton(BarIcon("contents.png"), TOOLBAR_CONTEXT, true, i18n("Context"));
  toolBar()->insertSeparator();
  toolBar()->insertButton(BarIcon("case.png"), TOOLBAR_SENSITIVE, true, i18n("Case Sensitive"));
  toolBar()->insertButton(BarIcon("and.png"), TOOLBAR_AND, true, i18n("AND"));
  toolBar()->insertButton(BarIcon("or.png"), TOOLBAR_OR, true, i18n("OR"));
  connect(toolBar(), SIGNAL(clicked(int)), this, SLOT(slotToolbarClicked(int)));
  //set toggle-buttons
  toolBar()->setToggle(TOOLBAR_ENG, TRUE);
  toolBar()->setToggle(TOOLBAR_GER, TRUE);
  toolBar()->setToggle(TOOLBAR_CONTEXT, TRUE);
  toolBar()->setToggle(TOOLBAR_SENSITIVE, TRUE);
  toolBar()->setToggle(TOOLBAR_AND, TRUE);
  toolBar()->setToggle(TOOLBAR_OR, TRUE);

  //reading config-file
  ReadConfig();
}

/*****************************************
 * destructor                            *
 *****************************************/
KSteakMainWindow::~KSteakMainWindow()
{
}

/*****************************************
 toggle Toolbar
 *****************************************/
void KSteakMainWindow::slotToggleToolbar(void)
{
  if (viewmenu->isItemChecked(1))
    {
      viewmenu->setItemChecked(1, FALSE);
      toolBar()->hide();
    }
  else
    {
      viewmenu->setItemChecked(1, TRUE);
      toolBar()->show();
    }
}

/*****************************************
 handle Toolbar-Events
 *****************************************/
void KSteakMainWindow::slotToolbarClicked(int id)
{
  switch(id)
    {
    case TOOLBAR_EXIT:	
      slotQuit();
      break;
    case TOOLBAR_SEARCH:	
      KSteakWidget->getTranslation(KSteakWidget->ViewSteak);
      break;
    case TOOLBAR_ENG:	
      if (KSteakWidget->English) KSteakWidget->English=FALSE;
      else KSteakWidget->English=TRUE;
      searchmenu->setItemChecked(2, KSteakWidget->English);
      break;
    case TOOLBAR_GER:	
      if (KSteakWidget->German) KSteakWidget->German=FALSE;
      else KSteakWidget->German=TRUE;
      searchmenu->setItemChecked(3, KSteakWidget->German);
      break;
    case TOOLBAR_CONTEXT:	
      if (KSteakWidget->Context) KSteakWidget->Context=FALSE;
      else KSteakWidget->Context=TRUE;
      searchmenu->setItemChecked(4, KSteakWidget->Context);
      break;
    case TOOLBAR_SENSITIVE:	
      if (KSteakWidget->Sensitive) KSteakWidget->Sensitive=FALSE;
      else KSteakWidget->Sensitive=TRUE;
      searchmenu->setItemChecked(5, KSteakWidget->Sensitive);
      break;
    case TOOLBAR_AND:	
      if (KSteakWidget->SearchAnd) KSteakWidget->SearchAnd=FALSE;
      else KSteakWidget->SearchAnd=TRUE;
      searchmenu->setItemChecked(6, KSteakWidget->SearchAnd);
      if (KSteakWidget->SearchOr)	//AND + OR exlusive
	{
	  KSteakWidget->SearchOr=FALSE;
	  searchmenu->setItemChecked(7, FALSE);
	  toolBar()->toggleButton(7);
	}
      break;
    case TOOLBAR_OR:	
      if (KSteakWidget->SearchOr) KSteakWidget->SearchOr=FALSE;
      else KSteakWidget->SearchOr=TRUE;
      searchmenu->setItemChecked(7, KSteakWidget->SearchOr);
      if (KSteakWidget->SearchAnd) //AND + OR exlusive
	{
	  KSteakWidget->SearchAnd=FALSE;
	  searchmenu->setItemChecked(6, FALSE);
	  toolBar()->toggleButton(6);
	}
      break;
    case TOOLBAR_DOCK: 
      slotDock();
      break;
    }
}

/*****************************************
 handle Menubar-Events
 *****************************************/
void KSteakMainWindow::slotMenuClicked(int id)
{
  toolBar()->toggleButton(id);
  slotToolbarClicked(id);
}

/*****************************************
 save Config (state of Toolbar-Buttons)
 *****************************************/
void KSteakMainWindow::SaveConfig(void)
{
  int i;
  KConfig *config = kapp->config();
  config->setGroup(0);
  //save Dock-state
  config->writeEntry("docked", KSteakWidget->docked);
  // --- added by Olaf Hartig (07.Jan.2001)
  // save windowsize
  config->writeEntry("Size", size());
  // --- end
  //save buttons state
  config->writeEntry("English", KSteakWidget->English);
  config->writeEntry("German", KSteakWidget->German);
  config->writeEntry("Context", KSteakWidget->Context);
  config->writeEntry("Sensitive", KSteakWidget->Sensitive);
  config->writeEntry("SearchAnd", KSteakWidget->SearchAnd);
  config->writeEntry("SearchOr", KSteakWidget->SearchOr);
  //save Combobox history
  config->setGroup("Combobox");
  i = KSteakWidget->LineSearch->count()-1;
  if (i >= 0) config->writeEntry("History1", KSteakWidget->LineSearch->text(i)); 	i--;
  if (i >= 0) config->writeEntry("History2", KSteakWidget->LineSearch->text(i)); 	i--;
  if (i >= 0) config->writeEntry("History3", KSteakWidget->LineSearch->text(i)); 	i--;
  if (i >= 0) config->writeEntry("History4", KSteakWidget->LineSearch->text(i));
  //save toolbar state
  config->setGroup("Toolbar");
  config->writeEntry("visible", viewmenu->isItemChecked(1));
  //write config-file
  config->sync();
}

/*****************************************
 read Config
 *****************************************/
void KSteakMainWindow::ReadConfig(void)
{
  KConfig *config = kapp->config();
  config->setGroup(0);
  if (config->readBoolEntry("docked")) slotDock();
  else slotUndock();
  // --- added by Olaf Hartig (07.Jan.2001)
  if (config->hasKey("Size"))
	{
	  QSize size = config->readSizeEntry("Size");
	  resize(size);
	}
  // --- end
  if (config->readBoolEntry("English")) slotMenuClicked(TOOLBAR_ENG);
  if (config->readBoolEntry("German")) slotMenuClicked(TOOLBAR_GER);
  if (config->readBoolEntry("Context")) slotMenuClicked(TOOLBAR_CONTEXT);
  if (config->readBoolEntry("Sensitive")) slotMenuClicked(TOOLBAR_SENSITIVE);
  if (config->readBoolEntry("SearchAnd")) slotMenuClicked(TOOLBAR_AND);
  if (config->readBoolEntry("SearchOr")) slotMenuClicked(TOOLBAR_OR);
  config->setGroup("Combobox");
  if (config->hasKey("History1")) KSteakWidget->LineSearch->insertItem(config->readEntry("History1"), -1);
  if (config->hasKey("History2")) KSteakWidget->LineSearch->insertItem(config->readEntry("History2"), -1);
  if (config->hasKey("History3")) KSteakWidget->LineSearch->insertItem(config->readEntry("History3"), -1);
  if (config->hasKey("History4")) KSteakWidget->LineSearch->insertItem(config->readEntry("History4"), -1);
  KSteakWidget->LineSearch->clearEdit();
  config->setGroup("Toolbar");
  // --- changed by Olaf Hartig (07.Jan.2001)
  if (!config->readBoolEntry("visible", true)) slotToggleToolbar();
  // --- end
}

/*****************************************
 save history before quit
 *****************************************/
void KSteakMainWindow::slotQuit(void)
{
  SaveConfig();
  kapp->quit();
}


/*****************************************
 session management - save settings
 *****************************************/
void KSteakMainWindow::saveProperties(KConfig *)
{
  SaveConfig();
}


/*****************************************
 show dockwidget + hide mainwidget
 *****************************************/
void KSteakMainWindow::slotDock(void)
{
  SteakDock->show();
  this->hide();
  KSteakWidget->docked = 1;
}

/*****************************************
 hide dockwidget + show mainwidget
 *****************************************/
void KSteakMainWindow::slotUndock(void)
{
  setActiveWindow();
  this->raise();
  this->show();

  if (KSteakWidget->docked)
    {
      SteakDock->hide();
      KSteakWidget->docked = 0;
    }
}

/*****************************************
 create a popup help-window
 *****************************************/
void KSteakMainWindow::slotTranslate(void)
{
  int x = QCursor::pos().x();
  int y = QCursor::pos().y();
  int w, h, maxw, maxh;

  //create Popup-window
  KPopupFrame *mypop = new KPopupFrame(this);

  //we dont need decorations
  mypop->setFrameStyle(QFrame::Box | QFrame::Plain);
  mypop->setLineWidth(2); //black frame 
	
  //text-viewer widget
  QTextView *myview = new QTextView(mypop);
  myview->setFrameStyle(QFrame::NoFrame);
  myview->setPaper(QBrush::QBrush(QColor(255, 255, 200))); //bgcolor
  
  KSteakWidget->getTranslation(myview);

  //set widget-size
  w = myview->viewport()->fontMetrics().width((KSteakWidget->Max)+"A")+40;
  h = myview->fontMetrics().height()*(KSteakWidget->Row+3);

  maxw = QApplication::desktop()->width()/2;
  maxh = QApplication::desktop()->height()/3;
  if ( w > maxw ) w=maxw;
  if ( h > maxh ) h=maxh;
  myview->resize(w,h);

  //clever placement
  if (x-w < 1) w = 0;
  if (y-h < 1) h = 0;
  mypop->setMainWidget(myview);
  mypop->exec(x-w, y-h);
}
