/***************************************************************************
                          decodlg.cpp  -  description
                             -------------------
    begin                : Fri Apr 20 2001
    copyright            : (C) 2001 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlayout.h>
#include <qlabel.h>
#include <klocale.h>
#include <kcolorbtn.h>
#include <kseparator.h>
#include "kpldoubleedit.h"
#include "kplspinbox.h"
#include "kpldoc.h"
#include "decodlg.h"

DecoDlg::DecoDlg(QWidget* parent, KplDoc* model, DecoItem* it0, int nrows) :
 QDialog(parent, 0, true), m(model), it(it0)
{
  vbox = new QVBoxLayout(this, 11, 6);
  grid = new QGridLayout(vbox, nrows, 7, 6);
}

DecoDlg::~DecoDlg()
{
}

void DecoDlg::initEntries(int row)
{
  grid->addWidget(new QLabel("x0", this), row, 0);
  grid->addWidget(ex0 = new KplDoubleEdit(it->x0, -200.0, 200.0, this), row, 1);
  grid->addWidget(new QLabel("cm", this), row, 2);
  grid->addItem(new QSpacerItem(20, 10, QSizePolicy::MinimumExpanding), row, 3);
  grid->addWidget(new QLabel("y0", this), row, 4);
  grid->addWidget(ey0 = new KplDoubleEdit(it->y0, -200.0, 200.0, this), row, 5);
  grid->addWidget(new QLabel("cm", this), row++, 6);
  grid->addWidget(lSize = new QLabel(i18n("Size"), this), row, 0);
  grid->addWidget(eRelSize = new KplSpinBox(10, 800, 1, this), row, 1);
  eRelSize->setValue(qRound(100 * it->relsiz));
  eRelSize->setSuffix(" %");
  grid->addWidget(new QLabel(i18n("Color"), this), row, 4);
  grid->addWidget(col = new KColorButton(it->color, this), row, 5);
}

void DecoDlg::initButtons()
{
  KSeparator* hl = new KSeparator(KSeparator::HLine, this);
  vbox->addWidget(hl);
  QHBoxLayout* hbox = new QHBoxLayout(vbox);
  hbox->addWidget(bHelp = new QPushButton(i18n("Help"), this));
  hbox->addItem(new QSpacerItem(20, 10, QSizePolicy::MinimumExpanding));
  hbox->addWidget(bOK = new QPushButton(i18n("OK"), this));
  bOK->setDefault(true);
  hbox->addWidget(bApply = new QPushButton(i18n("Apply"), this));
  QPushButton* b = new QPushButton(i18n("Cancel"), this);
  hbox->addWidget(b);
  connect(b, SIGNAL(clicked()), SLOT(reject()));
}

void DecoDlg::getValues(bool ok)
{
  it->setPos(ex0->value(), ey0->value());
  it->relsiz = 0.01 * eRelSize->interpretedValue();
  it->color = col->color().rgb();
  m->setModified();
  m->backupItems();
  if (ok)
    accept();
}
