/***************************************************************************
                          kbearsitemanager.cpp  -  description
                             -------------------
    begin                : Fri Jun 2 2000
    copyright            : (C) 2000 by Bjrn Sahlstrm
    email                : bjorn.sahlstrom@mail.bip.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "kbearsitemanager.h"
#include "kbearsitemanagermap.h"
#include "kbearsitemanagerstructs.h"
//-----------------------------------------------
KBearSiteManager::KBearSiteManager(QWidget *parent, const char *name)
	: QWidget(parent,name), newSite( false )
{
		init();
}
//-----------------------------------------------
KBearSiteManager::~KBearSiteManager(){
}
//-----------------------------------------------
void KBearSiteManager::init() {
	initDialog();
	this->setCaption(i18n("SiteManager"));
  	this->setIcon( KApplication::kApplication()->icon() );
	siteTreeView->addColumn("Name");
	userNameEdit->setEditText("");
	passwordEdit->setEchoMode( QLineEdit::Password );
	
	connect(siteEdit, SIGNAL(textChanged( const QString & )), SLOT(setEdited()));
	connect(hostNameEdit, SIGNAL(textChanged( const QString & )), SLOT(setEdited()));
	connect(portSpinBox, SIGNAL(valueChanged ( const QString & )), SLOT(setEdited()));
	connect(descriptionEdit, SIGNAL(textChanged()), SLOT(setEdited()));
	connect(userNameEdit, SIGNAL(textChanged( const QString & )), SLOT(setEdited()));
	connect(passwordEdit, SIGNAL(textChanged( const QString & )), SLOT(setEdited()));
	connect(defaultDirEdit, SIGNAL(textChanged( const QString & )), SLOT(setEdited()));
	connect(anonymousCheck, SIGNAL(toggled( bool )), SLOT(setEdited()));
	
	connect(dirButton, SIGNAL(clicked()), SLOT(slotDirButton()));
	connect(connectButton, SIGNAL(clicked()), SLOT(slotConnectButton()));
	connect(cancelButton, SIGNAL(clicked()), SLOT(slotCancelButton()));
	connect(saveButton, SIGNAL(clicked()), SLOT(slotSaveButton()));
	connect(removeButton, SIGNAL(clicked()), SLOT(slotRemoveButton()));
	connect(newButton, SIGNAL(clicked()), SLOT(slotNewButton()));
	connect(siteTreeView, SIGNAL(executed( QListViewItem * )), SLOT(slotSelectedSite(QListViewItem *)));
	connect(siteTreeView, SIGNAL(selectionChanged( QListViewItem * )), SLOT(slotSelectedSite(QListViewItem *)));
	connect( siteTreeView, SIGNAL( rightButtonPressed ( QListViewItem *, const QPoint &, int )),
						SLOT( slotActivatedMenu(QListViewItem*, const QPoint&, int)));
	connect( siteTreeView, SIGNAL( moved(QListViewItem*, QListViewItem*, QListViewItem*) ),
						SLOT( slotMoved(QListViewItem*, QListViewItem*, QListViewItem*)));
	
	siteTreeView->setSelectionMode( QListView::Single);
	fileName = locate( "appdata", "sitemanager" );
	if( ! QFile::exists( fileName ) ) // could not find the file sitemanager
		QMessageBox::critical( this, i18n("File open error !"), i18n("File:")+" sitemanager "+i18n("doesn't exist!"));
	else
		readFile( fileName );
	
	fileName = locateLocal( "appdata", "sitemanager" );
	writeFile( fileName );
	saveButton->setEnabled( false );
	QListViewItem* item = siteTreeView->findByName( "Personal" );
	if( item )
		item->setOpen( true );
}
//-----------------------------------------------
/** close the KBearSiteManager */
void KBearSiteManager::slotCancelButton(){
	close();
	emit close();
}
//-----------------------------------------------
void KBearSiteManager::slotDirButton() {
	bool ok;
	bool nameExist;
	QString name;
	do {
		nameExist = false;
		name = KLineEditDlg::getText ( i18n("Enter name for the group:"),  i18n("New Group"), &ok, this );
		if( ! ok )
			return;
		if( name == "Root" || name == "group" )
			nameExist = true;
		else
			nameExist = checkNameIntegrity( name );
	}while( nameExist );
	SiteInfo sInf;
	ConnectInfo cInf;
	sInf.info.label = name;	
	sInf.description = "group";
	if( siteTreeView->selectedItem() ) {
		SiteInfo siteInf = * mySiteMap.find( siteTreeView->selectedItem()->text(0) );
		if( siteInf.description == "group" )
			addGroup( siteTreeView->selectedItem(), name, sInf );
		else if( siteTreeView->selectedItem()->parent() )
			addGroup( siteTreeView->selectedItem()->parent(), name, sInf );
		else
			addGroup( 0, name, sInf );
	}
	else
		addGroup( 0, name, sInf );
	
	mySiteMap.insert( sInf.info.label, sInf );
	writeFile( fileName );	
}
//-----------------------------------------------
/** save the edited site to sitelist */
void KBearSiteManager::slotSaveButton(){
	SiteInfo siteInfo;
	siteInfo.info.label  = siteEdit->text();
	if( ! checkValidName( siteInfo.info.label ) ) {
		saveButton->setEnabled( false );
		return;
	}
	siteInfo.info.host = hostNameEdit->text();
	siteInfo.info.port = portSpinBox->text().toInt();
	siteInfo.info.anonym = anonymousCheck->isChecked();
	siteInfo.info.user = userNameEdit->currentText();
	siteInfo.info.pass = passwordEdit->text();
	siteInfo.info.path = defaultDirEdit->text();
	siteInfo.description = descriptionEdit->text();

	if( ! siteTreeView->selectedItem() ) {
		siteInfo.parent  = "Root";
		if( ! checkNameIntegrity( siteInfo.info.label ) ){
			mySiteMap.insert( siteInfo.info.label, siteInfo );
			siteTreeView->addFile( siteInfo.info.label );
		}
	}
	else{
		if( ((KBearTreeViewItem*)siteTreeView->selectedItem())->isFile( 0 ) ){
			SiteInfo* sInf = mySiteMap.find( siteTreeView->selectedItem()->text( 0 ) );
			bool isRoot = false;
			if( sInf->parent == "Root" ) {
				siteInfo.parent  = "Root";
				isRoot = true;
			}
			else
				siteInfo.parent  = siteTreeView->selectedItem()->parent()->text( 0 );
			if( newSite ) {
				if( isRoot )
					siteTreeView->addFile( siteInfo.info.label );
				else
					siteTreeView->addFile( siteTreeView->selectedItem()->parent(), siteInfo.info.label );
			}
   			else {
				siteTreeView->selectedItem()->setText( 0, siteInfo.info.label );			
				mySiteMap.remove( sInf->info.label );
			}
			mySiteMap.insert( siteInfo.info.label, siteInfo );
		}
		else {
			siteInfo.parent  = siteTreeView->selectedItem()->text( 0 );
			siteTreeView->addFile( siteTreeView->selectedItem(), siteInfo.info.label );
			mySiteMap.insert( siteInfo.info.label, siteInfo );
		}
	}
	siteTreeView->triggerUpdate();
	writeFile( fileName );
}
//-----------------------------------------------
/** connect to selected site */
void KBearSiteManager::slotConnectButton(){
	close();
	ConnectInfo info;
	info.label = siteEdit->text();
	info.host = hostNameEdit->text();
	info.port = portSpinBox->value();
	info.anonym = anonymousCheck->isChecked();
	info.user = userNameEdit->currentText();
	info.pass = passwordEdit->text();
	info.path = defaultDirEdit->text();
	emit remoteConnect( info );
	emit close();
}
//-----------------------------------------------
/** add a new site to site list */
void KBearSiteManager::slotNewButton(){
	clearView();
	saveButton->setEnabled( true );
	siteEdit->setFocus();
	newSite = true;
}
//-----------------------------------------------
/** removes a site from site list */
void KBearSiteManager::slotRemoveButton(){
	if( siteTreeView->selectedItem() ) {
		SiteInfo* siteInf = mySiteMap.find( siteTreeView->selectedItem()->text( 0 ) );
		if( ! siteInf )
			return;
		int exit = 0;
		if( siteInf->description == "group" ) {
			exit = KMessageBox::warningContinueCancel (this, 	i18n("Do your really want to remove the group:\n"+
										siteTreeView->selectedItem()->text(0)
										+"\nfrom your site list ?\n"+
										"All sub groups and sites will be removed as well."), i18n("Remove..."), i18n("Continue"));
		}
		else {
			exit = KMessageBox::warningContinueCancel (this, 	i18n("Do your really want to remove the site:\n"+
										siteTreeView->selectedItem()->text(0)
										+"\nfrom your site list ?\n"), i18n("Remove..."), i18n("Continue"));
		}
		if( exit == KMessageBox::Continue ) {
			QListViewItem* item = siteTreeView->selectedItem();
			removeSite( item );
			delete item;
			siteTreeView->triggerUpdate();
			clearView();
			writeFile( fileName );
		}
	}	
}
//-----------------------------------------------
void KBearSiteManager::removeSite( QListViewItem* item ){
	SiteInfo* siteInf = mySiteMap.find( item->text( 0 ) );
	if( siteInf == 0L )  // note found
		return;
	if( siteInf->description == "group" ) { // is ite a group
		SiteManagerMapIterator it;
		for( it = mySiteMap.begin(); it != mySiteMap.end(); ++it )  {
			siteInf = & it.data();
			if( siteInf->parent == item->text( 0 ) ) {
				removeSite( siteTreeView->findByName( siteInf->info.label ) );
				break;
			}
		}							
	}
	mySiteMap.remove( item->text( 0 ) );
//	delete item;
}
//-----------------------------------------------
/** display information from selected site */
void KBearSiteManager::slotSelectedSite(QListViewItem * selected){
	if( ! selected )
		return;
	if( ! ((KBearTreeViewItem*)selected)->isFile( 0 ) ) {
		selected->setOpen( ! selected->isOpen() );
		clearView();
		saveButton->setEnabled( false );
		return;
	}
	newSite = false;
	SiteInfo siteInf = * mySiteMap.find( siteTreeView->selectedItem()->text(0) );
	siteEdit->setText( siteInf.info.label );
	hostNameEdit->setText( siteInf.info.host );
	portSpinBox->setValue( siteInf.info.port );
	anonymousCheck->setChecked( siteInf.info.anonym );
	userNameEdit->setEditText( siteInf.info.user );					
	passwordEdit->setText( siteInf.info.pass );
	defaultDirEdit->setText( siteInf.info.path );
	descriptionEdit->setText( siteInf.description );
	saveButton->setEnabled( false );
}
//-----------------------------------------------
/** reset all input fields */
void KBearSiteManager::clearView(){
	siteEdit->setText("");
	hostNameEdit->setText("");
	portSpinBox->setValue(21);
	userNameEdit->setEditText("");
	anonymousCheck->setChecked(false);
	passwordEdit->setText("");
	defaultDirEdit->setText("");
	descriptionEdit->setText("");
}
//-----------------------------------------------
void KBearSiteManager::readFile( const QString& nameOfFile ){
	QFile file( nameOfFile );
	file.open(IO_ReadOnly);
	QDataStream fileStream( &file );
	fileStream >> mySiteMap;
	file.close();
	createGroupTree( 0 );
	SiteManagerMapIterator it;
	SiteInfo siteInf;
	QListViewItem* parent = 0;
	for( it = mySiteMap.begin(); it != mySiteMap.end(); ++it )  {
		siteInf = it.data();
		if( siteInf.description == "group" ) // is it a group  item
			;                                            // do nothing
		else if( ! siteTreeView->findByName( siteInf.info.label ) ) {   // isn't this item already in the tree ?
			 if( siteInf.parent == "Root" )          // is this a root item ?
				siteTreeView->addFile( siteInf.info.label ); // create it
			else {              // it wasn't a root item
				parent = siteTreeView->findByName( siteInf.parent );   // find parent
				if( parent )
					siteTreeView->addFile( parent, siteInf.info.label );
			}
		}				
	}
	saveButton->setEnabled( false );
}
//-----------------------------------------------
// enter here if siteInf:s parent isn't in the tree
void KBearSiteManager::createGroupTree( QListViewItem* parent ){
	SiteInfo siteInf;
	SiteManagerMapIterator it;
	for( it = mySiteMap.begin(); it != mySiteMap.end(); ++it )  {
		QListViewItem* item = 0;
		siteInf = it.data();
		if( siteInf.description == "group" ) {
			if( parent ) {
				if( siteInf.parent == parent->text( 0 ) ){
					item = siteTreeView->addDirectory( parent, siteInf.info.label );
				}
			}
			else if( siteInf.parent == "Root" )	{	
				item = siteTreeView->addDirectory( siteInf.info.label );
			}
			
			if( item )
				createGroupTree( item );
		}
	}
}
//-----------------------------------------------
SiteInfo* KBearSiteManager::selectedSite( const QString& name ) {
	return mySiteMap.find( name );
}
//-----------------------------------------------
void KBearSiteManager::writeFile( const QString& nameOfFile ){
	QFile file( nameOfFile );
	file.open( IO_WriteOnly );
	QDataStream fileStream( &file );
	fileStream << mySiteMap;
	file.close();
	saveButton->setEnabled( false );
	newSite = false;
}
//-----------------------------------------------
void KBearSiteManager::setConnectEnabled( bool enable ){
	connectButton->setEnabled( enable );
	cancelButton->setEnabled( enable );
}
//-----------------------------------------------
void KBearSiteManager::addGroup( QListViewItem* parent, const QString& name, SiteInfo& siteInf ) {
	if( parent ) {
		siteInf.parent = parent->text( 0 );
		siteTreeView->addDirectory( parent, name );
	}
	else {
		siteInf.parent = "Root";
		siteTreeView->addDirectory( name );
	}
	siteInf.info.host = "";
	siteInf.info.port = 0;
	siteInf.info.anonym = false;
	siteInf.info.user = "";
	siteInf.info.pass = "";
	siteInf.info.path = "";
}
//-----------------------------------------------
/** Checks if the name already exists in the sitemanager
@param name is the name to check
@return true if name exist or false if not */
bool KBearSiteManager::checkNameIntegrity( const QString& name ){
	if( mySiteMap.contains( name ) ) {
		KMessageBox::error (this, i18n("The name: "+name+" already exist !\n\n"+
														"All names in the sitemanager must be unique."),
														i18n("Name conflict"));
		return true;
	}
	return false;
}
//-----------------------------------------------
void KBearSiteManager::setEdited() {
	if( ! siteTreeView->selectedItem() ) {
		saveButton->setEnabled( true );
		return;		
	}
	SiteInfo* info = mySiteMap.find( siteTreeView->selectedItem()->text( 0 ) );
	if( info ) {
		if( info->description != "group" ) {
			saveButton->setEnabled( true );
		}
	}
}
//-----------------------------------------------
void KBearSiteManager::slotActivatedMenu( QListViewItem* item, const QPoint& p, int){
	if( ! item )
		return;
	QPopupMenu menu( this, "SiteManagerPopUp" );
	menu.insertItem ( i18n("Rename"), this, SLOT( slotRenameSite() ) );
	menu.insertSeparator();
	menu.insertItem ( i18n("Remove"), this, SLOT( slotRemoveButton() ) );
	menu.exec( p );
	// insertItem ( const QString & text, const QObject * receiver, const char * member, int accel, int id, int index )
}
//-----------------------------------------------
void KBearSiteManager::slotRenameSite(){
	bool ok;
	bool nameExist;
	QString newName;
	QString oldName = siteTreeView->selectedItem()->text( 0 );
	do {
		nameExist = false;
		newName = KLineEditDlg::getText ( i18n("Enter new name for the site:"),  oldName, &ok, this );
		if( ! ok )
			return;
		if( ! checkValidName( newName ) )
			nameExist = true;
		else
			nameExist = checkNameIntegrity( newName );
	}while( nameExist );
	
	SiteInfo siteInfo = * mySiteMap.find( oldName );
	siteInfo.info.label = newName;
	mySiteMap.remove( oldName );
	mySiteMap.insert( newName, siteInfo );
	siteTreeView->selectedItem()->setText( 0, newName );			
	siteEdit->setText( newName );
	writeFile( fileName );
	newSite = false;
}
//-----------------------------------------------
bool KBearSiteManager::checkValidName( const QString& name ){
	if( name == "" ) {
		KMessageBox::error ( this, i18n("You must set a name for the site before saving it !"));
		return false;
	}
	else if( name == "Root" || name == "group" ) {
		KMessageBox::error ( this, i18n("This name is not allowed !"));
		return false;
	}
	return true;
}
//-----------------------------------------------
/** Called when the signal @ref KListView#moved() is emitted */
void KBearSiteManager::slotMoved(QListViewItem* item, QListViewItem* /*afterFirst*/, QListViewItem* afterNow){
	SiteInfo siteInfo = * mySiteMap.find( item->text( 0 ) );	
	QListViewItem* newParent;
	if( ! afterNow ) {
		siteInfo.parent = "Root";
		newParent = 0L;
}
	else if( ((KBearTreeViewItem*)afterNow)->parent() && ((KBearTreeViewItem*)afterNow)->isFile( 0 ) ) {
		siteInfo.parent = afterNow->parent()->text( 0 );
		newParent = ((KBearTreeViewItem*)afterNow)->parent();
	}
	else if( ! ((KBearTreeViewItem*)afterNow)->parent() && ((KBearTreeViewItem*)afterNow)->isFile( 0 ) ) {
		siteInfo.parent = "Root";
		newParent = 0L;
	}
	else {
		siteInfo.parent = afterNow->text( 0 );
		newParent = afterNow;
	}
	if( newParent && afterNow )
		siteTreeView->moveItem ( item, newParent, afterNow );
	mySiteMap.remove( siteInfo.info.label );
	mySiteMap.insert( siteInfo.info.label, siteInfo );
	writeFile( fileName );
}
//-----------------------------------------------
void KBearSiteManager::saveSite( const SiteInfo& siteInfo ){
	if( ! mySiteMap.find( siteInfo.info.label ) ) {
		mySiteMap.insert( siteInfo.info.label, siteInfo );
		writeFile( fileName );
	}
}
//-----------------------------------------------
