/***************************************************************************
                          kbearfileicondrag.cpp  -  description
                             -------------------
    begin                : Sun Jul 23 2000
    copyright            : (C) 2000 by Bjrn Sahlstrm
    email                : bjorn.sahlstrom@mail.bip.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kbearfileicondrag.h"

//-----------------------------------------------
KBearFileIconDrag::KBearFileIconDrag( QWidget * dragSource, const char* name )
    : QIconDrag( dragSource, name )
{
}
//-----------------------------------------------
const char* KBearFileIconDrag::format( int i ) const {
	if ( i == 0 )
		return "application/x-qiconlist";
	else if ( i == 1 )
		return "text/uri-list";
	else
		return 0;
}
//-----------------------------------------------
QByteArray KBearFileIconDrag::encodedData( const char* mime ) const {
	QByteArray a;
	if ( QString( mime ) == "application/x-qiconlist" ) {
		a = QIconDrag::encodedData( mime );
	}
	else if ( QString( mime ) == "text/uri-list" ) {
		QString s = urls.join( "\r\n" );
		a.resize( s.length() );
		memcpy( a.data(), s.latin1(), s.length() );
	}
	return a;
}
//-----------------------------------------------
bool KBearFileIconDrag::canDecode( QMimeSource* e ) {
	return e->provides( "application/x-qiconlist" ) ||
				e->provides( "text/uri-list" );
}
//-----------------------------------------------
void KBearFileIconDrag::append( const QIconDragItem &item, const QRect &pr,
			     const QRect &tr, const QString &url ) {
	QIconDrag::append( item, pr, tr );
	urls << url;
}
//-----------------------------------------------
