#include <klocale.h>
#include <kapp.h>
#include "kropts.h"
#include "kgame.h"

KROpts::KROpts(QWidget *parent, const char *name) : QDialog(parent,name,true)
{
  initDialog();
  connect(Cancelbt, SIGNAL(clicked()), SLOT(reject()));
  connect(Okbt, SIGNAL(clicked()), SLOT(accept()));
  connect(nickch, SIGNAL(toggled(bool)), SLOT(usenick(bool)));
  nicked->setMaxLength(29);
  if (!gam->rogueNick().isEmpty())
  {
    usenick(true);
    nickch->setChecked(true);
    nicked->setText(gam->rogueNick());
  } else usenick(false);
  sleepch->setChecked(gam->warnOnRest());
  searchch->setChecked(gam->warnOnSearch());
  setCaption(i18n("Options"));
  setWhatsThis();
}

KROpts::~KROpts()
{
  removeWhatsThis();
}

void KROpts::accept()
{
  if (nickch->isChecked()) gam->setRogueNick(nicked->text());
    else gam->setRogueNick(QString::null);
  gam->setWarnOnSearch(searchch->isChecked());
  gam->setWarnOnRest(sleepch->isChecked());
  QDialog::accept();
}

void KROpts::usenick(bool use)
{
  if (use) nicked->setEnabled(true);
    else nicked->setEnabled(false);
}
